/*
 * Decompiled with CFR 0.152.
 */
package mod.crabmod.hotbath.events.enter_fluid_events;

import mod.crabmod.hotbath.util.CustomFluidHandler;
import mod.crabmod.hotbath.util.EffectRemovalHandler;
import mod.crabmod.hotbath.util.HealthRegenHandler;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="hotbath")
public class PeonyBathEvents {
    static final String PEONY_BATH_ENTERED_NUMBER = "PeonyBathEnteredNumber";
    static final String PEONY_BATH_STAYED_TIME = "PeonyBathStayedTime";
    static final String HAS_ENTERED_PEONY_BATH = "HasEnteredPeonyBath";
    static final String PEONY_BATH_EXITED_TIME = "PeonyBathExitedTime";
    private static final int TICK_NUMBER = 20;
    private static final int PEONY_BATH_ENTERED_COUNT_TRIGGER_NUMBER = 100;
    private static final int PEONY_BATH_STAYED_EFFECT_TRIGGER_TIME_SECONDS = 5;
    private static final int KNOCKBACK_RESISTANCE_DURATION = 600;
    private static final int ATTACK_SPEED_DURATION = 300;
    private static final int LUCK_DURATION = 900;
    private static final int LUCK_THRESHOLD = 50;
    private static final ResourceLocation ATTACK_SPEED_MODIFIER_NAME = ResourceLocation.fromNamespaceAndPath((String)"hotbath", (String)"peony_bath_attack_speed_modifier");
    private static final ResourceLocation KNOCKBACK_RESISTANCE_MODIFIER_NAME = ResourceLocation.fromNamespaceAndPath((String)"hotbath", (String)"peony_bath_knockback_resistance_modifier");

    @SubscribeEvent
    public static void enterPeonyBathEvents(LivingEvent.LivingTickEvent event) {
        PeonyBathEvents.enterFluidEvents(event, 100, 5, PEONY_BATH_ENTERED_NUMBER, PEONY_BATH_STAYED_TIME, HAS_ENTERED_PEONY_BATH);
    }

    public static void enterFluidEvents(LivingEvent.LivingTickEvent event, int enteredCountTriggerNumber, int stayedEffectTriggerTime, String enteredNumberInPeonyBath, String peonyBathStayedTime, String hasEnteredPeonyBath) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            CompoundTag playerData = player.getPersistentData();
            boolean isInPeonyBath = CustomFluidHandler.isPlayerInPeonyBathBlock((Player)player);
            if (isInPeonyBath && player.isAlive()) {
                if (!playerData.getBoolean(hasEnteredPeonyBath)) {
                    int enteredCount = playerData.getInt(enteredNumberInPeonyBath) + 1;
                    playerData.putInt(enteredNumberInPeonyBath, enteredCount);
                    playerData.putBoolean(hasEnteredPeonyBath, true);
                }
                int hotBathTime = playerData.getInt(peonyBathStayedTime) + 1;
                playerData.putInt(peonyBathStayedTime, hotBathTime);
                HealthRegenHandler.regenHealth(0.25f, 2.0, player);
                if (playerData.getInt(peonyBathStayedTime) >= 300) {
                    PeonyBathEvents.applyAttributeModifier(player, (Holder<Attribute>)Attributes.KNOCKBACK_RESISTANCE, 0.05, KNOCKBACK_RESISTANCE_MODIFIER_NAME, true, AttributeModifier.Operation.ADD_VALUE);
                    PeonyBathEvents.applyAttributeModifier(player, (Holder<Attribute>)Attributes.ATTACK_SPEED, 0.1, ATTACK_SPEED_MODIFIER_NAME, true, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
                    EffectRemovalHandler.removeNegativeEffects(player);
                    EffectRemovalHandler.removeBadOmen(player);
                }
                if (playerData.getInt(enteredNumberInPeonyBath) >= 50) {
                    player.addEffect(new MobEffectInstance(MobEffects.LUCK, 900, 0, false, false, true));
                }
                playerData.putInt(PEONY_BATH_EXITED_TIME, 0);
            } else {
                if (playerData.getBoolean(hasEnteredPeonyBath)) {
                    playerData.putBoolean(hasEnteredPeonyBath, false);
                }
                playerData.putInt(PEONY_BATH_EXITED_TIME, playerData.getInt(PEONY_BATH_EXITED_TIME) + 1);
                if (playerData.getInt(PEONY_BATH_EXITED_TIME) >= 300) {
                    PeonyBathEvents.applyAttributeModifier(player, (Holder<Attribute>)Attributes.ATTACK_SPEED, 0.1, ATTACK_SPEED_MODIFIER_NAME, false, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
                }
                if (playerData.getInt(PEONY_BATH_EXITED_TIME) >= 600) {
                    PeonyBathEvents.applyAttributeModifier(player, (Holder<Attribute>)Attributes.KNOCKBACK_RESISTANCE, 0.05, KNOCKBACK_RESISTANCE_MODIFIER_NAME, false, AttributeModifier.Operation.ADD_VALUE);
                }
                playerData.putInt(peonyBathStayedTime, 0);
            }
        }
    }

    private static void resetInvalidAttributes(ServerPlayer player) {
        double currentAttackSpeed;
        AttributeInstance attackSpeedAttribute = player.getAttribute(Attributes.ATTACK_SPEED);
        if (attackSpeedAttribute != null && (currentAttackSpeed = attackSpeedAttribute.getBaseValue()) < 0.0) {
            attackSpeedAttribute.setBaseValue(4.0);
        }
    }

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            PeonyBathEvents.resetInvalidAttributes(player2);
        }
    }

    private static void applyAttributeModifier(ServerPlayer player, Holder<Attribute> attribute, double value, ResourceLocation modifierName, boolean add, AttributeModifier.Operation operation) {
        AttributeInstance attributeInstance = player.getAttribute(attribute);
        if (attributeInstance != null) {
            if (add) {
                AttributeModifier modifier = new AttributeModifier(modifierName, value, operation);
                if (!attributeInstance.hasModifier(modifierName)) {
                    attributeInstance.addTransientModifier(modifier);
                }
            } else {
                attributeInstance.removeModifier(modifierName);
            }
        }
    }
}

