/*
 * Decompiled with CFR 0.152.
 */
package mod.crabmod.hotbath.events.enter_fluid_events;

import java.util.Objects;
import mod.crabmod.hotbath.util.CustomFluidHandler;
import mod.crabmod.hotbath.util.EffectRemovalHandler;
import mod.crabmod.hotbath.util.HealthRegenHandler;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="hotbath")
public class RoseBathEvents {
    private static final int TICK_NUMBER = 20;
    static final String ROSE_BATH_ENTERED_NUMBER = "RoseBathEnteredNumber";
    static final String ROSE_BATH_STAYED_TIME = "RoseBathStayedTime";
    static final String HAS_ENTERED_ROSE_BATH = "HasEnteredRoseBath";
    static final String ROSE_BATH_ADVANCEMENT_ID = "hotbath:rose_body_fragrance";
    private static final int ROSE_BATH_ENTERED_COUNT_TRIGGER_NUMBER = 100;
    private static final int ROSE_BATH_STAYED_EFFECT_TRIGGER_TIME_SECONDS = 15;

    @SubscribeEvent
    public static void enterRoseBathEvents(LivingEvent.LivingTickEvent event) {
        RoseBathEvents.enterFluidEvents(event, 100, 15, ROSE_BATH_ENTERED_NUMBER, ROSE_BATH_STAYED_TIME, HAS_ENTERED_ROSE_BATH, ROSE_BATH_ADVANCEMENT_ID);
    }

    public static void enterFluidEvents(LivingEvent.LivingTickEvent event, int enteredCountTriggerNumber, int stayedEffectTriggerTime, String enteredNumberInRoseBath, String roseBathStayedTime, String hasEnteredRoseBath, String roseBathAdvancementId) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            CompoundTag playerData = player.getPersistentData();
            boolean isInRoseBath = CustomFluidHandler.isPlayerInRoseBathBlock((Player)player);
            if (isInRoseBath && player.isAlive()) {
                if (!playerData.getBoolean(hasEnteredRoseBath)) {
                    AdvancementHolder advancement;
                    int enteredCount = playerData.getInt(enteredNumberInRoseBath) + 1;
                    playerData.putInt(enteredNumberInRoseBath, enteredCount);
                    playerData.putBoolean(hasEnteredRoseBath, true);
                    if (enteredCount >= enteredCountTriggerNumber && (advancement = Objects.requireNonNull(player.getServer()).getAdvancements().get(Objects.requireNonNull(ResourceLocation.tryParse((String)roseBathAdvancementId)))) != null) {
                        player.getAdvancements().award(advancement, "code_triggered");
                        playerData.putInt(enteredNumberInRoseBath, 0);
                    }
                }
                int roseBathStayTime = playerData.getInt(roseBathStayedTime) + 1;
                playerData.putInt(roseBathStayedTime, roseBathStayTime);
                HealthRegenHandler.regenHealth(0.25f, 1.0, player);
                if (playerData.getInt(roseBathStayedTime) >= stayedEffectTriggerTime * 20) {
                    EffectRemovalHandler.removeNegativeEffects(player);
                    EffectRemovalHandler.removeBadOmen(player);
                    player.addEffect(new MobEffectInstance(MobEffects.DAMAGE_BOOST, 400, 0, false, false, true));
                }
            } else {
                playerData.putInt(roseBathStayedTime, 0);
                playerData.putBoolean(hasEnteredRoseBath, false);
            }
        }
    }
}

