/*
 * Decompiled with CFR 0.152.
 */
package mod.crabmod.hotbath.fluid_blocks;

import java.util.function.Supplier;
import mod.crabmod.hotbath.util.CustomFluidHandler;
import mod.crabmod.hotbath.util.ParticleGenerator;
import mod.crabmod.hotbath.util.SoundHandler;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractHotbathBlock
extends LiquidBlock {
    private static final String HOTBATH_UNDERWATER_STATE = "HotbathUnderwaterState";
    private static final String HOTBATH_ENTER_WATER_STATE = "HotbathEnterWaterState";

    protected AbstractHotbathBlock(Supplier<? extends FlowingFluid> supplier, BlockBehaviour.Properties properties) {
        super(supplier, properties);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void animateTick(@NotNull BlockState stateIn, @NotNull Level worldIn, @NotNull BlockPos pos, @NotNull RandomSource rand) {
        this.generateSteamParticles(worldIn, pos, rand);
        double maxDistanceSqr = 9.0;
        for (Player player : worldIn.players()) {
            if (player.distanceToSqr((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5) > 9.0) continue;
            boolean isPlayerHeadUnderwater = CustomFluidHandler.isPlayerHeadInHotBath(player);
            if (!isPlayerHeadUnderwater) {
                SoundHandler.playAmbientWaterSound(worldIn, pos, rand);
            }
            this.handleClientPlayerUnderwaterState(player, rand);
            this.handleClientPlayerEnterWaterState(player, rand);
        }
    }

    private void handleClientPlayerEnterWaterState(Player player, RandomSource rand) {
        CompoundTag playerData = player.getPersistentData();
        boolean isPlayerInWater = CustomFluidHandler.isPlayerInHotBathBlock(player);
        if (isPlayerInWater) {
            if (!playerData.getBoolean(HOTBATH_ENTER_WATER_STATE)) {
                SoundHandler.playEnterWaterSound(player, rand);
                playerData.putBoolean(HOTBATH_ENTER_WATER_STATE, true);
            }
        } else if (playerData.getBoolean(HOTBATH_ENTER_WATER_STATE)) {
            playerData.putBoolean(HOTBATH_ENTER_WATER_STATE, false);
        }
    }

    private void handleClientPlayerUnderwaterState(Player player, RandomSource rand) {
        CompoundTag playerData = player.getPersistentData();
        boolean isPlayerHeadUnderwater = CustomFluidHandler.isPlayerHeadInHotBath(player);
        if (isPlayerHeadUnderwater) {
            if (!playerData.getBoolean(HOTBATH_UNDERWATER_STATE)) {
                SoundHandler.playUnderwaterEnterSound(player, rand);
                playerData.putBoolean(HOTBATH_UNDERWATER_STATE, true);
            } else {
                SoundHandler.playUnderwaterLoopSound(player, rand);
            }
        } else if (playerData.getBoolean(HOTBATH_UNDERWATER_STATE)) {
            SoundHandler.playExitWaterSound(player, rand);
            SoundHandler.stopUnderwaterLoopSound(player);
            playerData.putBoolean(HOTBATH_UNDERWATER_STATE, false);
        }
    }

    private void generateSteamParticles(Level worldIn, BlockPos pos, RandomSource rand) {
        BlockPos[] adjacentPositions = new BlockPos[]{pos.above(), pos.below(), pos.north(), pos.south(), pos.east(), pos.west()};
        int airBlockCount = 0;
        BlockPos[] airBlocks = new BlockPos[adjacentPositions.length];
        for (BlockPos adjacentPos : adjacentPositions) {
            if (!worldIn.getBlockState(adjacentPos).isAir()) continue;
            airBlocks[airBlockCount++] = adjacentPos;
        }
        if (airBlockCount > 0) {
            BlockPos selectedPos = airBlocks[rand.nextInt(airBlockCount)];
            ParticleGenerator.renderDefaultSteam((ClientLevel)worldIn, selectedPos, rand);
        }
    }
}

