/*
 * Decompiled with CFR 0.152.
 */
package mod.crabmod.hotbath.particles;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class SteamParticle
extends TextureSheetParticle {
    private SteamParticle(ClientLevel world, double x, double y, double z, double motionX, double motionY, double motionZ, boolean longLivingEmber) {
        super(world, x, y, z);
        this.quadSize = (this.random.nextFloat() * 0.5f + 0.5f) * 2.0f;
        this.scale(2.5f + this.random.nextFloat());
        this.setSize(0.25f, 0.25f);
        this.quadSize *= 0.2f;
        this.lifetime = longLivingEmber ? 90 + this.random.nextInt(10) + 20 : 80 + this.random.nextInt(10) + 10;
        this.gravity = 2.0E-4f;
        this.xd = motionX + (double)(this.random.nextFloat() / 250.0f * (float)(this.random.nextBoolean() ? 1 : -1));
        this.zd = motionZ + (double)(this.random.nextFloat() / 250.0f * (float)(this.random.nextBoolean() ? 1 : -1));
        this.yd = motionY + 0.025 + (double)(this.random.nextFloat() / 250.0f);
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ < this.lifetime && this.alpha > 0.02f) {
            this.xd += (double)(this.random.nextFloat() / 1000.0f * (float)(this.random.nextBoolean() ? 1 : -1));
            this.zd += (double)(this.random.nextFloat() / 1000.0f * (float)(this.random.nextBoolean() ? 1 : -1));
            this.yd -= (double)this.gravity;
            this.move(this.xd, this.yd, this.zd);
            this.alpha -= 0.01f + this.random.nextFloat() * 0.01f;
        } else {
            this.remove();
        }
    }

    @NotNull
    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    public static class CozySmokeFactory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;

        public CozySmokeFactory(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        public Particle createParticle(@NotNull SimpleParticleType typeIn, @NotNull ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            SteamParticle steamParticle = new SteamParticle(worldIn, x, y, z, xSpeed, ySpeed, zSpeed, false);
            steamParticle.setAlpha(0.9f);
            steamParticle.pickSprite(this.spriteSet);
            return steamParticle;
        }
    }
}

