/*
 * Decompiled with CFR 0.152.
 */
package mod.crabmod.hotbath.util;

import mod.crabmod.hotbath.registers.ItemRegister;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="hotbath")
public class CraftingEventHandler {
    @SubscribeEvent
    public static void onItemCrafted(PlayerEvent.ItemCraftedEvent event) {
        Container container = event.getInventory();
        if (container instanceof CraftingContainer) {
            ItemStack itemStack;
            CraftingContainer craftingInventory = (CraftingContainer)container;
            boolean foundHotWaterBucket = false;
            boolean foundMilkBucket = false;
            for (int i = 0; i < craftingInventory.getContainerSize(); ++i) {
                itemStack = craftingInventory.getItem(i);
                Item item = itemStack.getItem();
                if (item == ItemRegister.HOT_WATER_BUCKET.get()) {
                    foundHotWaterBucket = true;
                    itemStack.shrink(1);
                }
                if (item != Items.MILK_BUCKET) continue;
                foundMilkBucket = true;
            }
            if (foundHotWaterBucket && foundMilkBucket && (itemStack = event.getEntity()) instanceof Player) {
                ItemStack player = itemStack;
                ItemStack emptyBucket = new ItemStack((ItemLike)Items.BUCKET);
                if (!player.getInventory().add(emptyBucket)) {
                    player.drop(emptyBucket, false);
                }
            }
        }
    }
}

