/*
 * Decompiled with CFR 0.152.
 */
package mod.crabmod.hotbath.util;

import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class SoundHandler {
    public static void playEnterWaterSound(Player player, RandomSource rand) {
        player.level().playSound(player, player.blockPosition(), SoundEvents.PLAYER_SPLASH, SoundSource.PLAYERS, rand.nextFloat() * 0.5f, rand.nextFloat() * 0.5f + 0.75f);
    }

    public static void playUnderwaterEnterSound(Player player, RandomSource rand) {
        player.level().playSound(player, player.blockPosition(), SoundEvents.AMBIENT_UNDERWATER_ENTER, SoundSource.BLOCKS, rand.nextFloat() * 0.5f, rand.nextFloat() * 0.5f + 0.75f);
    }

    public static void playUnderwaterLoopSound(Player player, RandomSource rand) {
        player.level().playSound(player, player.blockPosition(), SoundEvents.AMBIENT_UNDERWATER_LOOP, SoundSource.PLAYERS, 1.0f, rand.nextFloat() * 0.5f + 0.75f);
    }

    public static void playExitWaterSound(Player player, RandomSource rand) {
        player.level().playSound(player, player.blockPosition(), SoundEvents.AMBIENT_UNDERWATER_EXIT, SoundSource.PLAYERS, rand.nextFloat() * 0.5f + 0.75f, rand.nextFloat() * 0.5f + 0.75f);
    }

    public static void stopUnderwaterLoopSound(Player player) {
        if (player instanceof LocalPlayer) {
            SoundManager soundManager = Minecraft.getInstance().getSoundManager();
            soundManager.stop(SoundEvents.AMBIENT_UNDERWATER_LOOP.location(), SoundSource.PLAYERS);
        }
    }

    public static void playAmbientWaterSound(Level worldIn, BlockPos pos, RandomSource rand) {
        if (rand.nextInt(64) == 0) {
            double maxDistance = 3.0;
            double maxDistanceSquared = maxDistance * maxDistance;
            for (Player player : worldIn.players()) {
                double distance;
                float volume;
                double distanceSquared = player.distanceToSqr((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
                if (distanceSquared > maxDistanceSquared || !((volume = (float)((maxDistance - (distance = Math.sqrt(distanceSquared))) / maxDistance)) > 0.0f)) continue;
                worldIn.playSound(player, pos, SoundEvents.WATER_AMBIENT, SoundSource.BLOCKS, volume, rand.nextFloat() * 0.5f + 0.75f);
            }
        }
    }
}

