/*
 * Decompiled with CFR 0.152.
 */
package com.crabmod.hotbath;

import com.crabmod.hotbath.client.particle.CustomDripParticle;
import com.crabmod.hotbath.client.particle.HotBathBubbleParticle;
import com.crabmod.hotbath.compat.ColdSweatCompat;
import com.crabmod.hotbath.compat.ColdSweatIntegration;
import com.crabmod.hotbath.compat.LSOCompat;
import com.crabmod.hotbath.compat.LegendarySurvivalOverhaulIntegration;
import com.crabmod.hotbath.compat.ToughAsNailsCompat;
import com.crabmod.hotbath.compat.ToughAsNailsIntegration;
import com.crabmod.hotbath.fluid_details.HotbathFluidType;
import com.crabmod.hotbath.item.ItemGroup;
import com.crabmod.hotbath.registers.BlocksRegister;
import com.crabmod.hotbath.registers.EntityRegister;
import com.crabmod.hotbath.registers.FluidsRegister;
import com.crabmod.hotbath.registers.ItemRegister;
import com.crabmod.hotbath.registers.ParticleRegister;
import com.mojang.logging.LogUtils;
import net.minecraft.client.particle.SpellParticle;
import net.minecraft.client.particle.SplashParticle;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.client.renderer.entity.ThrownItemRenderer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.client.event.RegisterParticleProvidersEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.brewing.RegisterBrewingRecipesEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import org.slf4j.Logger;

@Mod(value="hotbath")
public class HotBath {
    public static final String MOD_ID = "hotbath";
    public static final Logger LOGGER = LogUtils.getLogger();

    public HotBath(ModContainer modContainer, IEventBus modEventBus) {
        ItemGroup.register(modEventBus);
        FluidsRegister.register(modEventBus);
        BlocksRegister.register(modEventBus);
        ItemRegister.register(modEventBus);
        ParticleRegister.register(modEventBus);
        EntityRegister.register(modEventBus);
        HotbathFluidType.register(modEventBus);
        modEventBus.addListener(this::commonSetup);
        NeoForge.EVENT_BUS.register((Object)this);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            modEventBus.addListener(ClientModEvents::onClientSetup);
            modEventBus.addListener(ClientModEvents::registerParticles);
        }
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        LOGGER.info("HELLO FROM COMMON SETUP");
        if (ColdSweatIntegration.isColdSweatLoaded()) {
            LOGGER.info("Cold Sweat detected! Temperature integration enabled.");
            try {
                ColdSweatCompat.init();
                LOGGER.info("Cold Sweat event handler registered successfully.");
            }
            catch (Exception e) {
                LOGGER.error("Failed to register Cold Sweat event handler: {}", (Object)e.getMessage(), (Object)e);
            }
        }
        if (ToughAsNailsIntegration.isToughAsNailsLoaded()) {
            LOGGER.info("Tough As Nails detected! Temperature integration enabled.");
            try {
                ToughAsNailsCompat.init();
                LOGGER.info("Tough As Nails integration registered successfully.");
            }
            catch (Exception e) {
                LOGGER.error("Failed to initialize Tough As Nails integration: {}", (Object)e.getMessage(), (Object)e);
            }
        }
        if (LegendarySurvivalOverhaulIntegration.isLSOLoaded()) {
            LOGGER.info("Legendary Survival Overhaul detected! Integration enabled.");
            try {
                LSOCompat.init();
                LOGGER.info("LSO integration registered successfully.");
            }
            catch (Exception e) {
                LOGGER.error("Failed to register LSO integration: {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        LOGGER.info("HELLO from server starting");
    }

    @SubscribeEvent
    public void onBrewingRecipeRegister(RegisterBrewingRecipesEvent event) {
        event.getBuilder().addRecipe(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegister.HOT_WATER_BOTTLE.get()}), Ingredient.of((ItemLike[])new ItemLike[]{Items.GUNPOWDER}), ((Item)ItemRegister.SPLASH_HOT_WATER_BOTTLE.get()).getDefaultInstance());
        event.getBuilder().addRecipe(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegister.HONEY_BATH_BOTTLE.get()}), Ingredient.of((ItemLike[])new ItemLike[]{Items.GUNPOWDER}), ((Item)ItemRegister.SPLASH_HONEY_BATH_BOTTLE.get()).getDefaultInstance());
        event.getBuilder().addRecipe(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegister.MILK_BATH_BOTTLE.get()}), Ingredient.of((ItemLike[])new ItemLike[]{Items.GUNPOWDER}), ((Item)ItemRegister.SPLASH_MILK_BATH_BOTTLE.get()).getDefaultInstance());
        event.getBuilder().addRecipe(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegister.HERBAL_BATH_BOTTLE.get()}), Ingredient.of((ItemLike[])new ItemLike[]{Items.GUNPOWDER}), ((Item)ItemRegister.SPLASH_HERBAL_BATH_BOTTLE.get()).getDefaultInstance());
        event.getBuilder().addRecipe(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegister.PEONY_BATH_BOTTLE.get()}), Ingredient.of((ItemLike[])new ItemLike[]{Items.GUNPOWDER}), ((Item)ItemRegister.SPLASH_PEONY_BATH_BOTTLE.get()).getDefaultInstance());
        event.getBuilder().addRecipe(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegister.ROSE_BATH_BOTTLE.get()}), Ingredient.of((ItemLike[])new ItemLike[]{Items.GUNPOWDER}), ((Item)ItemRegister.SPLASH_ROSE_BATH_BOTTLE.get()).getDefaultInstance());
    }

    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            EntityRenderers.register((EntityType)((EntityType)EntityRegister.THROWN_BATH_WATER.get()), ThrownItemRenderer::new);
            ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)FluidsRegister.HOT_WATER_FLUID.get()), (RenderType)RenderType.translucent());
            ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)FluidsRegister.HOT_WATER_FLOWING.get()), (RenderType)RenderType.translucent());
            ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)FluidsRegister.HONEY_BATH_FLUID.get()), (RenderType)RenderType.translucent());
            ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)FluidsRegister.HONEY_BATH_FLOWING.get()), (RenderType)RenderType.translucent());
            ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)FluidsRegister.MILK_BATH_FLUID.get()), (RenderType)RenderType.translucent());
            ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)FluidsRegister.MILK_BATH_FLOWING.get()), (RenderType)RenderType.translucent());
            ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)FluidsRegister.HERBAL_BATH_FLUID.get()), (RenderType)RenderType.translucent());
            ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)FluidsRegister.HERBAL_BATH_FLOWING.get()), (RenderType)RenderType.translucent());
            ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)FluidsRegister.PEONY_BATH_FLUID.get()), (RenderType)RenderType.translucent());
            ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)FluidsRegister.PEONY_BATH_FLOWING.get()), (RenderType)RenderType.translucent());
            ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)FluidsRegister.ROSE_BATH_FLUID.get()), (RenderType)RenderType.translucent());
            ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)FluidsRegister.ROSE_BATH_FLOWING.get()), (RenderType)RenderType.translucent());
        }

        @SubscribeEvent
        public static void registerParticles(RegisterParticleProvidersEvent event) {
            event.registerSpriteSet((ParticleType)ParticleRegister.HOT_WATER_SPLASH.get(), SplashParticle.Provider::new);
            event.registerSpriteSet((ParticleType)ParticleRegister.HONEY_WATER_SPLASH.get(), SplashParticle.Provider::new);
            event.registerSpriteSet((ParticleType)ParticleRegister.MILK_WATER_SPLASH.get(), SplashParticle.Provider::new);
            event.registerSpriteSet((ParticleType)ParticleRegister.HERBAL_WATER_SPLASH.get(), SplashParticle.Provider::new);
            event.registerSpriteSet((ParticleType)ParticleRegister.PEONY_WATER_SPLASH.get(), SplashParticle.Provider::new);
            event.registerSpriteSet((ParticleType)ParticleRegister.ROSE_WATER_SPLASH.get(), SplashParticle.Provider::new);
            event.registerSpriteSet((ParticleType)ParticleRegister.HOT_WATER_EFFECT.get(), SpellParticle.Provider::new);
            event.registerSpriteSet((ParticleType)ParticleRegister.HONEY_BATH_EFFECT.get(), SpellParticle.Provider::new);
            event.registerSpriteSet((ParticleType)ParticleRegister.MILK_BATH_EFFECT.get(), SpellParticle.Provider::new);
            event.registerSpriteSet((ParticleType)ParticleRegister.HERBAL_BATH_EFFECT.get(), SpellParticle.Provider::new);
            event.registerSpriteSet((ParticleType)ParticleRegister.PEONY_BATH_EFFECT.get(), SpellParticle.Provider::new);
            event.registerSpriteSet((ParticleType)ParticleRegister.ROSE_BATH_EFFECT.get(), SpellParticle.Provider::new);
            event.registerSpriteSet((ParticleType)ParticleRegister.HOT_WATER_BUBBLE.get(), HotBathBubbleParticle.Provider::new);
            event.registerSpriteSet((ParticleType)ParticleRegister.HONEY_BATH_BUBBLE.get(), HotBathBubbleParticle.Provider::new);
            event.registerSpriteSet((ParticleType)ParticleRegister.MILK_BATH_BUBBLE.get(), HotBathBubbleParticle.Provider::new);
            event.registerSpriteSet((ParticleType)ParticleRegister.HERBAL_BATH_BUBBLE.get(), HotBathBubbleParticle.Provider::new);
            event.registerSpriteSet((ParticleType)ParticleRegister.PEONY_BATH_BUBBLE.get(), HotBathBubbleParticle.Provider::new);
            event.registerSpriteSet((ParticleType)ParticleRegister.ROSE_BATH_BUBBLE.get(), HotBathBubbleParticle.Provider::new);
            event.registerSpriteSet((ParticleType)ParticleRegister.DRIPPING_HOT_WATER.get(), sprite -> new CustomDripParticle.Factory(sprite, (Fluid)Fluids.WATER, (ParticleOptions)ParticleRegister.FALLING_HOT_WATER.get(), (ParticleOptions)ParticleRegister.LANDING_HOT_WATER.get()));
            event.registerSpriteSet((ParticleType)ParticleRegister.DRIPPING_HONEY_BATH.get(), sprite -> new CustomDripParticle.Factory(sprite, (Fluid)Fluids.WATER, (ParticleOptions)ParticleRegister.FALLING_HONEY_BATH.get(), (ParticleOptions)ParticleRegister.LANDING_HONEY_BATH.get()));
            event.registerSpriteSet((ParticleType)ParticleRegister.DRIPPING_MILK_BATH.get(), sprite -> new CustomDripParticle.Factory(sprite, (Fluid)Fluids.WATER, (ParticleOptions)ParticleRegister.FALLING_MILK_BATH.get(), (ParticleOptions)ParticleRegister.LANDING_MILK_BATH.get()));
            event.registerSpriteSet((ParticleType)ParticleRegister.DRIPPING_HERBAL_BATH.get(), sprite -> new CustomDripParticle.Factory(sprite, (Fluid)Fluids.WATER, (ParticleOptions)ParticleRegister.FALLING_HERBAL_BATH.get(), (ParticleOptions)ParticleRegister.LANDING_HERBAL_BATH.get()));
            event.registerSpriteSet((ParticleType)ParticleRegister.DRIPPING_PEONY_BATH.get(), sprite -> new CustomDripParticle.Factory(sprite, (Fluid)Fluids.WATER, (ParticleOptions)ParticleRegister.FALLING_PEONY_BATH.get(), (ParticleOptions)ParticleRegister.LANDING_PEONY_BATH.get()));
            event.registerSpriteSet((ParticleType)ParticleRegister.DRIPPING_ROSE_BATH.get(), sprite -> new CustomDripParticle.Factory(sprite, (Fluid)Fluids.WATER, (ParticleOptions)ParticleRegister.FALLING_ROSE_BATH.get(), (ParticleOptions)ParticleRegister.LANDING_ROSE_BATH.get()));
            event.registerSpriteSet((ParticleType)ParticleRegister.FALLING_HOT_WATER.get(), sprite -> new CustomDripParticle.Factory(sprite, (Fluid)Fluids.WATER, null, (ParticleOptions)ParticleRegister.LANDING_HOT_WATER.get()));
            event.registerSpriteSet((ParticleType)ParticleRegister.FALLING_HONEY_BATH.get(), sprite -> new CustomDripParticle.Factory(sprite, (Fluid)Fluids.WATER, null, (ParticleOptions)ParticleRegister.LANDING_HONEY_BATH.get()));
            event.registerSpriteSet((ParticleType)ParticleRegister.FALLING_MILK_BATH.get(), sprite -> new CustomDripParticle.Factory(sprite, (Fluid)Fluids.WATER, null, (ParticleOptions)ParticleRegister.LANDING_MILK_BATH.get()));
            event.registerSpriteSet((ParticleType)ParticleRegister.FALLING_HERBAL_BATH.get(), sprite -> new CustomDripParticle.Factory(sprite, (Fluid)Fluids.WATER, null, (ParticleOptions)ParticleRegister.LANDING_HERBAL_BATH.get()));
            event.registerSpriteSet((ParticleType)ParticleRegister.FALLING_PEONY_BATH.get(), sprite -> new CustomDripParticle.Factory(sprite, (Fluid)Fluids.WATER, null, (ParticleOptions)ParticleRegister.LANDING_PEONY_BATH.get()));
            event.registerSpriteSet((ParticleType)ParticleRegister.FALLING_ROSE_BATH.get(), sprite -> new CustomDripParticle.Factory(sprite, (Fluid)Fluids.WATER, null, (ParticleOptions)ParticleRegister.LANDING_ROSE_BATH.get()));
            event.registerSpriteSet((ParticleType)ParticleRegister.LANDING_HOT_WATER.get(), sprite -> new CustomDripParticle.Factory(sprite, (Fluid)Fluids.WATER, null, null));
            event.registerSpriteSet((ParticleType)ParticleRegister.LANDING_HONEY_BATH.get(), sprite -> new CustomDripParticle.Factory(sprite, (Fluid)Fluids.WATER, null, null));
            event.registerSpriteSet((ParticleType)ParticleRegister.LANDING_MILK_BATH.get(), sprite -> new CustomDripParticle.Factory(sprite, (Fluid)Fluids.WATER, null, null));
            event.registerSpriteSet((ParticleType)ParticleRegister.LANDING_HERBAL_BATH.get(), sprite -> new CustomDripParticle.Factory(sprite, (Fluid)Fluids.WATER, null, null));
            event.registerSpriteSet((ParticleType)ParticleRegister.LANDING_PEONY_BATH.get(), sprite -> new CustomDripParticle.Factory(sprite, (Fluid)Fluids.WATER, null, null));
            event.registerSpriteSet((ParticleType)ParticleRegister.LANDING_ROSE_BATH.get(), sprite -> new CustomDripParticle.Factory(sprite, (Fluid)Fluids.WATER, null, null));
        }
    }
}

