/*
 * Decompiled with CFR 0.152.
 */
package com.crabmod.hotbath.client.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.DripParticle;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public class CustomDripParticle
extends DripParticle {
    private final ParticleOptions fallParticle;
    private final ParticleOptions landParticle;
    private final Fluid fluid;

    protected CustomDripParticle(ClientLevel level, double x, double y, double z, Fluid fluid, ParticleOptions fallParticle, ParticleOptions landParticle) {
        super(level, x, y, z, fluid);
        this.fluid = fluid;
        this.fallParticle = fallParticle;
        this.landParticle = landParticle;
        this.rCol = 1.0f;
        this.gCol = 1.0f;
        this.bCol = 1.0f;
    }

    public void setColor(float r, float g, float b) {
        super.setColor(1.0f, 1.0f, 1.0f);
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ >= this.lifetime) {
            this.remove();
        } else {
            if (this.onGround) {
                this.remove();
                if (this.landParticle != null) {
                    this.level.addParticle(this.landParticle, this.x, this.y, this.z, 0.0, 0.0, 0.0);
                }
                if (this.fluid == Fluids.LAVA) {
                    this.level.playLocalSound(this.x, this.y, this.z, SoundEvents.POINTED_DRIPSTONE_DRIP_LAVA_INTO_CAULDRON, SoundSource.BLOCKS, 0.3f, 1.0f, false);
                } else {
                    this.level.playLocalSound(this.x, this.y, this.z, SoundEvents.POINTED_DRIPSTONE_DRIP_WATER_INTO_CAULDRON, SoundSource.BLOCKS, 0.3f, 1.0f, false);
                }
            }
            if (this.lifetime - this.age <= 20 && this.fallParticle != null && !this.removed) {
                this.remove();
                this.level.addParticle(this.fallParticle, this.x, this.y, this.z, this.xd, this.yd, this.zd);
            }
            if (this.fallParticle != null) {
                this.xd *= 0.0;
                this.yd *= 0.0;
                this.zd *= 0.0;
            } else {
                this.yd -= (double)this.gravity;
                this.move(this.xd, this.yd, this.zd);
                this.xd *= (double)0.98f;
                this.yd *= (double)0.98f;
                this.zd *= (double)0.98f;
            }
        }
    }

    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprite;
        private final Fluid fluid;
        private final ParticleOptions fallOption;
        private final ParticleOptions landOption;

        public Factory(SpriteSet sprite, Fluid fluid, ParticleOptions fallOption, ParticleOptions landOption) {
            this.sprite = sprite;
            this.fluid = fluid;
            this.fallOption = fallOption;
            this.landOption = landOption;
        }

        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            CustomDripParticle particle = new CustomDripParticle(level, x, y, z, this.fluid, this.fallOption, this.landOption);
            particle.pickSprite(this.sprite);
            if (this.fallOption != null) {
                particle.gravity = 0.0f;
                particle.setLifetime(40 + level.random.nextInt(40));
            } else if (this.landOption != null) {
                particle.gravity = 0.06f;
                particle.setLifetime((int)(64.0 / (Math.random() * 0.8 + 0.2)));
            } else {
                particle.gravity = 0.0f;
                particle.setLifetime((int)(16.0 / (Math.random() * 0.8 + 0.2)));
            }
            return particle;
        }
    }
}

