/*
 * Decompiled with CFR 0.152.
 */
package com.crabmod.hotbath.compat;

import com.momosoftworks.coldsweat.api.temperature.modifier.TempModifier;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.util.world.WorldHelper;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;

public class BathWaterBottleColdSweatModifier
extends TempModifier {
    private static final Map<UUID, Long> WARM_PLAYERS = new ConcurrentHashMap<UUID, Long>();
    private static final long WARM_DURATION_MS = 20000L;
    private static final double TARGET_TEMP_C = 36.0;

    public static void applyWarmEffect(Player player) {
        WARM_PLAYERS.put(player.getUUID(), System.currentTimeMillis() + 20000L);
    }

    public static void applySplashWarmEffect(Player player) {
        WARM_PLAYERS.put(player.getUUID(), System.currentTimeMillis() + 30000L);
    }

    protected Function<Double, Double> calculate(LivingEntity entity, Temperature.Trait trait) {
        if (trait != Temperature.Trait.WORLD) {
            return temp -> temp;
        }
        if (!(entity instanceof Player)) {
            return temp -> temp;
        }
        Player player = (Player)entity;
        UUID playerUUID = player.getUUID();
        Long expireTime = WARM_PLAYERS.get(playerUUID);
        if (expireTime != null) {
            double worldTempMC;
            long currentTime = System.currentTimeMillis();
            if (currentTime > expireTime) {
                WARM_PLAYERS.remove(playerUUID);
                return temp -> temp;
            }
            Level level = entity.level();
            BlockPos pos = entity.blockPosition();
            double targetTempMC = Temperature.convert((double)36.0, (Temperature.Units)Temperature.Units.C, (Temperature.Units)Temperature.Units.MC, (boolean)true);
            if (targetTempMC > (worldTempMC = WorldHelper.getBiomeTemperature((LevelAccessor)level, (Holder)level.getBiome(pos)))) {
                return temp -> Math.max(temp, targetTempMC);
            }
        }
        return temp -> temp;
    }
}

