/*
 * Decompiled with CFR 0.152.
 */
package com.crabmod.hotbath.compat;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.world.entity.player.Player;
import toughasnails.api.temperature.IPlayerTemperatureModifier;
import toughasnails.api.temperature.TemperatureLevel;

public class BathWaterBottleTANModifier
implements IPlayerTemperatureModifier {
    private static final Map<UUID, Long> WARM_PLAYERS = new ConcurrentHashMap<UUID, Long>();
    private static final long WARM_DURATION_MS = 10000L;

    public static void applyWarmEffect(Player player) {
        WARM_PLAYERS.put(player.getUUID(), System.currentTimeMillis() + 10000L);
    }

    public static void applySplashWarmEffect(Player player) {
        WARM_PLAYERS.put(player.getUUID(), System.currentTimeMillis() + 30000L);
    }

    public TemperatureLevel modify(Player player, TemperatureLevel current) {
        UUID playerUUID = player.getUUID();
        Long expireTime = WARM_PLAYERS.get(playerUUID);
        if (expireTime != null) {
            long currentTime = System.currentTimeMillis();
            if (currentTime > expireTime) {
                WARM_PLAYERS.remove(playerUUID);
                return current;
            }
            return TemperatureLevel.WARM;
        }
        return current;
    }
}

