/*
 * Decompiled with CFR 0.152.
 */
package com.crabmod.hotbath.compat;

import com.crabmod.hotbath.compat.BathWaterBottleColdSweatModifier;
import com.crabmod.hotbath.compat.HotBathImmersionModifier;
import com.mojang.logging.LogUtils;
import com.momosoftworks.coldsweat.api.event.core.init.DefaultTempModifiersEvent;
import com.momosoftworks.coldsweat.api.event.core.registry.TempModifierRegisterEvent;
import com.momosoftworks.coldsweat.api.temperature.modifier.TempModifier;
import com.momosoftworks.coldsweat.api.util.Placement;
import com.momosoftworks.coldsweat.api.util.Temperature;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.SubscribeEvent;
import org.slf4j.Logger;

public class ColdSweatEventHandler {
    private static final Logger LOGGER = LogUtils.getLogger();

    @SubscribeEvent
    public static void onTempModifierRegister(TempModifierRegisterEvent event) {
        try {
            LOGGER.info("Registering Hot Bath temperature modifiers with Cold Sweat...");
            event.register(ResourceLocation.parse((String)"hotbath:immersion"), HotBathImmersionModifier::new);
            event.register(ResourceLocation.parse((String)"hotbath:bottle"), BathWaterBottleColdSweatModifier::new);
            LOGGER.info("Successfully registered Hot Bath temperature modifiers!");
        }
        catch (Exception e) {
            LOGGER.error("Failed to register Hot Bath modifiers with Cold Sweat: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    @SubscribeEvent
    public static void onDefaultModifiers(DefaultTempModifiersEvent event) {
        event.addModifier(Temperature.Trait.WORLD, (TempModifier)new HotBathImmersionModifier(), Placement.Duplicates.BY_CLASS, Placement.AFTER_LAST);
        event.addModifier(Temperature.Trait.WORLD, (TempModifier)new BathWaterBottleColdSweatModifier(), Placement.Duplicates.BY_CLASS, Placement.AFTER_LAST);
    }
}

