/*
 * Decompiled with CFR 0.152.
 */
package com.crabmod.hotbath.compat;

import com.crabmod.hotbath.compat.LSOApiHelper;
import com.crabmod.hotbath.util.CustomFluidHandler;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.world.entity.player.Player;

public class HotBathImmersionLSOModifier {
    private static final Map<UUID, Integer> BATH_TIMERS = new ConcurrentHashMap<UUID, Integer>();
    private static final int UPDATE_INTERVAL = 200;
    private static final int RESISTANCE_GAIN_PER_UPDATE = 1200;
    private static final int THERMAL_COMFORT_START_DELAY = 200;

    public static boolean isPlayerInBath(UUID playerUUID) {
        return BATH_TIMERS.containsKey(playerUUID);
    }

    public static void tick(Player player) {
        UUID playerUUID = player.getUUID();
        boolean isInBath = CustomFluidHandler.isPlayerInHotBathBlock(player);
        if (isInBath) {
            int timer = BATH_TIMERS.getOrDefault(playerUUID, 0);
            BATH_TIMERS.put(playerUUID, ++timer);
            if (timer % 200 == 0) {
                LSOApiHelper.updateImmersionResistanceEffect(player, 1200);
            }
            if (timer >= 200) {
                LSOApiHelper.applyThermalComfortEffect(player);
            }
        } else {
            BATH_TIMERS.remove(playerUUID);
        }
    }

    public static void cleanup(Player player) {
        BATH_TIMERS.remove(player.getUUID());
    }
}

