/*
 * Decompiled with CFR 0.152.
 */
package com.crabmod.hotbath.compat;

import com.crabmod.hotbath.util.CustomFluidHandler;
import com.momosoftworks.coldsweat.api.temperature.modifier.TempModifier;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.util.world.WorldHelper;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;

public class HotBathImmersionModifier
extends TempModifier {
    private static final double TARGET_TEMP_C = 37.0;

    protected Function<Double, Double> calculate(LivingEntity entity, Temperature.Trait trait) {
        if (trait != Temperature.Trait.WORLD) {
            return temp -> temp;
        }
        if (!(entity instanceof Player)) {
            return temp -> temp;
        }
        Player player = (Player)entity;
        Level level = entity.level();
        BlockPos pos = entity.blockPosition();
        if (CustomFluidHandler.isPlayerInHotBathBlock(player)) {
            double targetTempMC = Temperature.convert((double)37.0, (Temperature.Units)Temperature.Units.C, (Temperature.Units)Temperature.Units.MC, (boolean)true);
            double worldTempMC = WorldHelper.getBiomeTemperature((LevelAccessor)level, (Holder)level.getBiome(pos));
            double finalTemp = Math.max(targetTempMC, worldTempMC);
            return temp -> finalTemp;
        }
        return temp -> temp;
    }
}

