/*
 * Decompiled with CFR 0.152.
 */
package com.crabmod.hotbath.compat;

import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import sfiomn.legendarysurvivaloverhaul.api.temperature.TemperatureUtil;
import sfiomn.legendarysurvivaloverhaul.api.thirst.ThirstUtil;
import sfiomn.legendarysurvivaloverhaul.registry.MobEffectRegistry;

public class LSOApiHelper {
    private static final int HOT_DRINK_BOTTLE_DURATION = 300;
    private static final int HOT_DRINK_BOTTLE_AMPLIFIER = 0;
    private static final int HOT_DRINK_BOTTLE_AMPLIFIER_BOOSTED = 2;
    private static final int COLD_RESISTANCE_AMPLIFIER = 2;
    private static final int MAX_RESISTANCE_DURATION = 6000;
    private static final int THERMAL_COMFORT_DURATION = 200;
    private static final float COLD_TEMPERATURE_THRESHOLD = 16.0f;
    private static final int HYDRATION = 5;
    private static final float SATURATION = 0.5f;

    public static void applyBottleTemperatureEffect(Player player, boolean isBathing) {
        MobEffect hotDrink = (MobEffect)MobEffectRegistry.HOT_DRINk.get();
        Holder hotDrinkHolder = BuiltInRegistries.MOB_EFFECT.wrapAsHolder((Object)hotDrink);
        int amplifier = isBathing ? 2 : 0;
        MobEffectInstance effect = new MobEffectInstance(hotDrinkHolder, 300, amplifier, false, true, true);
        player.addEffect(effect);
    }

    public static void updateImmersionResistanceEffect(Player player, int durationToAdd) {
        MobEffectInstance currentEffect;
        MobEffect coldResistance = (MobEffect)MobEffectRegistry.COLD_RESISTANCE.get();
        Holder coldResistanceHolder = BuiltInRegistries.MOB_EFFECT.wrapAsHolder((Object)coldResistance);
        int currentDuration = 0;
        if (player.hasEffect(coldResistanceHolder) && (currentEffect = player.getEffect(coldResistanceHolder)) != null) {
            currentDuration = currentEffect.getDuration();
        }
        int newDuration = Math.min(currentDuration + durationToAdd, 6000);
        MobEffectInstance effect = new MobEffectInstance(coldResistanceHolder, newDuration, 2, false, true, true);
        player.addEffect(effect);
    }

    public static void applyThermalComfortEffect(Player player) {
        float currentTemp = TemperatureUtil.getPlayerTargetTemperature((Player)player);
        if (currentTemp >= 16.0f) {
            return;
        }
        MobEffect tempImmunity = (MobEffect)MobEffectRegistry.TEMPERATURE_IMMUNITY.get();
        Holder tempImmunityHolder = BuiltInRegistries.MOB_EFFECT.wrapAsHolder((Object)tempImmunity);
        MobEffectInstance effect = new MobEffectInstance(tempImmunityHolder, 200, 0, false, true, true);
        player.addEffect(effect);
    }

    public static void addThirst(Player player) {
        ThirstUtil.takeDrink((Player)player, (int)5, (float)0.5f);
    }

    public static int getHydration() {
        return 5;
    }

    public static float getSaturation() {
        return 0.5f;
    }

    public static void applySplashTemperatureEffect(Player player) {
        MobEffect coldResistance = (MobEffect)MobEffectRegistry.COLD_RESISTANCE.get();
        Holder coldResistanceHolder = BuiltInRegistries.MOB_EFFECT.wrapAsHolder((Object)coldResistance);
        MobEffectInstance effect = new MobEffectInstance(coldResistanceHolder, 600, 1, false, false, true);
        player.addEffect(effect);
    }
}

