/*
 * Decompiled with CFR 0.152.
 */
package com.crabmod.hotbath.events;

import com.crabmod.hotbath.fluid_blocks.AbstractHotbathBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.animal.Squid;
import net.minecraft.world.entity.animal.TropicalFish;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.tick.EntityTickEvent;

@EventBusSubscriber(modid="hotbath")
public class AquaticMobHurtsHandler {
    @SubscribeEvent
    public static void onEntityUpdate(EntityTickEvent.Pre event) {
        BlockPos pos;
        LivingEntity entity;
        Level world;
        boolean inHotBath;
        Entity e = event.getEntity();
        if (e instanceof LivingEntity && (inHotBath = (world = (entity = (LivingEntity)e).level()).getBlockState(pos = entity.blockPosition()).getBlock() instanceof AbstractHotbathBlock) && AquaticMobHurtsHandler.isNonTropicalAquatic(entity)) {
            entity.hurt(world.damageSources().magic(), 1.0f);
        }
    }

    private static boolean isNonTropicalAquatic(LivingEntity livingEntity) {
        return livingEntity instanceof AbstractFish && !(livingEntity instanceof TropicalFish) || livingEntity instanceof Squid;
    }
}

