/*
 * Decompiled with CFR 0.152.
 */
package com.crabmod.hotbath.events;

import com.crabmod.hotbath.fluid_blocks.HerbalBathBlock;
import com.crabmod.hotbath.fluid_blocks.HoneyBathBlock;
import com.crabmod.hotbath.fluid_blocks.HotWaterBlock;
import com.crabmod.hotbath.fluid_blocks.MilkBathBlock;
import com.crabmod.hotbath.fluid_blocks.PeonyBathBlock;
import com.crabmod.hotbath.fluid_blocks.RoseBathBlock;
import com.crabmod.hotbath.registers.ItemRegister;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

@EventBusSubscriber(modid="hotbath")
public class BathWaterBottleEvents {
    @SubscribeEvent
    public static void onPlayerUseItem(PlayerInteractEvent.RightClickItem event) {
        Player player = event.getEntity();
        Level level = player.level();
        InteractionHand hand = event.getHand();
        ItemStack stack = player.getItemInHand(hand);
        Item item = stack.getItem();
        if (item != Items.GLASS_BOTTLE) {
            return;
        }
        BlockHitResult rayTraceResult = Item.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
        if (rayTraceResult.getType() != HitResult.Type.BLOCK) {
            return;
        }
        BlockPos pos = rayTraceResult.getBlockPos();
        if (!level.mayInteract(player, pos)) {
            return;
        }
        BlockState blockState = level.getBlockState(pos);
        Block block = blockState.getBlock();
        ItemStack filledStack = null;
        if (block instanceof HotWaterBlock) {
            filledStack = new ItemStack((ItemLike)ItemRegister.HOT_WATER_BOTTLE.get());
        } else if (block instanceof HoneyBathBlock) {
            filledStack = new ItemStack((ItemLike)ItemRegister.HONEY_BATH_BOTTLE.get());
        } else if (block instanceof MilkBathBlock) {
            filledStack = new ItemStack((ItemLike)ItemRegister.MILK_BATH_BOTTLE.get());
        } else if (block instanceof HerbalBathBlock) {
            filledStack = new ItemStack((ItemLike)ItemRegister.HERBAL_BATH_BOTTLE.get());
        } else if (block instanceof PeonyBathBlock) {
            filledStack = new ItemStack((ItemLike)ItemRegister.PEONY_BATH_BOTTLE.get());
        } else if (block instanceof RoseBathBlock) {
            filledStack = new ItemStack((ItemLike)ItemRegister.ROSE_BATH_BOTTLE.get());
        }
        if (filledStack != null) {
            level.playSound(player, player.getX(), player.getY(), player.getZ(), SoundEvents.BOTTLE_FILL, SoundSource.NEUTRAL, 1.0f, 1.0f);
            player.awardStat(Stats.ITEM_USED.get((Object)item));
            if (!player.getAbilities().instabuild) {
                stack.shrink(1);
            }
            if (stack.isEmpty()) {
                player.setItemInHand(hand, filledStack);
            } else if (!player.getInventory().add(filledStack)) {
                player.drop(filledStack, false);
            }
            event.setCanceled(true);
        }
    }
}

