/*
 * Decompiled with CFR 0.152.
 */
package com.crabmod.hotbath.events.enter_fluid_events;

import com.crabmod.hotbath.util.CustomFluidHandler;
import com.crabmod.hotbath.util.EffectRemovalHandler;
import com.crabmod.hotbath.util.HealthRegenHandler;
import com.crabmod.hotbath.util.ResistanceBoostHandler;
import java.util.Objects;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.tick.EntityTickEvent;

@EventBusSubscriber(modid="hotbath")
public class HerbalBathEvents {
    private static final int TICK_NUMBER = 20;
    static final String HERBAL_BATH_ENTERED_NUMBER = "HerbalBathEnteredNumber";
    static final String HERBAL_BATH_STAYED_TIME = "HerbalBathStayedTime";
    static final String HAS_ENTERED_HERBAL_BATH = "HasEnteredHerbalBath";
    static final String HERBAL_BATH_ADVANCEMENT_ID = "hotbath:chronic_invalid";
    private static final int HERBAL_BATH_ENTERED_COUNT_TRIGGER_NUMBER = 100;
    private static final int HERBAL_BATH_STAYED_EFFECT_TRIGGER_TIME_SECONDS = 5;

    @SubscribeEvent
    public static void enterHerbalBathBlockEvent(EntityTickEvent.Pre event) {
        HerbalBathEvents.enterFluidEvents(event, 100, 5, HERBAL_BATH_ENTERED_NUMBER, HERBAL_BATH_STAYED_TIME, HAS_ENTERED_HERBAL_BATH, HERBAL_BATH_ADVANCEMENT_ID);
    }

    public static void enterFluidEvents(EntityTickEvent.Pre event, int enteredCountTriggerNumber, int stayedEffectTriggerTime, String enteredNumberInHerbalBath, String herbalBathStayedTime, String hasEnteredHerbalBath, String herbalBathAdvancementId) {
        if (!(event.getEntity() instanceof ServerPlayer)) {
            boolean isInHerbalBath;
            if ((event.getEntity() instanceof Zombie || event.getEntity() instanceof Skeleton) && (isInHerbalBath = CustomFluidHandler.isEntityInHerbalBathBlock(event.getEntity()))) {
                int damageIntervalTicks = 20;
                float damagePerSecond = 0.5f;
                if (event.getEntity().tickCount % damageIntervalTicks == 0) {
                    Level level = event.getEntity().level();
                    event.getEntity().hurt(level.damageSources().magic(), damagePerSecond);
                }
            }
            return;
        }
        boolean isInHerbalBath = CustomFluidHandler.isPlayerInHerbalBathBlock((Player)((ServerPlayer)event.getEntity()));
        Entity damagePerSecond = event.getEntity();
        if (damagePerSecond instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)damagePerSecond;
            CompoundTag playerData = player.getPersistentData();
            if (isInHerbalBath && player.isAlive()) {
                if (!playerData.getBoolean(hasEnteredHerbalBath)) {
                    AdvancementHolder advancement;
                    int enteredCount = playerData.getInt(enteredNumberInHerbalBath) + 1;
                    playerData.putInt(enteredNumberInHerbalBath, enteredCount);
                    playerData.putBoolean(hasEnteredHerbalBath, true);
                    if (enteredCount >= enteredCountTriggerNumber && (advancement = Objects.requireNonNull(player.getServer()).getAdvancements().get(Objects.requireNonNull(ResourceLocation.tryParse((String)herbalBathAdvancementId)))) != null) {
                        player.getAdvancements().award(advancement, "code_triggered");
                        playerData.putInt(enteredNumberInHerbalBath, 0);
                    }
                }
                int hotBathTime = playerData.getInt(herbalBathStayedTime) + 1;
                playerData.putInt(herbalBathStayedTime, hotBathTime);
                HealthRegenHandler.regenHealth(0.25f, 2.0, player);
                if (playerData.getInt(herbalBathStayedTime) >= stayedEffectTriggerTime * 20) {
                    ResistanceBoostHandler.applyResistanceBoost(10, player);
                }
                if (playerData.getInt(herbalBathStayedTime) >= 300) {
                    EffectRemovalHandler.removeNegativeEffects(player);
                }
            } else {
                playerData.putInt(herbalBathStayedTime, 0);
                playerData.putBoolean(hasEnteredHerbalBath, false);
            }
        }
    }
}

