/*
 * Decompiled with CFR 0.152.
 */
package com.crabmod.hotbath.events.enter_fluid_events;

import com.crabmod.hotbath.util.CustomFluidHandler;
import com.crabmod.hotbath.util.EffectRemovalHandler;
import com.crabmod.hotbath.util.HealthRegenHandler;
import com.crabmod.hotbath.util.HungerRegenHandler;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.tick.EntityTickEvent;

@EventBusSubscriber(modid="hotbath")
public class HoneyBathEvents {
    private static final int TICK_NUMBER = 20;
    static final String HONEY_BATH_STAYED_TIME = "HoneyBathStayedTime";
    private static final int HONEY_BATH_STAYED_EFFECT_TRIGGER_TIME_SECONDS = 15;

    @SubscribeEvent
    public static void enterHoneyBathEvents(EntityTickEvent.Pre event) {
        HoneyBathEvents.enterFluidEvents(event, 15, HONEY_BATH_STAYED_TIME);
    }

    public static void enterFluidEvents(EntityTickEvent.Pre event, int stayedEffectTriggerTime, String honeyBathStayedTime) {
        Entity entity = event.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            CompoundTag playerData = player.getPersistentData();
            boolean isInHoneyBath = CustomFluidHandler.isPlayerInHoneyBathBlock((Player)player);
            if (isInHoneyBath && player.isAlive()) {
                int honeyBathTime = playerData.getInt(honeyBathStayedTime) + 1;
                playerData.putInt(honeyBathStayedTime, honeyBathTime);
                HealthRegenHandler.regenHealth(0.25f, 1.0, player);
                HungerRegenHandler.regenHunger(1, 4.0f, player);
                player.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 200, 0, false, false, true));
                if (playerData.getInt(honeyBathStayedTime) >= stayedEffectTriggerTime * 20) {
                    EffectRemovalHandler.removeNegativeEffectsExceptSlowAndUnluck(player);
                    player.addEffect(new MobEffectInstance(MobEffects.ABSORPTION, 400, 1, false, false, true));
                }
            } else {
                playerData.putInt(honeyBathStayedTime, 0);
            }
        }
    }
}

