/*
 * Decompiled with CFR 0.152.
 */
package com.crabmod.hotbath.fluid_blocks;

import com.crabmod.hotbath.fluid_details.BaseFluidType;
import com.crabmod.hotbath.util.CustomFluidHandler;
import com.crabmod.hotbath.util.ParticleGenerator;
import com.crabmod.hotbath.util.SoundHandler;
import java.util.function.Supplier;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FlowingFluid;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.fluids.FluidType;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractHotbathBlock
extends LiquidBlock {
    private static final String HOTBATH_UNDERWATER_STATE = "HotbathUnderwaterState";
    private static final String HOTBATH_ENTER_WATER_STATE = "HotbathEnterWaterState";

    protected AbstractHotbathBlock(Supplier<? extends FlowingFluid> supplier, BlockBehaviour.Properties properties) {
        super(supplier.get(), properties);
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        super.entityInside(state, level, pos, entity);
        int direction = this.getBubbleColumnDirection(level, pos);
        if (direction != 0) {
            boolean dragDown = direction < 0;
            BlockState stateAbove = level.getBlockState(pos.above());
            if (stateAbove.isAir()) {
                entity.onAboveBubbleCol(dragDown);
            } else {
                entity.onInsideBubbleColumn(dragDown);
            }
        }
    }

    private int getBubbleColumnDirection(Level level, BlockPos pos) {
        BlockPos.MutableBlockPos mutablePos = pos.mutable();
        FluidType currentFluidType = level.getFluidState(pos).getFluidType();
        for (int i = 0; i < 384; ++i) {
            mutablePos.move(Direction.DOWN);
            BlockState state = level.getBlockState((BlockPos)mutablePos);
            if (state.is(Blocks.SOUL_SAND)) {
                return 1;
            }
            if (state.is(Blocks.MAGMA_BLOCK)) {
                return -1;
            }
            if (state.is((Block)this) || state.getFluidState().getFluidType() == currentFluidType) continue;
            return 0;
        }
        return 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void animateTick(@NotNull BlockState stateIn, @NotNull Level worldIn, @NotNull BlockPos pos, @NotNull RandomSource rand) {
        this.generateSteamParticles(worldIn, pos, rand);
        int direction = this.getBubbleColumnDirection(worldIn, pos);
        if (direction != 0) {
            FluidType fluidType = stateIn.getFluidState().getFluidType();
            ParticleOptions bubbleParticle = null;
            if (fluidType instanceof BaseFluidType) {
                BaseFluidType baseFluidType = (BaseFluidType)fluidType;
                bubbleParticle = baseFluidType.getBubbleParticle();
            }
            if (direction > 0) {
                if (bubbleParticle == null) {
                    bubbleParticle = ParticleTypes.BUBBLE_COLUMN_UP;
                }
                worldIn.addParticle(bubbleParticle, (double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5, 0.0, 0.04, 0.0);
                if (rand.nextInt(200) == 0) {
                    worldIn.playLocalSound((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.BUBBLE_COLUMN_UPWARDS_AMBIENT, SoundSource.BLOCKS, 0.2f + rand.nextFloat() * 0.2f, 0.9f + rand.nextFloat() * 0.15f, false);
                }
            } else {
                if (bubbleParticle == null) {
                    bubbleParticle = ParticleTypes.CURRENT_DOWN;
                }
                worldIn.addParticle(bubbleParticle, (double)pos.getX() + 0.5, (double)pos.getY() + 0.8, (double)pos.getZ() + 0.5, 0.0, -0.04, 0.0);
                if (rand.nextInt(200) == 0) {
                    worldIn.playLocalSound((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.BUBBLE_COLUMN_WHIRLPOOL_AMBIENT, SoundSource.BLOCKS, 0.2f + rand.nextFloat() * 0.2f, 0.9f + rand.nextFloat() * 0.15f, false);
                }
            }
        }
        double maxDistanceSqr = 9.0;
        for (Player player : worldIn.players()) {
            if (player.distanceToSqr((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5) > 9.0) continue;
            boolean isPlayerHeadUnderwater = CustomFluidHandler.isPlayerHeadInHotBath(player);
            if (!isPlayerHeadUnderwater) {
                SoundHandler.playAmbientWaterSound(worldIn, pos, rand);
            }
            this.handleClientPlayerUnderwaterState(player, rand);
            this.handleClientPlayerEnterWaterState(player, rand);
        }
    }

    private void handleClientPlayerEnterWaterState(Player player, RandomSource rand) {
        CompoundTag playerData = player.getPersistentData();
        boolean isPlayerInWater = CustomFluidHandler.isPlayerInHotBathBlock(player);
        if (isPlayerInWater) {
            if (!playerData.getBoolean(HOTBATH_ENTER_WATER_STATE)) {
                SoundHandler.playEnterWaterSound(player, rand);
                playerData.putBoolean(HOTBATH_ENTER_WATER_STATE, true);
                this.spawnSplashParticles(player, player.level(), rand);
            }
        } else if (playerData.getBoolean(HOTBATH_ENTER_WATER_STATE)) {
            playerData.putBoolean(HOTBATH_ENTER_WATER_STATE, false);
        }
    }

    private void spawnSplashParticles(Player player, Level level, RandomSource rand) {
        BaseFluidType baseFluidType;
        ParticleOptions bubble;
        BlockPos pos;
        BlockPos surfacePos = pos = player.blockPosition();
        while (level.getBlockState(surfacePos.above()).getBlock() instanceof AbstractHotbathBlock && surfacePos.getY() < level.getMaxBuildHeight()) {
            surfacePos = surfacePos.above();
        }
        BlockState state = level.getBlockState(surfacePos);
        FluidType fluidType = state.getFluidState().getFluidType();
        if (fluidType instanceof BaseFluidType && (bubble = (baseFluidType = (BaseFluidType)fluidType).getBubbleParticle()) != null) {
            float factor;
            float width = player.getBbWidth();
            int maxCount = (int)(20.0f + width * 10.0f);
            int count = (int)((float)maxCount * (factor = Mth.clamp((float)(player.fallDistance / 3.0f), (float)0.0f, (float)1.0f)));
            if (count <= 0) {
                return;
            }
            float fluidHeight = state.getFluidState().getHeight((BlockGetter)level, surfacePos);
            double surfaceY = (double)((float)surfacePos.getY() + fluidHeight) - 0.05;
            for (int i = 0; i < count; ++i) {
                double r = (double)width * (0.5 + rand.nextDouble() * 0.5);
                double angle = rand.nextDouble() * 2.0 * Math.PI;
                double offsetX = Math.cos(angle) * r;
                double offsetZ = Math.sin(angle) * r;
                double x = player.getX() + offsetX;
                double z = player.getZ() + offsetZ;
                double speed = 0.02 + rand.nextDouble() * 0.08;
                double vx = Math.cos(angle) * speed;
                double vz = Math.sin(angle) * speed;
                double vy = -0.05 - rand.nextDouble() * 0.1;
                level.addParticle(bubble, x, surfaceY, z, (vx += player.getDeltaMovement().x * 0.2) * 5.0, vy * 5.0, (vz += player.getDeltaMovement().z * 0.2) * 5.0);
            }
            int turbulenceCount = (int)(10.0f * factor);
            for (int i = 0; i < turbulenceCount; ++i) {
                double x = player.getX() + (rand.nextDouble() - 0.5) * (double)width;
                double z = player.getZ() + (rand.nextDouble() - 0.5) * (double)width;
                double vy = -0.1 - rand.nextDouble() * 0.2;
                level.addParticle(bubble, x, surfaceY, z, (rand.nextDouble() - 0.5) * 0.2, vy * 5.0, (rand.nextDouble() - 0.5) * 0.2);
            }
        }
    }

    private void handleClientPlayerUnderwaterState(Player player, RandomSource rand) {
        CompoundTag playerData = player.getPersistentData();
        boolean isPlayerHeadUnderwater = CustomFluidHandler.isPlayerHeadInHotBath(player);
        if (isPlayerHeadUnderwater) {
            if (!playerData.getBoolean(HOTBATH_UNDERWATER_STATE)) {
                SoundHandler.playUnderwaterEnterSound(player, rand);
                playerData.putBoolean(HOTBATH_UNDERWATER_STATE, true);
            } else {
                SoundHandler.playUnderwaterLoopSound(player, rand);
            }
        } else if (playerData.getBoolean(HOTBATH_UNDERWATER_STATE)) {
            SoundHandler.playExitWaterSound(player, rand);
            SoundHandler.stopUnderwaterLoopSound(player);
            playerData.putBoolean(HOTBATH_UNDERWATER_STATE, false);
        }
    }

    private void generateSteamParticles(Level worldIn, BlockPos pos, RandomSource rand) {
        BlockPos[] adjacentPositions = new BlockPos[]{pos.above(), pos.below(), pos.north(), pos.south(), pos.east(), pos.west()};
        int airBlockCount = 0;
        BlockPos[] airBlocks = new BlockPos[adjacentPositions.length];
        for (BlockPos adjacentPos : adjacentPositions) {
            if (!worldIn.getBlockState(adjacentPos).isAir()) continue;
            airBlocks[airBlockCount++] = adjacentPos;
        }
        if (airBlockCount > 0) {
            BlockPos selectedPos = airBlocks[rand.nextInt(airBlockCount)];
            ParticleGenerator.renderDefaultSteam((ClientLevel)worldIn, selectedPos, rand);
        }
    }
}

