/*
 * Decompiled with CFR 0.152.
 */
package com.crabmod.hotbath.fluid_details;

import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class BaseFluidType
extends FluidType {
    private final ResourceLocation stillTexture;
    private final ResourceLocation flowingTexture;
    private final ResourceLocation overlayTexture;
    private final int tintColor;
    private final Vector3f fogColor;
    private final Supplier<? extends ParticleOptions> dripParticle;
    private final Supplier<? extends ParticleOptions> bubbleParticle;
    private final Supplier<? extends ParticleOptions> splashParticle;
    private final Supplier<Fluid> fluidSupplier;

    public BaseFluidType(ResourceLocation stillTexture, ResourceLocation flowingTexture, ResourceLocation overlayTexture, int tintColor, Vector3f fogColor, FluidType.Properties properties, Supplier<? extends ParticleOptions> dripParticle, Supplier<? extends ParticleOptions> bubbleParticle, Supplier<? extends ParticleOptions> splashParticle, Supplier<Fluid> fluidSupplier) {
        super(properties);
        this.stillTexture = stillTexture;
        this.flowingTexture = flowingTexture;
        this.overlayTexture = overlayTexture;
        this.tintColor = tintColor;
        this.fogColor = fogColor;
        this.dripParticle = dripParticle;
        this.bubbleParticle = bubbleParticle;
        this.splashParticle = splashParticle;
        this.fluidSupplier = fluidSupplier;
    }

    public ParticleOptions getBubbleParticle() {
        return this.bubbleParticle != null ? this.bubbleParticle.get() : null;
    }

    public ParticleOptions getSplashParticle() {
        return this.splashParticle != null ? this.splashParticle.get() : null;
    }

    public ResourceLocation getStillTexture() {
        return this.stillTexture;
    }

    public ResourceLocation getFlowingTexture() {
        return this.flowingTexture;
    }

    public ResourceLocation getOverlayTexture() {
        return this.overlayTexture;
    }

    public int getTintColor() {
        return this.tintColor;
    }

    public Vector3f getFogColor() {
        return this.fogColor;
    }

    @Nullable
    public FluidType.DripstoneDripInfo getDripInfo() {
        if (this.dripParticle != null) {
            return new FluidType.DripstoneDripInfo(0.17578125f, this.dripParticle.get(), this.fluidSupplier != null ? this.fluidSupplier.get().defaultFluidState().createLegacyBlock().getBlock() : null);
        }
        return super.getDripInfo();
    }

    public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
        consumer.accept(new IClientFluidTypeExtensions(){

            public ResourceLocation getStillTexture() {
                return BaseFluidType.this.stillTexture;
            }

            public ResourceLocation getFlowingTexture() {
                return BaseFluidType.this.flowingTexture;
            }

            public ResourceLocation getOverlayTexture() {
                return BaseFluidType.this.overlayTexture;
            }

            public int getTintColor() {
                return BaseFluidType.this.tintColor;
            }

            @NotNull
            public Vector3f modifyFogColor(Camera camera, float partialTick, ClientLevel level, int renderDistance, float darkenWorldAmount, Vector3f fluidFogColor) {
                return BaseFluidType.this.fogColor;
            }
        });
    }
}

