/*
 * Decompiled with CFR 0.152.
 */
package com.crabmod.hotbath.items;

import com.crabmod.hotbath.compat.BathWaterBottleColdSweatModifier;
import com.crabmod.hotbath.compat.BathWaterBottleLSOModifier;
import com.crabmod.hotbath.compat.BathWaterBottleTANModifier;
import com.crabmod.hotbath.compat.ColdSweatIntegration;
import com.crabmod.hotbath.compat.LegendarySurvivalOverhaulIntegration;
import com.crabmod.hotbath.compat.ToughAsNailsIntegration;
import com.crabmod.hotbath.compat.ToughAsNailsThirstHelper;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.core.Holder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class BathWaterEffects {
    private static final Random RANDOM = new Random();

    public static void hotWaterEffect(LivingEntity entity) {
        entity.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 900, 0, false, false, true));
        BathWaterEffects.applyDrinkTemperatureEffects(entity);
    }

    public static void hotWaterSplashEffect(LivingEntity entity) {
        entity.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 600, 1, false, false, true));
        BathWaterEffects.applySplashTemperatureEffects(entity);
    }

    public static void honeyBathEffect(LivingEntity entity) {
        entity.addEffect(new MobEffectInstance(MobEffects.ABSORPTION, 900, 0, false, false, true));
        BathWaterEffects.applyDrinkTemperatureEffects(entity);
    }

    public static void honeyBathSplashEffect(LivingEntity entity) {
        entity.addEffect(new MobEffectInstance(MobEffects.ABSORPTION, 600, 1, false, false, true));
        BathWaterEffects.applySplashTemperatureEffects(entity);
    }

    public static void milkBathEffect(LivingEntity entity) {
        BathWaterEffects.removeNegativeEffects(entity, 1);
        BathWaterEffects.applyDrinkTemperatureEffects(entity);
    }

    public static void milkBathSplashEffect(LivingEntity entity) {
        BathWaterEffects.removeNegativeEffects(entity, 2);
        BathWaterEffects.applySplashTemperatureEffects(entity);
    }

    private static void removeNegativeEffects(LivingEntity entity, int count) {
        ArrayList<MobEffectInstance> harmfulEffects = new ArrayList<MobEffectInstance>();
        for (MobEffectInstance effect : entity.getActiveEffects()) {
            Holder effectHolder = effect.getEffect();
            if (!BathWaterEffects.isHarmfulEffect((Holder<MobEffect>)effectHolder) || effectHolder == MobEffects.UNLUCK) continue;
            harmfulEffects.add(effect);
        }
        for (int i = 0; i < count && !harmfulEffects.isEmpty(); ++i) {
            MobEffectInstance effectToRemove = (MobEffectInstance)harmfulEffects.get(RANDOM.nextInt(harmfulEffects.size()));
            entity.removeEffect(effectToRemove.getEffect());
            harmfulEffects.remove(effectToRemove);
        }
    }

    public static void herbalBathEffect(LivingEntity entity) {
        entity.heal(6.0f);
        entity.addEffect(new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 900, 0, false, false, true));
        BathWaterEffects.applyDrinkTemperatureEffects(entity);
    }

    public static void herbalBathSplashEffect(LivingEntity entity) {
        entity.heal(4.0f);
        entity.addEffect(new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 600, 1, false, false, true));
        BathWaterEffects.applySplashTemperatureEffects(entity);
    }

    public static void peonyBathEffect(LivingEntity entity) {
        entity.addEffect(new MobEffectInstance(MobEffects.LUCK, 900, 0, false, false, true));
        BathWaterEffects.applyDrinkTemperatureEffects(entity);
    }

    public static void peonyBathSplashEffect(LivingEntity entity) {
        entity.addEffect(new MobEffectInstance(MobEffects.LUCK, 600, 1, false, false, true));
        BathWaterEffects.applySplashTemperatureEffects(entity);
    }

    public static void roseBathEffect(LivingEntity entity) {
        entity.addEffect(new MobEffectInstance(MobEffects.DAMAGE_BOOST, 900, 0, false, false, true));
        BathWaterEffects.applyDrinkTemperatureEffects(entity);
    }

    public static void roseBathSplashEffect(LivingEntity entity) {
        entity.addEffect(new MobEffectInstance(MobEffects.DAMAGE_BOOST, 600, 1, false, false, true));
        BathWaterEffects.applySplashTemperatureEffects(entity);
    }

    private static void applyDrinkTemperatureEffects(LivingEntity entity) {
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (ToughAsNailsIntegration.isToughAsNailsLoaded()) {
            BathWaterBottleTANModifier.applyWarmEffect(player);
            ToughAsNailsThirstHelper.restoreThirst(player);
        }
        if (ColdSweatIntegration.isColdSweatLoaded()) {
            BathWaterBottleColdSweatModifier.applyWarmEffect(player);
        }
        if (LegendarySurvivalOverhaulIntegration.isLSOLoaded()) {
            BathWaterBottleLSOModifier.applyWarmEffect(player);
        }
    }

    private static void applySplashTemperatureEffects(LivingEntity entity) {
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (ToughAsNailsIntegration.isToughAsNailsLoaded()) {
            BathWaterBottleTANModifier.applySplashWarmEffect(player);
        }
        if (ColdSweatIntegration.isColdSweatLoaded()) {
            BathWaterBottleColdSweatModifier.applySplashWarmEffect(player);
        }
        if (LegendarySurvivalOverhaulIntegration.isLSOLoaded()) {
            BathWaterBottleLSOModifier.applySplashWarmEffect(player);
        }
    }

    public static void applyTemperatureEffectsOnly(Player player) {
        if (ToughAsNailsIntegration.isToughAsNailsLoaded()) {
            BathWaterBottleTANModifier.applyWarmEffect(player);
        }
        if (ColdSweatIntegration.isColdSweatLoaded()) {
            BathWaterBottleColdSweatModifier.applyWarmEffect(player);
        }
        if (LegendarySurvivalOverhaulIntegration.isLSOLoaded()) {
            BathWaterBottleLSOModifier.applyWarmEffect(player);
        }
    }

    private static boolean isHarmfulEffect(Holder<MobEffect> effectHolder) {
        MobEffect effect = (MobEffect)effectHolder.value();
        return !effect.isBeneficial() && effectHolder != MobEffects.UNLUCK;
    }
}

