/*
 * Decompiled with CFR 0.152.
 */
package com.crabmod.hotbath.items;

import com.crabmod.hotbath.items.ThrownBathWater;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class SplashBathWaterBottleItem
extends Item {
    private final Consumer<LivingEntity> drinkEffect;
    private final Supplier<SimpleParticleType> particleType;
    private final Supplier<SimpleParticleType> bubbleParticleType;
    private final Supplier<SimpleParticleType> effectParticleType;
    private final int color;

    public SplashBathWaterBottleItem(Item.Properties properties, Consumer<LivingEntity> drinkEffect, Supplier<SimpleParticleType> particleType, Supplier<SimpleParticleType> bubbleParticleType, Supplier<SimpleParticleType> effectParticleType, int color) {
        super(properties);
        this.drinkEffect = drinkEffect;
        this.particleType = particleType;
        this.bubbleParticleType = bubbleParticleType;
        this.effectParticleType = effectParticleType;
        this.color = color;
    }

    public int getColor() {
        return this.color;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.SPLASH_POTION_THROW, SoundSource.PLAYERS, 0.5f, 0.4f / (level.getRandom().nextFloat() * 0.4f + 0.8f));
        if (!level.isClientSide) {
            ThrownBathWater thrownBathWater = new ThrownBathWater(level, (LivingEntity)player);
            thrownBathWater.setItem(itemstack);
            thrownBathWater.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), -20.0f, 0.5f, 1.0f);
            level.addFreshEntity((Entity)thrownBathWater);
        }
        player.awardStat(Stats.ITEM_USED.get((Object)this));
        if (!player.getAbilities().instabuild) {
            itemstack.shrink(1);
        }
        return InteractionResultHolder.sidedSuccess((Object)itemstack, (boolean)level.isClientSide());
    }

    public void applyEffect(LivingEntity entity) {
        if (this.drinkEffect != null) {
            this.drinkEffect.accept(entity);
        }
    }

    public SimpleParticleType getParticleType() {
        return this.particleType.get();
    }

    public SimpleParticleType getBubbleParticleType() {
        return this.bubbleParticleType.get();
    }

    public SimpleParticleType getEffectParticleType() {
        return this.effectParticleType.get();
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        tooltipComponents.add((Component)Component.translatable((String)(this.getDescriptionId() + ".desc")).withStyle(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
    }
}

