/*
 * Decompiled with CFR 0.152.
 */
package com.crabmod.hotbath.items;

import com.crabmod.hotbath.items.SplashBathWaterBottleItem;
import com.crabmod.hotbath.registers.EntityRegister;
import com.crabmod.hotbath.registers.ItemRegister;
import com.crabmod.hotbath.registers.ParticleRegister;
import java.util.List;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;

public class ThrownBathWater
extends ThrowableItemProjectile {
    public ThrownBathWater(EntityType<? extends ThrowableItemProjectile> entityType, Level level) {
        super(entityType, level);
    }

    public ThrownBathWater(Level level, LivingEntity shooter) {
        super((EntityType)EntityRegister.THROWN_BATH_WATER.get(), shooter, level);
    }

    public ThrownBathWater(Level level, double x, double y, double z) {
        super((EntityType)EntityRegister.THROWN_BATH_WATER.get(), x, y, z, level);
    }

    protected Item getDefaultItem() {
        return (Item)ItemRegister.HOT_WATER_BOTTLE.get();
    }

    protected double getDefaultGravity() {
        return 0.05;
    }

    protected void onHit(HitResult result) {
        super.onHit(result);
        if (!this.level().isClientSide) {
            this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.SPLASH_POTION_BREAK, SoundSource.NEUTRAL, 1.0f, this.random.nextFloat() * 0.1f + 0.9f);
            ItemStack stack = this.getItem();
            Item item = stack.getItem();
            if (item instanceof SplashBathWaterBottleItem) {
                SplashBathWaterBottleItem splashItem = (SplashBathWaterBottleItem)item;
                this.applySplash(splashItem);
            }
            this.level().broadcastEntityEvent((Entity)this, (byte)3);
            this.discard();
        }
    }

    private void applySplash(SplashBathWaterBottleItem splashItem) {
        AABB aabb = this.getBoundingBox().inflate(4.0, 2.0, 4.0);
        List list = this.level().getEntitiesOfClass(LivingEntity.class, aabb);
        if (!list.isEmpty()) {
            for (LivingEntity livingentity : list) {
                double d0;
                if (!livingentity.isAffectedByPotions() || !((d0 = this.distanceToSqr((Entity)livingentity)) < 16.0)) continue;
                splashItem.applyEffect(livingentity);
            }
        }
    }

    public void handleEntityEvent(byte id) {
        if (id == 3) {
            ItemStack stack = this.getItem();
            SimpleParticleType particleType = ParticleTypes.SPLASH;
            SimpleParticleType bubbleParticleType = null;
            Item item = stack.getItem();
            if (item instanceof SplashBathWaterBottleItem) {
                double offsetZ;
                double offsetX;
                double angle;
                double radius;
                int k;
                SplashBathWaterBottleItem splashItem = (SplashBathWaterBottleItem)item;
                particleType = splashItem.getParticleType();
                bubbleParticleType = splashItem.getBubbleParticleType();
                int color = splashItem.getColor();
                double r = (double)(color >> 16 & 0xFF) / 255.0;
                double g = (double)(color >> 8 & 0xFF) / 255.0;
                double b = (double)(color & 0xFF) / 255.0;
                SimpleParticleType effectParticle = splashItem.getEffectParticleType();
                for (k = 0; k < 20; ++k) {
                    double d3 = this.random.nextDouble() * 2.0;
                    double d4 = this.random.nextDouble() * Math.PI * 2.0;
                    double d5 = Math.cos(d4) * d3;
                    double d7 = Math.sin(d4) * d3;
                    this.level().addParticle((ParticleOptions)effectParticle, this.getX() + d5 * 0.1, this.getY() + 0.3, this.getZ() + d7 * 0.1, r, g, b);
                }
                for (k = 0; k < 10; ++k) {
                    radius = this.random.nextDouble() * 0.5;
                    angle = this.random.nextDouble() * Math.PI * 2.0;
                    offsetX = Math.cos(angle) * radius;
                    offsetZ = Math.sin(angle) * radius;
                    this.level().addParticle((ParticleOptions)ParticleRegister.STEAM_PARTICLE.get(), this.getX() + offsetX, this.getY() + 0.2, this.getZ() + offsetZ, 0.0, 0.1 + this.random.nextDouble() * 0.05, 0.0);
                }
                for (k = 0; k < 15; ++k) {
                    radius = 0.5 + this.random.nextDouble() * 2.0;
                    angle = this.random.nextDouble() * Math.PI * 2.0;
                    offsetX = Math.cos(angle) * radius;
                    offsetZ = Math.sin(angle) * radius;
                    this.level().addParticle((ParticleOptions)ParticleRegister.STEAM_PARTICLE.get(), this.getX() + offsetX, this.getY() + 0.1, this.getZ() + offsetZ, 0.0, 0.02 + this.random.nextDouble() * 0.03, 0.0);
                }
                for (int i = 0; i < 16; ++i) {
                    double d0 = (this.random.nextDouble() * 2.0 - 1.0) * 0.5;
                    double d1 = (this.random.nextDouble() * 2.0 - 1.0) * 0.5;
                    this.level().addParticle((ParticleOptions)particleType, this.getX() + d0, this.getY() + 0.2, this.getZ() + d1, d0, 0.2, d1);
                }
            } else {
                for (int i = 0; i < 8; ++i) {
                    this.level().addParticle((ParticleOptions)particleType, this.getX(), this.getY() + 0.2, this.getZ(), ((double)this.random.nextFloat() - 0.5) * 0.08, ((double)this.random.nextFloat() - 0.5) * 0.08, ((double)this.random.nextFloat() - 0.5) * 0.08);
                }
            }
            if (bubbleParticleType != null) {
                for (int i = 0; i < 8; ++i) {
                    this.level().addParticle((ParticleOptions)bubbleParticleType, this.getX(), this.getY() + 0.2, this.getZ(), ((double)this.random.nextFloat() - 0.5) * 0.08, ((double)this.random.nextFloat() - 0.5) * 0.08, ((double)this.random.nextFloat() - 0.5) * 0.08);
                }
            }
            for (int j = 0; j < 8; ++j) {
                this.level().addParticle((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, stack), this.getX(), this.getY() + 0.2, this.getZ(), ((double)this.random.nextFloat() - 0.5) * 0.15, 0.15, ((double)this.random.nextFloat() - 0.5) * 0.15);
            }
        }
    }
}

