/*
 * Decompiled with CFR 0.152.
 */
package com.crabmod.hotbath.util;

import com.crabmod.hotbath.registers.ItemRegister;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;

@EventBusSubscriber(modid="hotbath")
public class CraftingEventHandler {
    @SubscribeEvent
    public static void onItemCrafted(PlayerEvent.ItemCraftedEvent event) {
        Container container = event.getInventory();
        if (container instanceof CraftingContainer) {
            ItemStack itemStack;
            CraftingContainer craftingInventory = (CraftingContainer)container;
            boolean foundHotWaterBucket = false;
            for (int i = 0; i < craftingInventory.getContainerSize(); ++i) {
                itemStack = craftingInventory.getItem(i);
                if (itemStack.getItem() != ItemRegister.HOT_WATER_BUCKET.get()) continue;
                foundHotWaterBucket = true;
                break;
            }
            if (foundHotWaterBucket && (itemStack = event.getEntity()) instanceof Player) {
                ItemStack player = itemStack;
                ItemStack emptyBucket = new ItemStack((ItemLike)Items.BUCKET);
                if (!player.getInventory().add(emptyBucket)) {
                    player.drop(emptyBucket, false);
                }
            }
        }
    }
}

