/*
 * Decompiled with CFR 0.152.
 */
package net.rizen.submarines.api.client.hud;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_1297;
import net.minecraft.class_2561;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import net.minecraft.class_757;
import net.minecraft.class_9779;
import net.minecraft.class_9801;
import net.rizen.submarines.api.client.input.SubmarineInputHandler;
import net.rizen.submarines.api.submarine.BaseSubmarine;
import net.rizen.submarines.api.submarine.sonar.ContactType;
import net.rizen.submarines.api.submarine.sonar.SonarContact;
import net.rizen.submarines.api.submarine.sonar.SonarSystem;
import org.joml.Matrix4f;

public class SubmarineHud
implements HudRenderCallback {
    private float clientSweepAngle = 0.0f;
    private static final float SWEEP_SPEED = 1.5f;
    private static final int RADAR_RADIUS = 45;
    private static final int RADAR_CENTER_X_OFFSET = 0;
    private static final int RADAR_CENTER_Y_OFFSET = -25;
    private static final float GRID_CIRCLE_COUNT = 3.0f;

    public static void register() {
        HudRenderCallback.EVENT.register((Object)new SubmarineHud());
    }

    public void onHudRender(class_332 drawContext, class_9779 tickCounter) {
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null) {
            return;
        }
        class_1297 vehicle = client.field_1724.method_5854();
        if (!(vehicle instanceof BaseSubmarine)) {
            return;
        }
        BaseSubmarine submarine = (BaseSubmarine)vehicle;
        if (!SubmarineInputHandler.isSubmarineHudMode()) {
            return;
        }
        if (client.field_1690.field_1842) {
            return;
        }
        int screenWidth = client.method_22683().method_4486();
        int screenHeight = client.method_22683().method_4502();
        this.renderTorpedoInfo(drawContext, client, submarine, screenWidth, screenHeight);
        this.renderSubmarineStats(drawContext, client, submarine, screenWidth, screenHeight);
        if (SubmarineInputHandler.isSonarEnabled()) {
            this.renderSonarDisplay(drawContext, submarine, screenWidth, screenHeight, tickCounter.method_60637(true));
        }
    }

    private void renderSubmarineStats(class_332 drawContext, class_310 client, BaseSubmarine submarine, int screenWidth, int screenHeight) {
        int submarineWidth = Math.max(client.field_1772.method_1727("SUBMARINE"), Math.max(client.field_1772.method_1727("Health: 100%"), Math.max(client.field_1772.method_1727("Power: 100%"), Math.max(client.field_1772.method_1727("Depth: 999 b"), Math.max(client.field_1772.method_1727("Speed: -99.9 b/s"), client.field_1772.method_1727("Mode: Cruise"))))));
        int torpedoWidth = 120;
        int gap = 20;
        int startX = screenWidth - submarineWidth - gap;
        int startY = screenHeight - 125;
        float health = submarine.getHealth();
        float power = submarine.getPower();
        int depth = submarine.getDepth();
        float speed = submarine.getSpeed() * 20.0f;
        int textY = startY;
        drawContext.method_51439(client.field_1772, (class_2561)class_2561.method_43471((String)"submarines.hud.submarine"), startX, textY, -16733441, true);
        drawContext.method_51439(client.field_1772, (class_2561)class_2561.method_43469((String)"submarines.hud.health", (Object[])new Object[]{String.format("%.0f", Float.valueOf(health))}), startX, textY + 12, this.getHealthColor(health), false);
        drawContext.method_51439(client.field_1772, (class_2561)class_2561.method_43469((String)"submarines.hud.power", (Object[])new Object[]{String.format("%.0f", Float.valueOf(power))}), startX, textY + 24, this.getPowerColor(power), false);
        drawContext.method_51439(client.field_1772, (class_2561)class_2561.method_43469((String)"submarines.hud.depth", (Object[])new Object[]{depth}), startX, textY + 36, -1, false);
        drawContext.method_51439(client.field_1772, (class_2561)class_2561.method_43469((String)"submarines.hud.speed", (Object[])new Object[]{String.format("%.1f", Float.valueOf(speed))}), startX, textY + 48, -1, false);
        drawContext.method_51439(client.field_1772, (class_2561)class_2561.method_43469((String)"submarines.hud.mode", (Object[])new Object[]{submarine.getMovementMode().getDisplayName()}), startX, textY + 60, -16711681, false);
        boolean sonarEnabled = SubmarineInputHandler.isSonarEnabled();
        int sonarColor = sonarEnabled ? -16711936 : -7829368;
        drawContext.method_51439(client.field_1772, (class_2561)class_2561.method_43471((String)(sonarEnabled ? "submarines.hud.sonar.active" : "submarines.hud.sonar.off")), startX, textY + 72, sonarColor, false);
        if (sonarEnabled) {
            drawContext.method_51439(client.field_1772, (class_2561)class_2561.method_43471((String)"submarines.hud.sonar.ping_hint"), startX, textY + 84, -5592406, false);
            float cooldownProgress = SubmarineInputHandler.getSonarCooldownProgress();
            int barWidth = 100;
            int barHeight = 4;
            int barX = startX;
            int barY = textY + 96;
            drawContext.method_25294(barX, barY, barX + barWidth, barY + barHeight, -13421773);
            int fillWidth = (int)((float)barWidth * cooldownProgress);
            int barColor = cooldownProgress >= 1.0f ? -16711936 : -7829368;
            drawContext.method_25294(barX, barY, barX + fillWidth, barY + barHeight, barColor);
        }
    }

    private void renderTorpedoInfo(class_332 drawContext, class_310 client, BaseSubmarine submarine, int screenWidth, int screenHeight) {
        int startY;
        int gap;
        int torpedoWidth = 120;
        int startX = gap = 20;
        int textY = startY = screenHeight - 125;
        drawContext.method_51439(client.field_1772, (class_2561)class_2561.method_43471((String)"submarines.hud.torpedoes"), startX, textY, -48060, true);
        int torpedoCount = submarine.getTorpedoCount();
        class_5250 countText = class_2561.method_43469((String)"submarines.hud.ammo", (Object[])new Object[]{torpedoCount});
        int countColor = torpedoCount > 0 ? -16711936 : -65536;
        drawContext.method_51439(client.field_1772, (class_2561)countText, startX, textY + 12, countColor, false);
        drawContext.method_51439(client.field_1772, (class_2561)class_2561.method_43469((String)"submarines.hud.target", (Object[])new Object[]{submarine.getTargetingMode().getDisplayName()}), startX, textY + 24, -22016, false);
        int armingTimer = submarine.getTorpedoArmingTimer();
        boolean isArmed = submarine.isTorpedoArmed();
        textY += 36;
        if (torpedoCount == 0) {
            drawContext.method_51439(client.field_1772, (class_2561)class_2561.method_43471((String)"submarines.hud.status.no_ammo"), startX, textY, -7829368, false);
        } else if (armingTimer > 0) {
            drawContext.method_51439(client.field_1772, (class_2561)class_2561.method_43471((String)"submarines.hud.status.arming"), startX, textY, -22016, false);
            int barY = textY + 12;
            int barHeight = 6;
            drawContext.method_25294(startX, barY, startX + torpedoWidth, barY + barHeight, -12320768);
            float progress = 1.0f - (float)armingTimer / 60.0f;
            int fillWidth = (int)((float)torpedoWidth * progress);
            drawContext.method_25294(startX, barY, startX + fillWidth, barY + barHeight, -65536);
            int progressPercent = (int)(progress * 100.0f);
            String progressText = String.format("%d%%", progressPercent);
            int progressTextX = startX + torpedoWidth / 2 - client.field_1772.method_1727(progressText) / 2;
            drawContext.method_51439(client.field_1772, (class_2561)class_2561.method_43470((String)progressText), progressTextX, barY + barHeight + 4, -1, false);
        } else if (isArmed) {
            drawContext.method_51439(client.field_1772, (class_2561)class_2561.method_43471((String)"submarines.hud.status.ready"), startX, textY, -16711936, true);
            drawContext.method_51439(client.field_1772, (class_2561)class_2561.method_43471((String)"submarines.hud.fire_hint"), startX, textY + 12, -5592406, false);
        }
    }

    private int getHealthColor(float health) {
        if (health > 75.0f) {
            return -16711936;
        }
        if (health > 50.0f) {
            return -256;
        }
        if (health > 25.0f) {
            return -30720;
        }
        return -65536;
    }

    private int getPowerColor(float power) {
        if (power > 50.0f) {
            return -16711681;
        }
        if (power > 25.0f) {
            return -256;
        }
        if (power > 10.0f) {
            return -30720;
        }
        return -65536;
    }

    private void renderSonarDisplay(class_332 drawContext, BaseSubmarine submarine, int screenWidth, int screenHeight, float tickDelta) {
        SonarSystem sonarSystem = submarine.getSonarSystem();
        long currentTime = System.currentTimeMillis();
        this.clientSweepAngle += 1.5f;
        if (this.clientSweepAngle >= 360.0f) {
            this.clientSweepAngle -= 360.0f;
        }
        int centerX = screenWidth / 2 + 0;
        int centerY = screenHeight - 45 - 20 + -25;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        this.renderRadarBackground(drawContext, centerX, centerY);
        this.renderGridCircles(drawContext, centerX, centerY);
        this.renderTerrainArcs(drawContext, submarine, centerX, centerY, currentTime);
        this.renderContactBlips(drawContext, submarine, centerX, centerY, currentTime);
        this.renderSweepLine(drawContext, centerX, centerY, this.clientSweepAngle, tickDelta);
        this.renderCenterDot(drawContext, centerX, centerY);
        RenderSystem.disableBlend();
    }

    private void renderRadarBackground(class_332 drawContext, int centerX, int centerY) {
        int color = 0x40000000;
        this.drawFilledCircle(drawContext, centerX, centerY, 45, color);
        int borderColor = -16711936;
        this.drawCircleOutline(drawContext, centerX, centerY, 45, borderColor, 2.0f);
    }

    private void renderGridCircles(class_332 drawContext, int centerX, int centerY) {
        int gridColor = 0x4000FF00;
        int i = 1;
        while ((float)i <= 3.0f) {
            int radius = (int)(45.0f * ((float)i / 3.0f));
            this.drawCircleOutline(drawContext, centerX, centerY, radius, gridColor, 1.0f);
            ++i;
        }
    }

    private void renderSweepLine(class_332 drawContext, int centerX, int centerY, float sweepAngle, float tickDelta) {
        float angleRad = (float)Math.toRadians(sweepAngle);
        int endX = centerX + (int)(Math.sin(angleRad) * 45.0);
        int endY = centerY - (int)(Math.cos(angleRad) * 45.0);
        int sweepColor = -2147418368;
        this.drawLine(drawContext, centerX, centerY, endX, endY, sweepColor, 2.0f);
        for (int i = -10; i < 0; i += 2) {
            float glowAngle = sweepAngle + (float)i * 1.5f;
            float glowAngleRad = (float)Math.toRadians(glowAngle);
            int glowEndX = centerX + (int)(Math.sin(glowAngleRad) * 45.0);
            int glowEndY = centerY - (int)(Math.cos(glowAngleRad) * 45.0);
            int alpha = (int)(40.0f * (1.0f + (float)i / 10.0f));
            int glowColorWithAlpha = alpha << 24 | 0xFF00;
            this.drawLine(drawContext, centerX, centerY, glowEndX, glowEndY, glowColorWithAlpha, 1.0f);
        }
    }

    private void renderCenterDot(class_332 drawContext, int centerX, int centerY) {
        int dotColor = -65536;
        this.drawFilledCircle(drawContext, centerX, centerY, 2, dotColor);
    }

    private void renderContactBlips(class_332 drawContext, BaseSubmarine submarine, int centerX, int centerY, long currentTime) {
        SonarSystem sonarSystem = submarine.getSonarSystem();
        List<SonarContact> contacts = sonarSystem.getContacts();
        for (SonarContact contact : contacts) {
            float alpha;
            if (contact.getType() == ContactType.TERRAIN) continue;
            if (!contact.isRevealed() && this.isAngleInSweep(contact.getAngle(), this.clientSweepAngle)) {
                contact.reveal(currentTime);
            }
            if (!contact.isRevealed() || (alpha = contact.getFadeAlpha(currentTime)) <= 0.0f) continue;
            double distance = contact.getDistance();
            double normalizedDistance = Math.min(distance / sonarSystem.getMaxRange(), 1.0);
            int blipRadius = (int)(normalizedDistance * 45.0);
            float angleRad = (float)Math.toRadians(contact.getAngle());
            int blipX = centerX + (int)(Math.sin(angleRad) * (double)blipRadius);
            int blipY = centerY - (int)(Math.cos(angleRad) * (double)blipRadius);
            int blipSize = this.getBlipSize(contact.getType());
            int blipColor = this.getBlipColor(contact.getType(), alpha);
            this.drawFilledCircle(drawContext, blipX, blipY, blipSize, blipColor);
        }
    }

    private boolean isAngleInSweep(float contactAngle, float sweepAngle) {
        float tolerance = 3.5f;
        float diff = Math.abs(this.normalizeAngle(sweepAngle - contactAngle));
        return diff <= tolerance;
    }

    private float normalizeAngle(float angle) {
        while (angle > 180.0f) {
            angle -= 360.0f;
        }
        while (angle < -180.0f) {
            angle += 360.0f;
        }
        return angle;
    }

    private void renderTerrainArcs(class_332 drawContext, BaseSubmarine submarine, int centerX, int centerY, long currentTime) {
        SonarSystem sonarSystem = submarine.getSonarSystem();
        List<SonarContact> contacts = sonarSystem.getContacts();
        HashMap<Integer, List> terrainByAngleBucket = new HashMap<Integer, List>();
        for (SonarContact sonarContact : contacts) {
            if (sonarContact.getType() != ContactType.TERRAIN) continue;
            if (!sonarContact.isRevealed() && this.isAngleInSweep(sonarContact.getAngle(), this.clientSweepAngle)) {
                sonarContact.reveal(currentTime);
            }
            if (!sonarContact.isRevealed()) continue;
            int angleBucket = (int)(sonarContact.getAngle() / 2.0f) * 2;
            terrainByAngleBucket.computeIfAbsent(angleBucket, k -> new ArrayList()).add(sonarContact);
        }
        for (Map.Entry entry : terrainByAngleBucket.entrySet()) {
            float alpha;
            SonarContact closestContact = ((List)entry.getValue()).stream().min(Comparator.comparingDouble(SonarContact::getDistance)).orElse(null);
            if (closestContact == null || (alpha = closestContact.getFadeAlpha(currentTime)) <= 0.0f) continue;
            double distance = closestContact.getDistance();
            double normalizedDistance = Math.min(distance / sonarSystem.getMaxRange(), 1.0);
            int arcRadius = (int)(normalizedDistance * 45.0);
            float startAngle = closestContact.getAngle() - 4.0f;
            float endAngle = closestContact.getAngle() + 4.0f;
            int arcColor = this.getTerrainArcColor(alpha);
            this.drawArc(drawContext, centerX, centerY, arcRadius, startAngle, endAngle, arcColor, 4.0f);
        }
    }

    private int getBlipSize(ContactType type) {
        return switch (type) {
            case ContactType.SMALL_MOB -> 2;
            case ContactType.MEDIUM_ENTITY -> 3;
            case ContactType.PLAYER -> 3;
            case ContactType.ITEM -> 1;
            case ContactType.SUBMARINE -> 5;
            default -> 2;
        };
    }

    private int getBlipColor(ContactType type, float alpha) {
        int alphaInt = (int)(alpha * 255.0f);
        return switch (type) {
            case ContactType.SMALL_MOB -> alphaInt << 24 | 0xFFFF;
            case ContactType.MEDIUM_ENTITY -> alphaInt << 24 | 0xFFFF00;
            case ContactType.PLAYER -> alphaInt << 24 | 0xAA00FF;
            case ContactType.ITEM -> alphaInt << 24 | 0xFFFFFF;
            case ContactType.SUBMARINE -> alphaInt << 24 | 0xFF0000;
            default -> alphaInt << 24 | 0xFFFFFF;
        };
    }

    private int getTerrainArcColor(float alpha) {
        int alphaInt = (int)(alpha * 255.0f);
        return alphaInt << 24 | 0x88FF88;
    }

    private void drawFilledCircle(class_332 drawContext, int centerX, int centerY, int radius, int color) {
        Matrix4f matrix = drawContext.method_51448().method_23760().method_23761();
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        RenderSystem.setShader(class_757::method_34540);
        RenderSystem.disableDepthTest();
        RenderSystem.disableCull();
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_60827(class_293.class_5596.field_27381, class_290.field_1576);
        buffer.method_22918(matrix, (float)centerX, (float)centerY, 0.0f).method_22915(r, g, b, a);
        int segments = Math.max(32, radius * 2);
        for (int i = 0; i <= segments; ++i) {
            double angle = Math.PI * 2 * (double)i / (double)segments;
            float x = (float)centerX + (float)(Math.cos(angle) * (double)radius);
            float y = (float)centerY + (float)(Math.sin(angle) * (double)radius);
            buffer.method_22918(matrix, x, y, 0.0f).method_22915(r, g, b, a);
        }
        class_286.method_43433((class_9801)buffer.method_60800());
        RenderSystem.enableDepthTest();
        RenderSystem.enableCull();
    }

    private void drawCircleOutline(class_332 drawContext, int centerX, int centerY, int radius, int color, float thickness) {
        Matrix4f matrix = drawContext.method_51448().method_23760().method_23761();
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        RenderSystem.setShader(class_757::method_34540);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.lineWidth((float)thickness);
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_60827(class_293.class_5596.field_29345, class_290.field_1576);
        int segments = Math.max(64, radius * 2);
        for (int i = 0; i <= segments; ++i) {
            double angle = Math.PI * 2 * (double)i / (double)segments;
            float x = (float)centerX + (float)(Math.cos(angle) * (double)radius);
            float y = (float)centerY + (float)(Math.sin(angle) * (double)radius);
            buffer.method_22918(matrix, x, y, 0.0f).method_22915(r, g, b, a);
        }
        class_286.method_43433((class_9801)buffer.method_60800());
        RenderSystem.lineWidth((float)1.0f);
    }

    private void drawLine(class_332 drawContext, int x1, int y1, int x2, int y2, int color, float thickness) {
        Matrix4f matrix = drawContext.method_51448().method_23760().method_23761();
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        RenderSystem.setShader(class_757::method_34540);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.lineWidth((float)thickness);
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_60827(class_293.class_5596.field_29344, class_290.field_1576);
        buffer.method_22918(matrix, (float)x1, (float)y1, 0.0f).method_22915(r, g, b, a);
        buffer.method_22918(matrix, (float)x2, (float)y2, 0.0f).method_22915(r, g, b, a);
        class_286.method_43433((class_9801)buffer.method_60800());
        RenderSystem.lineWidth((float)1.0f);
    }

    private void drawArc(class_332 drawContext, int centerX, int centerY, int radius, float startAngleDeg, float endAngleDeg, int color, float thickness) {
        Matrix4f matrix = drawContext.method_51448().method_23760().method_23761();
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        RenderSystem.setShader(class_757::method_34540);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.lineWidth((float)thickness);
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_60827(class_293.class_5596.field_29345, class_290.field_1576);
        int segments = (int)Math.abs(endAngleDeg - startAngleDeg);
        segments = Math.max(segments, 3);
        for (int i = 0; i <= segments; ++i) {
            float angle = startAngleDeg + (endAngleDeg - startAngleDeg) * (float)i / (float)segments;
            float angleRad = (float)Math.toRadians(angle);
            float x = (float)centerX + (float)(Math.sin(angleRad) * (double)radius);
            float y = (float)centerY - (float)(Math.cos(angleRad) * (double)radius);
            buffer.method_22918(matrix, x, y, 0.0f).method_22915(r, g, b, a);
        }
        class_286.method_43433((class_9801)buffer.method_60800());
        RenderSystem.lineWidth((float)1.0f);
    }
}

