/*
 * Decompiled with CFR 0.152.
 */
package net.rizen.submarines.api.client.input;

import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_8710;
import net.rizen.submarines.Mod;
import net.rizen.submarines.api.network.packet.DismountPacket;
import net.rizen.submarines.api.network.packet.MovementModeTogglePacket;
import net.rizen.submarines.api.network.packet.SonarPingPacket;
import net.rizen.submarines.api.network.packet.SubmarineInputPacket;
import net.rizen.submarines.api.network.packet.TargetingModeTogglePacket;
import net.rizen.submarines.api.network.packet.TorpedoFirePacket;
import net.rizen.submarines.api.submarine.BaseSubmarine;
import org.lwjgl.glfw.GLFW;

public class SubmarineInputHandler {
    private static class_304 dismountKey;
    private static class_304 sonarToggleKey;
    private static class_304 sonarPingKey;
    private static class_304 hudModeToggleKey;
    private static class_304 movementModeToggleKey;
    private static class_304 targetingModeToggleKey;
    private static boolean wasForward;
    private static boolean wasBackward;
    private static boolean wasLeft;
    private static boolean wasRight;
    private static boolean wasUp;
    private static boolean wasDown;
    private static boolean wasLeftMousePressed;
    private static boolean wasHudTogglePressed;
    private static boolean wasMovementTogglePressed;
    private static boolean wasTargetingTogglePressed;
    private static boolean wasSonarTogglePressed;
    private static boolean sonarEnabled;
    private static long lastSonarPingTime;
    private static final long SONAR_PING_COOLDOWN = 3000L;
    private static boolean submarineHudMode;

    public static void register() {
        dismountKey = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.submarines.dismount", class_3675.class_307.field_1668, 342, "category.submarines"));
        sonarToggleKey = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.submarines.sonar_toggle", class_3675.class_307.field_1668, 90, "category.submarines"));
        sonarPingKey = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.submarines.sonar_ping", class_3675.class_307.field_1668, 89, "category.submarines"));
        hudModeToggleKey = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.submarines.hud_toggle", class_3675.class_307.field_1668, 258, "category.submarines"));
        movementModeToggleKey = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.submarines.movement_mode_toggle", class_3675.class_307.field_1668, 86, "category.submarines"));
        targetingModeToggleKey = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.submarines.targeting_mode_toggle", class_3675.class_307.field_1668, 66, "category.submarines"));
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            class_1297 patt0$temp;
            if (client.field_1724 != null && client.field_1724.method_5765() && (patt0$temp = client.field_1724.method_5854()) instanceof BaseSubmarine) {
                BaseSubmarine submarine = (BaseSubmarine)patt0$temp;
                SubmarineInputHandler.handleSubmarineInput(client, submarine);
            } else {
                wasLeftMousePressed = false;
                wasHudTogglePressed = false;
                wasMovementTogglePressed = false;
                wasTargetingTogglePressed = false;
                wasSonarTogglePressed = false;
                submarineHudMode = true;
            }
        });
    }

    private static void handleSubmarineInput(class_310 client, BaseSubmarine submarine) {
        boolean inputChanged;
        long timeSinceLastPing;
        long currentTime = System.currentTimeMillis();
        boolean hudTogglePressed = hudModeToggleKey.method_1434();
        if (hudTogglePressed && !wasHudTogglePressed) {
            submarineHudMode = !submarineHudMode;
            client.field_1724.method_7353((class_2561)class_2561.method_43471((String)(submarineHudMode ? "submarines.hud.submarine_mode" : "submarines.hud.player_mode")), true);
        }
        wasHudTogglePressed = hudTogglePressed;
        if (dismountKey.method_1436()) {
            DismountPacket packet = new DismountPacket(submarine.method_5628());
            ClientPlayNetworking.send((class_8710)packet);
            return;
        }
        boolean sonarTogglePressed = sonarToggleKey.method_1434();
        if (sonarTogglePressed && !wasSonarTogglePressed && submarineHudMode) {
            sonarEnabled = !sonarEnabled;
            client.field_1724.method_7353((class_2561)class_2561.method_43471((String)(sonarEnabled ? "submarines.sonar.enabled" : "submarines.sonar.disabled")), true);
        }
        wasSonarTogglePressed = sonarTogglePressed;
        boolean movementTogglePressed = movementModeToggleKey.method_1434();
        if (movementTogglePressed && !wasMovementTogglePressed && submarineHudMode) {
            MovementModeTogglePacket packet = new MovementModeTogglePacket(submarine.method_5628());
            ClientPlayNetworking.send((class_8710)packet);
            client.field_1724.method_7353((class_2561)class_2561.method_43469((String)"submarines.movement_mode.changed", (Object[])new Object[]{submarine.getMovementMode().next().getDisplayName()}), true);
        }
        wasMovementTogglePressed = movementTogglePressed;
        boolean targetingTogglePressed = targetingModeToggleKey.method_1434();
        if (targetingTogglePressed && !wasTargetingTogglePressed && submarineHudMode) {
            TargetingModeTogglePacket packet = new TargetingModeTogglePacket(submarine.method_5628());
            ClientPlayNetworking.send((class_8710)packet);
            client.field_1724.method_7353((class_2561)class_2561.method_43469((String)"submarines.targeting_mode.changed", (Object[])new Object[]{submarine.getTargetingMode().next().getDisplayName()}), true);
        }
        wasTargetingTogglePressed = targetingTogglePressed;
        if (sonarPingKey.method_1436() && submarineHudMode && sonarEnabled && (timeSinceLastPing = currentTime - lastSonarPingTime) >= 3000L) {
            if (submarine.getPower() >= 2.0f) {
                submarine.performSonarPing();
                SonarPingPacket packet = new SonarPingPacket(submarine.method_5628());
                ClientPlayNetworking.send((class_8710)packet);
                client.field_1724.method_5783(Mod.SONAR_PING, 1.0f, 1.0f);
                lastSonarPingTime = currentTime;
            } else {
                client.field_1724.method_7353((class_2561)class_2561.method_43471((String)"submarines.sonar.insufficient_power"), true);
            }
        }
        if (!submarineHudMode) {
            return;
        }
        if (client.field_1755 == null) {
            boolean leftMousePressed;
            boolean bl = leftMousePressed = GLFW.glfwGetMouseButton((long)client.method_22683().method_4490(), (int)0) == 1;
            if (leftMousePressed && !wasLeftMousePressed) {
                TorpedoFirePacket packet = new TorpedoFirePacket(submarine.method_5628());
                ClientPlayNetworking.send((class_8710)packet);
            }
            wasLeftMousePressed = leftMousePressed;
        } else {
            wasLeftMousePressed = false;
        }
        boolean forward = client.field_1690.field_1894.method_1434();
        boolean backward = client.field_1690.field_1881.method_1434();
        boolean left = client.field_1690.field_1913.method_1434();
        boolean right = client.field_1690.field_1849.method_1434();
        boolean up = class_3675.method_15987((long)client.method_22683().method_4490(), (int)340);
        boolean down = class_3675.method_15987((long)client.method_22683().method_4490(), (int)341);
        boolean bl = inputChanged = forward != wasForward || backward != wasBackward || left != wasLeft || right != wasRight || up != wasUp || down != wasDown;
        if (inputChanged || client.field_1724.field_6012 % 5 == 0) {
            SubmarineInputPacket packet = new SubmarineInputPacket(submarine.method_5628(), forward, backward, left, right, up, down);
            ClientPlayNetworking.send((class_8710)packet);
            wasForward = forward;
            wasBackward = backward;
            wasLeft = left;
            wasRight = right;
            wasUp = up;
            wasDown = down;
        }
    }

    public static boolean isSonarEnabled() {
        return sonarEnabled;
    }

    public static boolean isSubmarineHudMode() {
        return submarineHudMode;
    }

    public static float getSonarCooldownProgress() {
        long currentTime = System.currentTimeMillis();
        long timeSinceLastPing = currentTime - lastSonarPingTime;
        if (timeSinceLastPing >= 3000L) {
            return 1.0f;
        }
        return (float)timeSinceLastPing / 3000.0f;
    }

    static {
        wasForward = false;
        wasBackward = false;
        wasLeft = false;
        wasRight = false;
        wasUp = false;
        wasDown = false;
        wasLeftMousePressed = false;
        wasHudTogglePressed = false;
        wasMovementTogglePressed = false;
        wasTargetingTogglePressed = false;
        wasSonarTogglePressed = false;
        sonarEnabled = false;
        lastSonarPingTime = 0L;
        submarineHudMode = true;
    }
}

