/*
 * Decompiled with CFR 0.152.
 */
package net.rizen.submarines.api.client.model;

import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.rizen.submarines.api.client.model.OBJLoader;
import net.rizen.submarines.api.client.model.OBJModelManager;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class OBJEntityModel {
    private final class_2960 modelId;
    private OBJLoader.OBJModel modelData;

    public OBJEntityModel(class_2960 modelId) {
        this.modelId = modelId;
        this.modelData = OBJModelManager.getOrLoadModel(modelId);
    }

    public void render(class_4587 matrices, class_4588 vertexConsumer, int light, int overlay, int color) {
        if (this.modelData == null) {
            this.modelData = OBJModelManager.getOrLoadModel(this.modelId);
            if (this.modelData == null) {
                return;
            }
        }
        Matrix4f positionMatrix = matrices.method_23760().method_23761();
        Matrix3f normalMatrix = matrices.method_23760().method_23762();
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        for (OBJLoader.OBJModel.Triangle tri : this.modelData.triangles) {
            for (int i = 0; i < 3; ++i) {
                this.renderVertex(tri, i, positionMatrix, normalMatrix, vertexConsumer, light, overlay, r, g, b, a);
            }
            this.renderVertex(tri, 2, positionMatrix, normalMatrix, vertexConsumer, light, overlay, r, g, b, a);
        }
    }

    private void renderVertex(OBJLoader.OBJModel.Triangle tri, int vertexCornerIndex, Matrix4f positionMatrix, Matrix3f normalMatrix, class_4588 vertexConsumer, int light, int overlay, float r, float g, float b, float a) {
        int vIndex = tri.vertexIndices[vertexCornerIndex];
        int tIndex = tri.texCoordIndices[vertexCornerIndex];
        int nIndex = tri.normalIndices[vertexCornerIndex];
        if (vIndex >= this.modelData.vertices.size()) {
            return;
        }
        Vector3f pos = this.modelData.vertices.get(vIndex);
        float u = 0.0f;
        float v = 0.0f;
        if (tIndex >= 0 && tIndex < this.modelData.texCoords.size()) {
            Vector2f tex = this.modelData.texCoords.get(tIndex);
            u = tex.x;
            v = tex.y;
        }
        float nx = 0.0f;
        float ny = 1.0f;
        float nz = 0.0f;
        if (nIndex >= 0 && nIndex < this.modelData.normals.size()) {
            Vector3f norm = this.modelData.normals.get(nIndex);
            Vector3f rotNorm = new Vector3f((Vector3fc)norm);
            rotNorm.mul((Matrix3fc)normalMatrix);
            if (rotNorm.lengthSquared() > 1.0E-6f) {
                rotNorm.normalize();
                nx = rotNorm.x;
                ny = rotNorm.y;
                nz = rotNorm.z;
            }
        }
        vertexConsumer.method_22918(positionMatrix, pos.x, pos.y, pos.z).method_22915(r, g, b, a).method_22913(u, v).method_22922(overlay).method_60803(light).method_22914(nx, ny, nz);
    }
}

