/*
 * Decompiled with CFR 0.152.
 */
package net.rizen.submarines.api.client.model;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2960;
import net.rizen.submarines.Mod;
import net.rizen.submarines.api.client.model.OBJLoader;
import org.slf4j.Logger;

public class OBJModelManager {
    private static final Logger LOGGER = Mod.LOGGER;
    private static final Map<class_2960, OBJLoader.OBJModel> CACHE = new HashMap<class_2960, OBJLoader.OBJModel>();

    public static OBJLoader.OBJModel getOrLoadModel(class_2960 id) {
        if (CACHE.containsKey(id)) {
            return CACHE.get(id);
        }
        try {
            String path = "/assets/" + id.method_12836() + "/models/" + id.method_12832();
            InputStream stream = OBJModelManager.class.getResourceAsStream(path);
            if (stream == null) {
                LOGGER.error("Could not find model at path: {}", (Object)path);
                return null;
            }
            OBJLoader.OBJModel model = OBJLoader.loadModel(stream);
            CACHE.put(id, model);
            return model;
        }
        catch (IOException e) {
            LOGGER.error("Failed to load model {}: {}", (Object)id, (Object)e.getMessage());
            return null;
        }
        catch (Exception e) {
            LOGGER.error("An unexpected error occurred while loading model {}: {}", (Object)id, (Object)e);
            return null;
        }
    }
}

