/*
 * Decompiled with CFR 0.152.
 */
package net.rizen.submarines.api.crafting;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2960;

public class ManufacturingRecipe {
    public static final String CATEGORY_SUBMARINES = "submarines";
    public static final String CATEGORY_WEAPONS = "weapons";
    public static final String CATEGORY_COMPONENTS = "components";
    private final class_2960 id;
    private final List<Ingredient> ingredients;
    private final class_1799 result;
    private final String category;
    private final String displayName;

    private ManufacturingRecipe(class_2960 id, List<Ingredient> ingredients, class_1799 result, String category, String displayName) {
        this.id = id;
        this.ingredients = ingredients;
        this.result = result;
        this.category = category;
        this.displayName = displayName;
    }

    public class_2960 getId() {
        return this.id;
    }

    public List<Ingredient> getIngredients() {
        return this.ingredients;
    }

    public class_1799 getResult() {
        return this.result;
    }

    public String getCategory() {
        return this.category;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public static Builder builder(class_2960 id) {
        return new Builder(id);
    }

    public static class Builder {
        private final class_2960 id;
        private final List<Ingredient> ingredients = new ArrayList<Ingredient>();
        private class_1799 result;
        private String category = "general";
        private String displayName;

        private Builder(class_2960 id) {
            this.id = id;
        }

        public Builder ingredient(class_1792 item, int count) {
            this.ingredients.add(new Ingredient(item, count));
            return this;
        }

        public Builder result(class_1792 item) {
            this.result = new class_1799((class_1935)item);
            return this;
        }

        public Builder result(class_1799 stack) {
            this.result = stack;
            return this;
        }

        public Builder category(String category) {
            if (!(category.equals(ManufacturingRecipe.CATEGORY_SUBMARINES) || category.equals(ManufacturingRecipe.CATEGORY_WEAPONS) || category.equals(ManufacturingRecipe.CATEGORY_COMPONENTS))) {
                throw new IllegalArgumentException("Invalid category: " + category + ". Must be one of: CATEGORY_SUBMARINES, CATEGORY_WEAPONS, CATEGORY_COMPONENTS");
            }
            this.category = category;
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public ManufacturingRecipe build() {
            if (this.result == null || this.result.method_7960()) {
                throw new IllegalStateException("Recipe " + String.valueOf(this.id) + " must have a result");
            }
            if (this.ingredients.isEmpty()) {
                throw new IllegalStateException("Recipe " + String.valueOf(this.id) + " must have at least one ingredient");
            }
            if (this.displayName == null || this.displayName.isEmpty()) {
                this.displayName = this.result.method_7964().getString();
            }
            return new ManufacturingRecipe(this.id, new ArrayList<Ingredient>(this.ingredients), this.result.method_7972(), this.category, this.displayName);
        }
    }

    public static class Ingredient {
        private final class_1792 item;
        private final int count;

        public Ingredient(class_1792 item, int count) {
            this.item = item;
            this.count = count;
        }

        public class_1792 getItem() {
            return this.item;
        }

        public int getCount() {
            return this.count;
        }
    }
}

