/*
 * Decompiled with CFR 0.152.
 */
package net.rizen.submarines.api.crafting;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.rizen.submarines.Mod;
import net.rizen.submarines.api.crafting.ManufacturingRecipe;
import org.slf4j.Logger;

public class ManufacturingRecipeRegistry {
    private static final Logger LOGGER = Mod.LOGGER;
    private static final Map<class_2960, ManufacturingRecipe> RECIPES = new HashMap<class_2960, ManufacturingRecipe>();

    public static void register(ManufacturingRecipe recipe) {
        if (RECIPES.containsKey(recipe.getId())) {
            LOGGER.warn("Replacing existing recipe with ID: {}", (Object)recipe.getId());
        }
        RECIPES.put(recipe.getId(), recipe);
        LOGGER.info("Registered manufacturing recipe: {}", (Object)recipe.getId());
    }

    public static ManufacturingRecipe getRecipe(class_2960 id) {
        return RECIPES.get(id);
    }

    public static List<ManufacturingRecipe> getRecipesByCategory(String category) {
        ArrayList<ManufacturingRecipe> result = new ArrayList<ManufacturingRecipe>();
        for (ManufacturingRecipe recipe : RECIPES.values()) {
            if (!recipe.getCategory().equals(category)) continue;
            result.add(recipe);
        }
        return result;
    }

    public static boolean hasIngredients(class_1661 inventory, ManufacturingRecipe recipe) {
        for (ManufacturingRecipe.Ingredient ingredient : recipe.getIngredients()) {
            if (ManufacturingRecipeRegistry.hasItems(inventory, ingredient.getItem(), ingredient.getCount())) continue;
            return false;
        }
        return true;
    }

    public static void consumeIngredients(class_1661 inventory, ManufacturingRecipe recipe) {
        for (ManufacturingRecipe.Ingredient ingredient : recipe.getIngredients()) {
            ManufacturingRecipeRegistry.consumeItems(inventory, ingredient.getItem(), ingredient.getCount());
        }
    }

    public static class_1799 tryCraft(class_1661 inventory, ManufacturingRecipe recipe) {
        if (!ManufacturingRecipeRegistry.hasIngredients(inventory, recipe)) {
            return class_1799.field_8037;
        }
        ManufacturingRecipeRegistry.consumeIngredients(inventory, recipe);
        return recipe.getResult().method_7972();
    }

    private static boolean hasItems(class_1661 inventory, class_1792 item, int amount) {
        int count = 0;
        for (int i = 0; i < inventory.method_5439(); ++i) {
            class_1799 stack = inventory.method_5438(i);
            if (stack.method_7909() != item || (count += stack.method_7947()) < amount) continue;
            return true;
        }
        return false;
    }

    private static void consumeItems(class_1661 inventory, class_1792 item, int amount) {
        int remaining = amount;
        for (int i = 0; i < inventory.method_5439() && remaining > 0; ++i) {
            class_1799 stack = inventory.method_5438(i);
            if (stack.method_7909() != item) continue;
            int toRemove = Math.min(remaining, stack.method_7947());
            stack.method_7934(toRemove);
            remaining -= toRemove;
        }
    }
}

