/*
 * Decompiled with CFR 0.152.
 */
package net.rizen.submarines.api.submarine;

import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3419;
import net.minecraft.class_3908;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_7225;
import net.minecraft.class_8111;
import net.rizen.submarines.Mod;
import net.rizen.submarines.api.submarine.MovementMode;
import net.rizen.submarines.api.submarine.SubmarineControls;
import net.rizen.submarines.api.submarine.SubmarineInventory;
import net.rizen.submarines.api.submarine.SubmarineMovement;
import net.rizen.submarines.api.submarine.SubmarinePhysics;
import net.rizen.submarines.api.submarine.SubmarinePower;
import net.rizen.submarines.api.submarine.SubmarineScreenHandler;
import net.rizen.submarines.api.submarine.SubmarineWeaponSystem;
import net.rizen.submarines.api.submarine.TorpedoSpawner;
import net.rizen.submarines.api.submarine.sonar.SonarSystem;
import net.rizen.submarines.api.torpedo.BaseTorpedo;
import net.rizen.submarines.api.torpedo.TargetingMode;
import net.rizen.submarines.item.SubmarineRepairToolItem;

public abstract class BaseSubmarine
extends class_1297
implements class_3908 {
    protected static final class_2940<Float> HEALTH = class_2945.method_12791(BaseSubmarine.class, (class_2941)class_2943.field_13320);
    protected static final class_2940<Float> SPEED = class_2945.method_12791(BaseSubmarine.class, (class_2941)class_2943.field_13320);
    protected static final class_2940<Integer> TORPEDO_COUNT = class_2945.method_12791(BaseSubmarine.class, (class_2941)class_2943.field_13327);
    protected static final class_2940<Integer> TORPEDO_ARMING_TIMER = class_2945.method_12791(BaseSubmarine.class, (class_2941)class_2943.field_13327);
    protected static final class_2940<Float> POWER = class_2945.method_12791(BaseSubmarine.class, (class_2941)class_2943.field_13320);
    protected static final class_2940<Integer> MOVEMENT_MODE = class_2945.method_12791(BaseSubmarine.class, (class_2941)class_2943.field_13327);
    protected static final class_2940<Integer> TARGETING_MODE = class_2945.method_12791(BaseSubmarine.class, (class_2941)class_2943.field_13327);
    protected final SubmarineControls controls = new SubmarineControls();
    protected final SubmarineMovement movement;
    protected final SubmarinePhysics physics;
    protected final SubmarinePower power;
    protected final SubmarineWeaponSystem weaponSystem;
    protected final SubmarineInventory inventory;
    protected final SonarSystem sonarSystem;
    protected float width;
    protected float height;
    protected float length;
    private final TorpedoSpawner torpedoSpawner;
    private final float torpedoFireCost;
    private final class_243 torpedoSpawnOffset;
    private boolean wasMoving = false;
    private boolean wasLowPower = false;

    public BaseSubmarine(class_1299<? extends BaseSubmarine> entityType, class_1937 world, float maxSpeed, float acceleration, float deceleration, float rotationSpeed, float rotationAcceleration, float rotationDeceleration, float verticalSpeedMult, float backwardSpeedMult, float maxPower, float movementConsumption, int torpedoCooldown, int torpedoArming, TorpedoSpawner torpedoSpawner, float torpedoFireCost, class_243 torpedoSpawnOffset, float width, float height, float length) {
        super(entityType, world);
        this.movement = new SubmarineMovement(maxSpeed, acceleration, deceleration, rotationSpeed, rotationAcceleration, rotationDeceleration, verticalSpeedMult, backwardSpeedMult);
        this.physics = new SubmarinePhysics();
        this.power = new SubmarinePower(maxPower, movementConsumption);
        this.weaponSystem = new SubmarineWeaponSystem(torpedoCooldown, torpedoArming);
        this.inventory = new SubmarineInventory();
        this.sonarSystem = new SonarSystem();
        this.torpedoSpawner = torpedoSpawner;
        this.torpedoFireCost = torpedoFireCost;
        this.torpedoSpawnOffset = torpedoSpawnOffset;
        this.width = width;
        this.height = height;
        this.length = length;
    }

    protected void method_5693(class_2945.class_9222 builder) {
        builder.method_56912(HEALTH, (Object)Float.valueOf(100.0f));
        builder.method_56912(SPEED, (Object)Float.valueOf(0.0f));
        builder.method_56912(TORPEDO_COUNT, (Object)0);
        builder.method_56912(TORPEDO_ARMING_TIMER, (Object)0);
        builder.method_56912(POWER, (Object)Float.valueOf(100.0f));
        builder.method_56912(MOVEMENT_MODE, (Object)MovementMode.SILENT.ordinal());
        builder.method_56912(TARGETING_MODE, (Object)TargetingMode.ALL.ordinal());
    }

    public class_4048 method_18377(class_4050 pose) {
        return class_4048.method_18384((float)this.width, (float)this.height);
    }

    protected class_238 method_33332() {
        float maxDimension = Math.max(this.width, this.length);
        float halfSize = maxDimension / 2.0f;
        return new class_238(this.method_23317() - (double)halfSize, this.method_23318(), this.method_23321() - (double)halfSize, this.method_23317() + (double)halfSize, this.method_23318() + (double)this.height, this.method_23321() + (double)halfSize);
    }

    public boolean method_5740() {
        return true;
    }

    public void method_5773() {
        super.method_5773();
        if (!this.method_37908().field_9236) {
            if (this.power.hasPower() && this.isInWaterBlock()) {
                float currentMaxSpeed = this.getMovementMode().getMaxSpeed();
                this.movement.update(this.controls, this, currentMaxSpeed);
            } else {
                this.movement.stop();
                this.field_6011.method_12778(SPEED, (Object)Float.valueOf(0.0f));
            }
            this.updatePosition();
            float powerMultiplier = this.getMovementMode().getPowerMultiplier();
            this.power.consumePower(this.controls.isMoving(), powerMultiplier);
            this.power.tryConsumeFuel(this.inventory);
            this.weaponSystem.tick();
            this.weaponSystem.updateTorpedoCount(this.inventory);
            this.sonarSystem.tick();
            this.field_6011.method_12778(TORPEDO_COUNT, (Object)this.weaponSystem.countTorpedoes(this.inventory));
            this.field_6011.method_12778(TORPEDO_ARMING_TIMER, (Object)this.weaponSystem.getTorpedoArmingTimer());
            this.field_6011.method_12778(POWER, (Object)Float.valueOf(this.power.getCurrentPower()));
            this.field_6011.method_12778(SPEED, (Object)Float.valueOf(this.movement.getSignedSpeed()));
            this.breakLilyPads();
            this.handleLowPowerWarning();
        }
        this.handleMotorSound();
    }

    private void handleMotorSound() {
        float pitch;
        float volume;
        boolean isMoving;
        boolean bl = isMoving = this.controls.isMoving() && this.power.hasPower() && this.isInWaterBlock();
        if (isMoving && !this.wasMoving) {
            volume = this.getMotorVolume();
            pitch = this.getMotorPitch();
            this.method_37908().method_43128(null, this.method_23317(), this.method_23318(), this.method_23321(), Mod.SUBMARINE_MOTOR, class_3419.field_15254, volume, pitch);
        }
        if (isMoving && this.field_6012 % 20 == 0) {
            volume = this.getMotorVolume();
            pitch = this.getMotorPitch();
            this.method_37908().method_43128(null, this.method_23317(), this.method_23318(), this.method_23321(), Mod.SUBMARINE_MOTOR, class_3419.field_15254, volume, pitch);
        }
        this.wasMoving = isMoving;
    }

    private float getMotorVolume() {
        return switch (this.getMovementMode()) {
            default -> throw new MatchException(null, null);
            case MovementMode.SILENT -> 0.3f;
            case MovementMode.CRUISE -> 0.6f;
            case MovementMode.FLANK -> 1.0f;
        };
    }

    private float getMotorPitch() {
        return switch (this.getMovementMode()) {
            default -> throw new MatchException(null, null);
            case MovementMode.SILENT -> 0.8f;
            case MovementMode.CRUISE -> 1.0f;
            case MovementMode.FLANK -> 1.2f;
        };
    }

    private void handleLowPowerWarning() {
        float maxPower;
        boolean isLowPower;
        float currentPower = this.power.getCurrentPower();
        boolean bl = isLowPower = currentPower / (maxPower = this.power.getMaxPower()) < 0.1f;
        if (isLowPower && !this.wasLowPower) {
            this.method_37908().method_43128(null, this.method_23317(), this.method_23318(), this.method_23321(), Mod.SUBMARINE_LOW_POWER, class_3419.field_15254, 2.0f, 1.0f);
        }
        this.wasLowPower = isLowPower;
    }

    private void breakLilyPads() {
        class_238 boundingBox = this.method_5829();
        class_2338 minPos = new class_2338((int)Math.floor(boundingBox.field_1323), (int)Math.floor(boundingBox.field_1322), (int)Math.floor(boundingBox.field_1321));
        class_2338 maxPos = new class_2338((int)Math.ceil(boundingBox.field_1320), (int)Math.ceil(boundingBox.field_1325), (int)Math.ceil(boundingBox.field_1324));
        for (class_2338 pos : class_2338.method_10097((class_2338)minPos, (class_2338)maxPos)) {
            class_2680 state = this.method_37908().method_8320(pos);
            if (!state.method_27852(class_2246.field_10588)) continue;
            this.method_37908().method_22352(pos, true);
        }
    }

    protected void updatePosition() {
        class_243 movement = this.movement.calculateMovement(this.method_36454());
        movement = this.physics.applyWaterPhysics(this, movement);
        movement = this.physics.constrainToWaterSurface(this.method_37908(), this, movement);
        this.method_5784(class_1313.field_6308, movement);
        this.method_36457(0.0f);
    }

    public void updateInput(boolean forward, boolean backward, boolean left, boolean right, boolean up, boolean down) {
        if (!this.power.hasPower() || !this.isInWaterBlock()) {
            this.controls.reset();
            return;
        }
        this.controls.updateInput(forward, backward, left, right, up, down);
    }

    protected boolean canFireTorpedo() {
        if (!this.isInWaterBlock()) {
            return false;
        }
        return this.weaponSystem.canFire();
    }

    public boolean fireTorpedo() {
        if (!this.method_37908().field_9236 && this.canFireTorpedo()) {
            if (!this.power.hasPower() || !this.power.consumePowerAmount(this.torpedoFireCost)) {
                this.playUnableToFireSound();
                return false;
            }
            boolean torpedoFound = this.weaponSystem.findAndConsumeTorpedo(this.inventory);
            if (torpedoFound) {
                float yawRad = (float)Math.toRadians(this.method_36454());
                double spawnX = this.method_23317() - Math.sin(yawRad) * this.torpedoSpawnOffset.field_1352;
                double spawnY = this.method_23318() + this.torpedoSpawnOffset.field_1351;
                double spawnZ = this.method_23321() + Math.cos(yawRad) * this.torpedoSpawnOffset.field_1350;
                BaseTorpedo torpedo = this.torpedoSpawner.create(this.method_37908(), spawnX, spawnY, spawnZ, this.method_36454(), 0.0f);
                torpedo.setOwnerSubmarine(this);
                torpedo.setTargetingMode(this.getTargetingMode());
                this.method_37908().method_8649((class_1297)torpedo);
                this.weaponSystem.setFired();
                this.weaponSystem.updateTorpedoCount(this.inventory);
                this.method_37908().method_43128(null, this.method_23317(), this.method_23318(), this.method_23321(), Mod.TORPEDO_FIRE, class_3419.field_15254, 1.0f, 1.0f);
                return true;
            }
            this.power.setCurrentPower(this.power.getCurrentPower() + this.torpedoFireCost);
            this.playUnableToFireSound();
            return false;
        }
        if (!this.method_37908().field_9236 && !this.canFireTorpedo()) {
            this.playUnableToFireSound();
        }
        return false;
    }

    private void playUnableToFireSound() {
        this.method_37908().method_43128(null, this.method_23317(), this.method_23318(), this.method_23321(), Mod.TORPEDO_UNABLE_TO_FIRE, class_3419.field_15254, 1.0f, 1.0f);
    }

    public class_1269 method_5688(class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        if (stack.method_7909() instanceof SubmarineRepairToolItem) {
            if (!this.method_37908().field_9236) {
                float currentHealth = this.getHealth();
                if (currentHealth >= 100.0f) {
                    return class_1269.field_5811;
                }
                float newHealth = Math.min(100.0f, currentHealth + 10.0f);
                this.setHealth(newHealth);
                stack.method_7970(20, (class_1309)player, class_1657.method_56079((class_1268)hand));
                this.method_37908().method_43128(null, this.method_23317(), this.method_23318(), this.method_23321(), Mod.SUBMARINE_REPAIRED, class_3419.field_15248, 1.0f, 1.0f);
            }
            return class_1269.field_5812;
        }
        if (!this.method_37908().field_9236) {
            if (this.method_5685().isEmpty()) {
                player.method_5804((class_1297)this);
                return class_1269.field_5812;
            }
            if (this.method_5685().contains(player)) {
                player.method_17355((class_3908)this);
                return class_1269.field_5812;
            }
            return class_1269.field_5811;
        }
        return class_1269.field_5812;
    }

    protected void method_5627(class_1297 passenger) {
        super.method_5627(passenger);
        if (passenger instanceof class_1657) {
            class_1657 player = (class_1657)passenger;
            player.method_5684(true);
        }
    }

    protected void method_5793(class_1297 passenger) {
        super.method_5793(passenger);
        if (passenger instanceof class_1657) {
            class_1657 player = (class_1657)passenger;
            player.method_5684(false);
            this.controls.reset();
        }
    }

    public float getHealth() {
        return ((Float)this.field_6011.method_12789(HEALTH)).floatValue();
    }

    public void setHealth(float health) {
        this.field_6011.method_12778(HEALTH, (Object)Float.valueOf(Math.max(0.0f, Math.min(100.0f, health))));
    }

    public float getSpeed() {
        return ((Float)this.field_6011.method_12789(SPEED)).floatValue();
    }

    public int getDepth() {
        return this.physics.calculateDepth(this.method_37908(), this);
    }

    public int getTorpedoCount() {
        return (Integer)this.field_6011.method_12789(TORPEDO_COUNT);
    }

    public int getTorpedoCooldown() {
        return this.weaponSystem.getTorpedoCooldown();
    }

    public int getTorpedoArmingTimer() {
        return (Integer)this.field_6011.method_12789(TORPEDO_ARMING_TIMER);
    }

    public boolean isTorpedoArmed() {
        return this.weaponSystem.isArmed() && this.getTorpedoCount() > 0;
    }

    public float getPower() {
        return ((Float)this.field_6011.method_12789(POWER)).floatValue();
    }

    public boolean hasPower() {
        return this.power.hasPower();
    }

    public boolean isInWaterBlock() {
        return this.physics.isInWater(this);
    }

    public SubmarineInventory getInventory() {
        return this.inventory;
    }

    protected void method_5749(class_2487 nbt) {
        this.field_6011.method_12778(HEALTH, (Object)Float.valueOf(nbt.method_10583("Health")));
        this.field_6011.method_12778(POWER, (Object)Float.valueOf(nbt.method_10583("Power")));
        this.movement.setCurrentForwardSpeed(nbt.method_10583("ForwardSpeed"));
        this.movement.setCurrentVerticalSpeed(nbt.method_10583("VerticalSpeed"));
        this.movement.setCurrentRotationSpeed(nbt.method_10583("RotationSpeed"));
        this.weaponSystem.setTorpedoCooldown(nbt.method_10550("TorpedoCooldown"));
        this.weaponSystem.setPreviousTorpedoCount(nbt.method_10550("PreviousTorpedoCount"));
        this.field_6011.method_12778(MOVEMENT_MODE, (Object)nbt.method_10550("MovementMode"));
        if (nbt.method_10545("TargetingMode")) {
            this.field_6011.method_12778(TARGETING_MODE, (Object)nbt.method_10550("TargetingMode"));
        }
        if (nbt.method_10545("Inventory")) {
            this.inventory.readNbt(nbt.method_10562("Inventory"), (class_7225.class_7874)this.method_56673());
        }
    }

    protected void method_5652(class_2487 nbt) {
        nbt.method_10548("Health", this.getHealth());
        nbt.method_10548("Power", this.getPower());
        nbt.method_10548("ForwardSpeed", this.movement.getCurrentForwardSpeed());
        nbt.method_10548("VerticalSpeed", this.movement.getCurrentVerticalSpeed());
        nbt.method_10548("RotationSpeed", this.movement.getCurrentRotationSpeed());
        nbt.method_10569("TorpedoCooldown", this.weaponSystem.getTorpedoCooldown());
        nbt.method_10569("PreviousTorpedoCount", this.weaponSystem.getPreviousTorpedoCount());
        nbt.method_10569("MovementMode", this.getMovementMode().ordinal());
        nbt.method_10569("TargetingMode", this.getTargetingMode().ordinal());
        class_2487 inventoryNbt = new class_2487();
        this.inventory.writeNbt(inventoryNbt, (class_7225.class_7874)this.method_56673());
        nbt.method_10566("Inventory", (class_2520)inventoryNbt);
    }

    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        return new SubmarineScreenHandler(syncId, playerInventory, this.inventory);
    }

    public boolean method_5643(class_1282 source, float amount) {
        if (this.method_31481() || this.method_37908().field_9236) {
            return false;
        }
        if (!source.method_49708(class_8111.field_42331) && !source.method_49708(class_8111.field_42332)) {
            return false;
        }
        float currentHealth = this.getHealth();
        float newHealth = currentHealth - amount;
        this.setHealth(newHealth);
        if (newHealth <= 0.0f) {
            this.destroy();
        }
        return true;
    }

    public void destroy() {
        if (!this.method_37908().field_9236) {
            this.method_5772();
            this.method_37908().method_8437((class_1297)this, this.method_23317(), this.method_23318(), this.method_23321(), 4.0f, class_1937.class_7867.field_40890);
            this.method_31472();
        }
    }

    public boolean method_5863() {
        return !this.method_31481();
    }

    public boolean method_30948() {
        return true;
    }

    public boolean method_5810() {
        return false;
    }

    protected boolean method_5818(class_1297 passenger) {
        return this.method_5685().size() < 1;
    }

    public void performSonarPing() {
        if (!this.method_37908().field_9236 && !this.power.consumePowerAmount(2.0f)) {
            return;
        }
        this.sonarSystem.performPing(this.method_37908(), this.method_19538(), this.method_36454(), this);
        if (!this.method_37908().field_9236) {
            this.method_37908().method_43128(null, this.method_23317(), this.method_23318(), this.method_23321(), Mod.SONAR_PING, class_3419.field_15254, 1.0f, 1.0f);
        }
    }

    public SonarSystem getSonarSystem() {
        return this.sonarSystem;
    }

    public MovementMode getMovementMode() {
        int ordinal = (Integer)this.field_6011.method_12789(MOVEMENT_MODE);
        return MovementMode.values()[ordinal];
    }

    public void setMovementMode(MovementMode mode) {
        this.field_6011.method_12778(MOVEMENT_MODE, (Object)mode.ordinal());
    }

    public void cycleMovementMode() {
        this.setMovementMode(this.getMovementMode().next());
    }

    public TargetingMode getTargetingMode() {
        int ordinal = (Integer)this.field_6011.method_12789(TARGETING_MODE);
        return TargetingMode.values()[ordinal];
    }

    public void setTargetingMode(TargetingMode mode) {
        this.field_6011.method_12778(TARGETING_MODE, (Object)mode.ordinal());
    }

    public void cycleTargetingMode() {
        this.setTargetingMode(this.getTargetingMode().next());
    }

    public abstract class_243 method_52538(class_1297 var1);

    public abstract class_2561 method_5476();
}

