/*
 * Decompiled with CFR 0.152.
 */
package net.rizen.submarines.api.submarine;

public enum MovementMode {
    SILENT(0.15f, 1.0f),
    CRUISE(0.3f, 1.5f),
    FLANK(0.45f, 2.5f);

    private final float maxSpeed;
    private final float powerMultiplier;

    private MovementMode(float maxSpeed, float powerMultiplier) {
        this.maxSpeed = maxSpeed;
        this.powerMultiplier = powerMultiplier;
    }

    public float getMaxSpeed() {
        return this.maxSpeed;
    }

    public float getPowerMultiplier() {
        return this.powerMultiplier;
    }

    public MovementMode next() {
        int nextOrdinal = (this.ordinal() + 1) % MovementMode.values().length;
        return MovementMode.values()[nextOrdinal];
    }

    public String getDisplayName() {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> "Silent";
            case 1 -> "Cruise";
            case 2 -> "Flank";
        };
    }
}

