/*
 * Decompiled with CFR 0.152.
 */
package net.rizen.submarines.api.submarine;

import net.minecraft.class_1297;
import net.minecraft.class_243;
import net.rizen.submarines.api.submarine.SubmarineControls;

public class SubmarineMovement {
    private final float maxSpeed;
    private final float acceleration;
    private final float deceleration;
    private final float rotationSpeed;
    private final float rotationAcceleration;
    private final float rotationDeceleration;
    private final float verticalSpeedMultiplier;
    private final float backwardSpeedMultiplier;
    private float currentForwardSpeed = 0.0f;
    private float currentVerticalSpeed = 0.0f;
    private float currentRotationSpeed = 0.0f;

    public SubmarineMovement(float maxSpeed, float acceleration, float deceleration, float rotationSpeed, float rotationAcceleration, float rotationDeceleration, float verticalSpeedMultiplier, float backwardSpeedMultiplier) {
        this.maxSpeed = maxSpeed;
        this.acceleration = acceleration;
        this.deceleration = deceleration;
        this.rotationSpeed = rotationSpeed;
        this.rotationAcceleration = rotationAcceleration;
        this.rotationDeceleration = rotationDeceleration;
        this.verticalSpeedMultiplier = verticalSpeedMultiplier;
        this.backwardSpeedMultiplier = backwardSpeedMultiplier;
    }

    public void update(SubmarineControls controls, class_1297 entity, float currentMaxSpeed) {
        float targetForwardSpeed = 0.0f;
        if (controls.isMoveForward()) {
            targetForwardSpeed += currentMaxSpeed;
        }
        if (controls.isMoveBackward()) {
            targetForwardSpeed -= currentMaxSpeed * this.backwardSpeedMultiplier;
        }
        this.currentForwardSpeed = Math.abs(targetForwardSpeed - this.currentForwardSpeed) > this.acceleration ? (this.currentForwardSpeed < targetForwardSpeed ? (this.currentForwardSpeed += this.acceleration) : (this.currentForwardSpeed -= this.acceleration)) : targetForwardSpeed;
        if (!controls.isMoveForward() && !controls.isMoveBackward() && Math.abs(this.currentForwardSpeed) > 0.0f) {
            this.currentForwardSpeed = this.currentForwardSpeed > 0.0f ? Math.max(0.0f, this.currentForwardSpeed - this.deceleration) : Math.min(0.0f, this.currentForwardSpeed + this.deceleration);
        }
        float targetRotationSpeed = 0.0f;
        if (controls.isRotateLeft()) {
            targetRotationSpeed -= this.rotationSpeed;
        }
        if (controls.isRotateRight()) {
            targetRotationSpeed += this.rotationSpeed;
        }
        this.currentRotationSpeed = Math.abs(targetRotationSpeed - this.currentRotationSpeed) > this.rotationAcceleration ? (this.currentRotationSpeed < targetRotationSpeed ? (this.currentRotationSpeed += this.rotationAcceleration) : (this.currentRotationSpeed -= this.rotationAcceleration)) : targetRotationSpeed;
        if (!controls.isRotateLeft() && !controls.isRotateRight() && Math.abs(this.currentRotationSpeed) > 0.0f) {
            this.currentRotationSpeed = this.currentRotationSpeed > 0.0f ? Math.max(0.0f, this.currentRotationSpeed - this.rotationDeceleration) : Math.min(0.0f, this.currentRotationSpeed + this.rotationDeceleration);
        }
        entity.method_36456(entity.method_36454() + this.currentRotationSpeed);
        float targetVerticalSpeed = 0.0f;
        if (controls.isMoveUp()) {
            targetVerticalSpeed += currentMaxSpeed * this.verticalSpeedMultiplier;
        }
        if (controls.isMoveDown()) {
            targetVerticalSpeed -= currentMaxSpeed * this.verticalSpeedMultiplier;
        }
        this.currentVerticalSpeed = Math.abs(targetVerticalSpeed - this.currentVerticalSpeed) > this.acceleration ? (this.currentVerticalSpeed < targetVerticalSpeed ? (this.currentVerticalSpeed += this.acceleration) : (this.currentVerticalSpeed -= this.acceleration)) : targetVerticalSpeed;
        if (!controls.isMoveUp() && !controls.isMoveDown() && Math.abs(this.currentVerticalSpeed) > 0.0f) {
            this.currentVerticalSpeed = this.currentVerticalSpeed > 0.0f ? Math.max(0.0f, this.currentVerticalSpeed - this.deceleration) : Math.min(0.0f, this.currentVerticalSpeed + this.deceleration);
        }
    }

    public class_243 calculateMovement(float yaw) {
        float yawRad = (float)Math.toRadians(yaw);
        class_243 forward = new class_243(-Math.sin(yawRad), 0.0, Math.cos(yawRad));
        class_243 up = new class_243(0.0, 1.0, 0.0);
        return forward.method_1021((double)this.currentForwardSpeed).method_1019(up.method_1021((double)this.currentVerticalSpeed));
    }

    public float getSignedSpeed() {
        float magnitude = (float)Math.sqrt(this.currentForwardSpeed * this.currentForwardSpeed + this.currentVerticalSpeed * this.currentVerticalSpeed);
        return this.currentForwardSpeed < 0.0f ? -magnitude : magnitude;
    }

    public void stop() {
        this.currentForwardSpeed = 0.0f;
        this.currentVerticalSpeed = 0.0f;
        this.currentRotationSpeed = 0.0f;
    }

    public float getCurrentForwardSpeed() {
        return this.currentForwardSpeed;
    }

    public float getCurrentVerticalSpeed() {
        return this.currentVerticalSpeed;
    }

    public void setCurrentForwardSpeed(float speed) {
        this.currentForwardSpeed = speed;
    }

    public void setCurrentVerticalSpeed(float speed) {
        this.currentVerticalSpeed = speed;
    }

    public float getCurrentRotationSpeed() {
        return this.currentRotationSpeed;
    }

    public void setCurrentRotationSpeed(float speed) {
        this.currentRotationSpeed = speed;
    }
}

