/*
 * Decompiled with CFR 0.152.
 */
package net.rizen.submarines.api.submarine;

import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_3489;
import net.rizen.submarines.api.item.TorpedoItem;

public class SubmarinePower {
    private final float maxPower;
    private final float movementConsumption;
    private float currentPower;

    public SubmarinePower(float maxPower, float movementConsumption) {
        this.maxPower = maxPower;
        this.movementConsumption = movementConsumption;
        this.currentPower = maxPower;
    }

    public void consumePower(boolean isActive, float powerMultiplier) {
        if (isActive) {
            this.currentPower = Math.max(0.0f, this.currentPower - this.movementConsumption * powerMultiplier);
        }
    }

    public boolean tryConsumeFuel(class_1263 inventory) {
        if (this.currentPower >= this.maxPower) {
            return false;
        }
        for (int i = 0; i < inventory.method_5439(); ++i) {
            boolean shouldUseFuel;
            float fuelValue;
            class_1799 stack = inventory.method_5438(i);
            if (stack.method_7960() || stack.method_7909() instanceof TorpedoItem || !((fuelValue = this.getFuelPowerValue(stack)) > 0.0f)) continue;
            float powerNeeded = this.maxPower - this.currentPower;
            float wastedPower = fuelValue - powerNeeded;
            boolean bl = shouldUseFuel = wastedPower <= 0.0f || this.currentPower <= this.getUsageThreshold(stack);
            if (!shouldUseFuel) continue;
            this.currentPower = Math.min(this.maxPower, this.currentPower + fuelValue);
            boolean isLavaBucket = stack.method_7909() == class_1802.field_8187;
            stack.method_7934(1);
            if (isLavaBucket) {
                if (stack.method_7960()) {
                    inventory.method_5447(i, new class_1799((class_1935)class_1802.field_8550));
                } else {
                    this.addItemToInventory(inventory, new class_1799((class_1935)class_1802.field_8550));
                }
            }
            inventory.method_5431();
            return true;
        }
        return false;
    }

    private float getFuelPowerValue(class_1799 stack) {
        if (stack.method_7909() == class_1802.field_8187) {
            return 50.0f;
        }
        if (stack.method_7909() == class_1802.field_8797) {
            return 30.0f;
        }
        if (stack.method_7909() == class_1802.field_17533) {
            return 10.0f;
        }
        if (stack.method_7909() == class_1802.field_8894) {
            return 5.0f;
        }
        if (stack.method_7909() == class_1802.field_8713) {
            return 3.0f;
        }
        if (stack.method_7909() == class_1802.field_8665) {
            return 3.0f;
        }
        if (stack.method_31573(class_3489.field_15539)) {
            return 1.5f;
        }
        if (stack.method_31573(class_3489.field_15537)) {
            return 1.0f;
        }
        if (stack.method_7909() == class_1802.field_8600) {
            return 0.5f;
        }
        if (stack.method_7909() == class_1802.field_8648) {
            return 1.0f;
        }
        return 0.0f;
    }

    private float getUsageThreshold(class_1799 stack) {
        if (stack.method_7909() == class_1802.field_8187) {
            return 50.0f;
        }
        if (stack.method_7909() == class_1802.field_8797) {
            return 70.0f;
        }
        if (stack.method_7909() == class_1802.field_17533) {
            return 90.0f;
        }
        if (stack.method_7909() == class_1802.field_8894) {
            return 95.0f;
        }
        if (stack.method_7909() == class_1802.field_8713) {
            return 97.0f;
        }
        if (stack.method_7909() == class_1802.field_8665) {
            return 97.0f;
        }
        return 100.0f;
    }

    private void addItemToInventory(class_1263 inventory, class_1799 stack) {
        for (int i = 0; i < inventory.method_5439(); ++i) {
            class_1799 slotStack = inventory.method_5438(i);
            if (slotStack.method_7960()) {
                inventory.method_5447(i, stack);
                return;
            }
            if (!class_1799.method_31577((class_1799)slotStack, (class_1799)stack)) continue;
            int maxCount = Math.min(stack.method_7914(), inventory.method_5444());
            int transferAmount = Math.min(stack.method_7947(), maxCount - slotStack.method_7947());
            if (transferAmount <= 0) continue;
            slotStack.method_7933(transferAmount);
            stack.method_7934(transferAmount);
            if (!stack.method_7960()) continue;
            return;
        }
    }

    public boolean consumePowerAmount(float amount) {
        if (this.currentPower >= amount) {
            this.currentPower -= amount;
            return true;
        }
        return false;
    }

    public boolean hasPower() {
        return this.currentPower > 0.0f;
    }

    public float getCurrentPower() {
        return this.currentPower;
    }

    public void setCurrentPower(float power) {
        this.currentPower = Math.max(0.0f, Math.min(this.maxPower, power));
    }

    public float getMaxPower() {
        return this.maxPower;
    }
}

