/*
 * Decompiled with CFR 0.152.
 */
package net.rizen.submarines.api.submarine;

import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.rizen.submarines.api.item.TorpedoItem;

public class SubmarineWeaponSystem {
    private int torpedoCooldown = 0;
    private int torpedoArmingTimer = 0;
    private int previousTorpedoCount = 0;
    private final int cooldownTicks;
    private final int armingTicks;

    public SubmarineWeaponSystem(int cooldownTicks, int armingTicks) {
        this.cooldownTicks = cooldownTicks;
        this.armingTicks = armingTicks;
    }

    public void tick() {
        if (this.torpedoCooldown > 0) {
            --this.torpedoCooldown;
        }
        if (this.torpedoArmingTimer > 0) {
            --this.torpedoArmingTimer;
        }
    }

    public int countTorpedoes(class_1263 inventory) {
        int count = 0;
        for (int i = 0; i < inventory.method_5439(); ++i) {
            class_1799 stack = inventory.method_5438(i);
            if (!(stack.method_7909() instanceof TorpedoItem)) continue;
            count += stack.method_7947();
        }
        return count;
    }

    public void updateTorpedoCount(class_1263 inventory) {
        int currentCount = this.countTorpedoes(inventory);
        if (this.previousTorpedoCount == 0 && currentCount > 0) {
            this.torpedoArmingTimer = this.armingTicks;
        }
        this.previousTorpedoCount = currentCount;
    }

    public boolean findAndConsumeTorpedo(class_1263 inventory) {
        for (int i = 0; i < inventory.method_5439(); ++i) {
            class_1799 stack = inventory.method_5438(i);
            if (!(stack.method_7909() instanceof TorpedoItem) || stack.method_7960()) continue;
            stack.method_7934(1);
            inventory.method_5431();
            return true;
        }
        return false;
    }

    public boolean canFire() {
        return this.torpedoCooldown == 0 && this.torpedoArmingTimer == 0;
    }

    public void setFired() {
        this.torpedoCooldown = this.cooldownTicks;
        this.torpedoArmingTimer = this.armingTicks;
    }

    public boolean isArmed() {
        return this.torpedoArmingTimer == 0;
    }

    public int getTorpedoCooldown() {
        return this.torpedoCooldown;
    }

    public int getTorpedoArmingTimer() {
        return this.torpedoArmingTimer;
    }

    public int getPreviousTorpedoCount() {
        return this.previousTorpedoCount;
    }

    public void setTorpedoCooldown(int cooldown) {
        this.torpedoCooldown = cooldown;
    }

    public void setPreviousTorpedoCount(int count) {
        this.previousTorpedoCount = count;
    }
}

