/*
 * Decompiled with CFR 0.152.
 */
package net.rizen.submarines.api.submarine.sonar;

import net.minecraft.class_243;
import net.rizen.submarines.api.submarine.sonar.ContactType;

public class SonarContact {
    private final class_243 relativePosition;
    private final ContactType type;
    private final double distance;
    private final float angle;
    private final long detectionTime;
    private boolean revealed;
    private long revealTime;

    public SonarContact(class_243 relativePosition, ContactType type, double distance, float angle, long detectionTime) {
        this.relativePosition = relativePosition;
        this.type = type;
        this.distance = distance;
        this.angle = angle;
        this.detectionTime = detectionTime;
        this.revealed = false;
        this.revealTime = 0L;
    }

    public ContactType getType() {
        return this.type;
    }

    public double getDistance() {
        return this.distance;
    }

    public float getAngle() {
        return this.angle;
    }

    public boolean isRevealed() {
        return this.revealed;
    }

    public void reveal(long currentTime) {
        this.revealed = true;
        this.revealTime = currentTime;
    }

    public boolean shouldRemove(long currentTime) {
        if (!this.revealed) {
            return currentTime - this.detectionTime > 10000L;
        }
        return currentTime - this.revealTime > 2000L;
    }

    public float getFadeAlpha(long currentTime) {
        if (!this.revealed) {
            return 0.0f;
        }
        long timeSinceReveal = currentTime - this.revealTime;
        if (timeSinceReveal > 2000L) {
            return 0.0f;
        }
        return 1.0f - (float)timeSinceReveal / 2000.0f;
    }
}

