/*
 * Decompiled with CFR 0.152.
 */
package net.rizen.submarines.api.submarine.sonar;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.rizen.submarines.api.submarine.BaseSubmarine;
import net.rizen.submarines.api.submarine.sonar.ContactType;
import net.rizen.submarines.api.submarine.sonar.SonarContact;

public class SonarSystem {
    private final List<SonarContact> contacts = new ArrayList<SonarContact>();
    private float sweepAngle = 0.0f;
    private long lastPingTime = 0L;
    private static final float SWEEP_SPEED = 1.5f;
    private static final double MAX_RANGE = 64.0;

    public void tick() {
        this.sweepAngle += 1.5f;
        if (this.sweepAngle >= 360.0f) {
            this.sweepAngle -= 360.0f;
        }
        long currentTime = System.currentTimeMillis();
        this.contacts.removeIf(contact -> contact.shouldRemove(currentTime));
        for (SonarContact contact2 : this.contacts) {
            if (contact2.isRevealed() || !this.isAngleInSweep(contact2.getAngle())) continue;
            contact2.reveal(currentTime);
        }
    }

    private boolean isAngleInSweep(float contactAngle) {
        float tolerance = 3.5f;
        float diff = Math.abs(this.normalizeAngle(this.sweepAngle - contactAngle));
        return diff <= tolerance;
    }

    private float normalizeAngle(float angle) {
        while (angle > 180.0f) {
            angle -= 360.0f;
        }
        while (angle < -180.0f) {
            angle += 360.0f;
        }
        return angle;
    }

    public void performPing(class_1937 world, class_243 submarinePos, float submarineYaw, class_1297 submarine) {
        this.lastPingTime = System.currentTimeMillis();
        this.contacts.clear();
        this.detectEntities(world, submarinePos, submarineYaw);
        this.detectTerrain(world, submarinePos, submarineYaw, submarine);
    }

    private void detectEntities(class_1937 world, class_243 submarinePos, float submarineYaw) {
        List nearbyEntities = world.method_8335(null, new class_238(submarinePos.field_1352 - 64.0, submarinePos.field_1351 - 64.0, submarinePos.field_1350 - 64.0, submarinePos.field_1352 + 64.0, submarinePos.field_1351 + 64.0, submarinePos.field_1350 + 64.0));
        for (class_1297 entity : nearbyEntities) {
            class_243 entityPos = entity.method_19538();
            class_243 relativePos = entityPos.method_1020(submarinePos);
            double distance = relativePos.method_1033();
            if (distance > 64.0 || distance < 5.0 || !this.isEntityInWater(world, entity)) continue;
            float angle = this.calculateAngle(relativePos, submarineYaw);
            ContactType type = this.classifyEntity(entity);
            this.contacts.add(new SonarContact(relativePos, type, distance, angle, this.lastPingTime));
        }
    }

    private void detectTerrain(class_1937 world, class_243 submarinePos, float submarineYaw, class_1297 submarine) {
        for (int angleDeg = 0; angleDeg < 360; angleDeg += 3) {
            class_2338 blockPos;
            class_243 end;
            float worldAngle = submarineYaw + (float)angleDeg;
            float yawRad = (float)Math.toRadians(worldAngle);
            class_243 direction = new class_243(-Math.sin(yawRad), 0.0, Math.cos(yawRad));
            class_243 start = submarinePos.method_1019(direction.method_1021(5.0));
            class_3965 hitResult = world.method_17742(new class_3959(start, end = submarinePos.method_1019(direction.method_1021(64.0)), class_3959.class_3960.field_17558, class_3959.class_242.field_1348, submarine));
            if (hitResult.method_17783() != class_239.class_240.field_1332 || !this.isBlockUnderwater(world, blockPos = hitResult.method_17777())) continue;
            class_243 hitPos = hitResult.method_17784();
            class_243 relativePos = hitPos.method_1020(submarinePos);
            double dist = relativePos.method_1033();
            float angle = this.calculateAngle(relativePos, submarineYaw);
            this.contacts.add(new SonarContact(relativePos, ContactType.TERRAIN, dist, angle, this.lastPingTime));
        }
    }

    private boolean isEntityInWater(class_1937 world, class_1297 entity) {
        return entity.method_5869() || entity.method_5799();
    }

    private boolean isBlockUnderwater(class_1937 world, class_2338 blockPos) {
        return !world.method_8316(blockPos.method_10084()).method_15769() || !world.method_8316(blockPos).method_15769();
    }

    private float calculateAngle(class_243 relativePos, float submarineYaw) {
        float angle = (float)Math.toDegrees(Math.atan2(-relativePos.field_1352, relativePos.field_1350));
        angle -= submarineYaw;
        while (angle < 0.0f) {
            angle += 360.0f;
        }
        while (angle >= 360.0f) {
            angle -= 360.0f;
        }
        return angle;
    }

    private ContactType classifyEntity(class_1297 entity) {
        if (entity instanceof BaseSubmarine) {
            return ContactType.SUBMARINE;
        }
        if (entity instanceof class_1657) {
            return ContactType.PLAYER;
        }
        if (entity instanceof class_1542) {
            return ContactType.ITEM;
        }
        String entityName = entity.method_5864().toString().toLowerCase();
        if (entityName.contains("squid") || entityName.contains("cod") || entityName.contains("salmon") || entityName.contains("tropical")) {
            return ContactType.SMALL_MOB;
        }
        return ContactType.MEDIUM_ENTITY;
    }

    public List<SonarContact> getContacts() {
        return this.contacts;
    }

    public float getSweepAngle() {
        return this.sweepAngle;
    }

    public long getLastPingTime() {
        return this.lastPingTime;
    }

    public double getMaxRange() {
        return 64.0;
    }
}

