/*
 * Decompiled with CFR 0.152.
 */
package net.rizen.submarines.api.torpedo;

import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1676;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2945;
import net.minecraft.class_3965;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.rizen.submarines.api.submarine.BaseSubmarine;
import net.rizen.submarines.api.torpedo.TargetingMode;
import net.rizen.submarines.api.torpedo.TorpedoCollision;
import net.rizen.submarines.api.torpedo.TorpedoPhysics;

public abstract class BaseTorpedo
extends class_1676 {
    protected final TorpedoPhysics physics;
    protected final TorpedoCollision collision;
    protected int ticksAlive = 0;
    protected float width;
    protected float height;
    protected float length;
    private static final int ARMING_DELAY = 10;
    private static final int WATER_CHECK_DELAY = 5;
    private class_1297 currentTarget = null;
    private TargetingMode targetingMode = TargetingMode.ALL;

    public BaseTorpedo(class_1299<? extends BaseTorpedo> entityType, class_1937 world, float maxSpeed, int maxRange, float explosionPower, float directDamage, float width, float height, float length) {
        super(entityType, world);
        this.physics = new TorpedoPhysics(maxSpeed, maxRange);
        this.collision = new TorpedoCollision(explosionPower, directDamage);
        this.width = width;
        this.height = height;
        this.length = length;
        this.field_5960 = false;
    }

    public void initialize(double x, double y, double z, float yaw, float pitch) {
        this.method_5814(x, y, z);
        this.method_36456(yaw);
        this.method_36457(pitch);
        this.physics.setStartPosition(new class_243(x, y, z));
        class_243 velocity = this.physics.calculateVelocity(yaw, pitch);
        this.method_18800(velocity.field_1352, velocity.field_1351, velocity.field_1350);
    }

    public void setTargetingMode(TargetingMode mode) {
        this.targetingMode = mode;
    }

    public TargetingMode getTargetingMode() {
        return this.targetingMode;
    }

    public void setOwnerSubmarine(BaseSubmarine submarine) {
        this.collision.setOwnerSubmarine(submarine);
    }

    public class_4048 method_18377(class_4050 pose) {
        return class_4048.method_18384((float)this.width, (float)this.height);
    }

    protected class_238 method_33332() {
        float halfWidth = this.width / 2.0f;
        float halfHeight = this.height / 2.0f;
        float halfLength = this.length / 2.0f;
        double yawRad = Math.toRadians(this.method_36454());
        double cos = Math.cos(yawRad);
        double sin = Math.sin(yawRad);
        double maxX = Math.abs((double)halfWidth * cos) + Math.abs((double)halfLength * sin);
        double maxZ = Math.abs((double)halfWidth * sin) + Math.abs((double)halfLength * cos);
        return new class_238(this.method_23317() - maxX, this.method_23318() - (double)halfHeight, this.method_23321() - maxZ, this.method_23317() + maxX, this.method_23318() + (double)halfHeight, this.method_23321() + maxZ);
    }

    protected void method_5693(class_2945.class_9222 builder) {
    }

    public void method_5773() {
        class_1297 entityHit;
        super.method_5773();
        ++this.ticksAlive;
        if (this.method_37908().field_9236) {
            this.physics.spawnTrailParticles(this.method_37908(), this.method_23317(), this.method_23318(), this.method_23321());
        }
        if (this.ticksAlive > 5 && !this.method_5869()) {
            if (!this.method_37908().field_9236) {
                this.collision.explode(this.method_37908(), (class_1297)this);
            }
            return;
        }
        if (this.physics.hasExceededRange(this.method_19538())) {
            this.collision.explode(this.method_37908(), (class_1297)this);
            return;
        }
        if (this.physics.getTotalDistanceTraveled() >= 128.0) {
            this.collision.explode(this.method_37908(), (class_1297)this);
            return;
        }
        class_239 blockHit = this.collision.checkBlockCollision(this.method_37908(), (class_1297)this, this.method_18798());
        if (blockHit.method_17783() != class_239.class_240.field_1333) {
            this.method_7488(blockHit);
            return;
        }
        if (!this.method_37908().field_9236 && (entityHit = this.collision.checkEntityCollision(this.method_37908(), (class_1297)this, this.method_5829())) != null) {
            this.collision.handleEntityHit(this.method_37908(), (class_1297)this, entityHit);
            this.collision.explode(this.method_37908(), (class_1297)this);
            return;
        }
        if (!this.method_37908().field_9236 && this.ticksAlive > 10) {
            if (!this.physics.isTargetValid(this.currentTarget, this.method_19538(), this.method_36454())) {
                this.currentTarget = this.physics.findNearestTarget(this.method_37908(), (class_1297)this, this.method_19538(), this.method_36454(), this.targetingMode, this.collision.getOwnerSubmarineId());
            }
            if (this.currentTarget != null) {
                class_243 newVelocity = this.physics.calculateHomingVelocity(this.method_18798(), this.method_19538(), this.currentTarget.method_19538(), this.method_36454(), this.method_36455());
                this.method_18799(newVelocity);
            }
        }
        class_243 movement = this.method_18798();
        this.method_5814(this.method_23317() + movement.field_1352, this.method_23318() + movement.field_1351, this.method_23321() + movement.field_1350);
        this.physics.updateDistanceTraveled(movement);
        this.physics.updateRotation((class_1297)this, this.method_18798());
    }

    protected void method_24920(class_3965 blockHitResult) {
        super.method_24920(blockHitResult);
        if (!this.method_37908().field_9236) {
            this.collision.explode(this.method_37908(), (class_1297)this);
        }
    }

    public boolean method_5740() {
        return true;
    }

    protected void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        if (nbt.method_10545("StartPosX")) {
            class_243 startPos = new class_243(nbt.method_10574("StartPosX"), nbt.method_10574("StartPosY"), nbt.method_10574("StartPosZ"));
            this.physics.setStartPosition(startPos);
        }
        this.ticksAlive = nbt.method_10550("TicksAlive");
        this.collision.setOwnerSubmarineId(nbt.method_10550("OwnerSubmarineId"));
        this.physics.setTotalDistanceTraveled(nbt.method_10574("DistanceTraveled"));
        if (nbt.method_10545("TargetingMode")) {
            this.targetingMode = TargetingMode.values()[nbt.method_10550("TargetingMode")];
        }
    }

    protected void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        class_243 startPos = this.physics.getStartPos();
        if (startPos != null) {
            nbt.method_10549("StartPosX", startPos.field_1352);
            nbt.method_10549("StartPosY", startPos.field_1351);
            nbt.method_10549("StartPosZ", startPos.field_1350);
        }
        nbt.method_10569("TicksAlive", this.ticksAlive);
        nbt.method_10569("OwnerSubmarineId", this.collision.getOwnerSubmarineId());
        nbt.method_10549("DistanceTraveled", this.physics.getTotalDistanceTraveled());
        nbt.method_10569("TargetingMode", this.targetingMode.ordinal());
    }
}

