/*
 * Decompiled with CFR 0.152.
 */
package net.rizen.submarines.api.torpedo;

import java.util.List;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.rizen.submarines.api.submarine.BaseSubmarine;
import net.rizen.submarines.api.torpedo.TargetingMode;

public class TorpedoPhysics {
    private final float maxSpeed;
    private final int maxRange;
    private static final float DETECTION_RANGE = 30.0f;
    private static final float DETECTION_ANGLE = 90.0f;
    private static final float MAX_TURN_RATE = 5.0f;
    private static final float CONSTANT_SPEED = 1.0f;
    private class_243 startPos;
    private double totalDistanceTraveled = 0.0;

    public TorpedoPhysics(float maxSpeed, int maxRange) {
        this.maxSpeed = maxSpeed;
        this.maxRange = maxRange;
    }

    public void setStartPosition(class_243 pos) {
        this.startPos = pos;
    }

    public class_243 calculateVelocity(float yaw, float pitch) {
        float yawRad = (float)Math.toRadians(yaw);
        float pitchRad = (float)Math.toRadians(pitch);
        double vx = -Math.sin(yawRad) * Math.cos(pitchRad) * (double)this.maxSpeed;
        double vy = -Math.sin(pitchRad) * (double)this.maxSpeed;
        double vz = Math.cos(yawRad) * Math.cos(pitchRad) * (double)this.maxSpeed;
        return new class_243(vx, vy, vz);
    }

    public boolean hasExceededRange(class_243 currentPos) {
        if (this.startPos == null) {
            return false;
        }
        return currentPos.method_1022(this.startPos) > (double)this.maxRange;
    }

    public void updateRotation(class_1297 entity, class_243 velocity) {
        if (velocity.method_1027() > 1.0E-4) {
            entity.method_36456((float)(Math.atan2(-velocity.field_1352, velocity.field_1350) * 57.29577951308232));
            entity.method_36457((float)(Math.atan2(velocity.field_1351, Math.sqrt(velocity.field_1352 * velocity.field_1352 + velocity.field_1350 * velocity.field_1350)) * 57.29577951308232));
        }
    }

    public void spawnTrailParticles(class_1937 world, double x, double y, double z) {
        world.method_8406((class_2394)class_2398.field_11247, x, y, z, 0.0, 0.0, 0.0);
    }

    public class_243 getStartPos() {
        return this.startPos;
    }

    public class_1297 findNearestTarget(class_1937 world, class_1297 torpedo, class_243 torpedoPos, float torpedoYaw, TargetingMode targetingMode, int ownerSubmarineId) {
        if (world == null) {
            return null;
        }
        List nearbyEntities = world.method_8335(torpedo, torpedo.method_5829().method_1014(30.0));
        class_1297 closestTarget = null;
        double closestDistance = 30.0;
        for (class_1297 entity : nearbyEntities) {
            class_243 entityPos;
            double distance;
            class_1309 livingEntity;
            if (entity instanceof BaseSubmarine && entity.method_5628() == ownerSubmarineId || !this.matchesTargetingMode(entity, targetingMode) || !entity.method_5869() || entity instanceof class_1309 && (livingEntity = (class_1309)entity).method_6059(class_1294.field_5905) || (distance = torpedoPos.method_1022(entityPos = entity.method_19538())) > 30.0 || !this.isInDetectionCone(torpedoPos, torpedoYaw, entityPos) || !(distance < closestDistance)) continue;
            closestDistance = distance;
            closestTarget = entity;
        }
        return closestTarget;
    }

    private boolean matchesTargetingMode(class_1297 entity, TargetingMode mode) {
        return switch (mode) {
            default -> throw new MatchException(null, null);
            case TargetingMode.ALL -> {
                if (entity instanceof class_1309 || entity instanceof BaseSubmarine) {
                    yield true;
                }
                yield false;
            }
            case TargetingMode.PLAYERS -> entity instanceof class_1657;
            case TargetingMode.SUBMARINES -> entity instanceof BaseSubmarine;
            case TargetingMode.ENTITIES -> entity instanceof class_1309 && !(entity instanceof class_1657);
        };
    }

    private boolean isInDetectionCone(class_243 torpedoPos, float torpedoYaw, class_243 targetPos) {
        class_243 toTarget = targetPos.method_1020(torpedoPos).method_1029();
        float yawRad = (float)Math.toRadians(torpedoYaw);
        class_243 forward = new class_243(-Math.sin(yawRad), 0.0, Math.cos(yawRad));
        double dotProduct = forward.field_1352 * toTarget.field_1352 + forward.field_1350 * toTarget.field_1350;
        double angle = Math.toDegrees(Math.acos(Math.max(-1.0, Math.min(1.0, dotProduct))));
        return angle <= 45.0;
    }

    public boolean isTargetValid(class_1297 target, class_243 torpedoPos, float torpedoYaw) {
        class_1309 livingEntity;
        if (target == null || target.method_31481()) {
            return false;
        }
        if (!target.method_5869()) {
            return false;
        }
        if (target instanceof class_1309 && (livingEntity = (class_1309)target).method_6059(class_1294.field_5905)) {
            return false;
        }
        class_243 targetPos = target.method_19538();
        double distance = torpedoPos.method_1022(targetPos);
        if (distance > 30.0) {
            return false;
        }
        return this.isInDetectionCone(torpedoPos, torpedoYaw, targetPos);
    }

    public class_243 calculateHomingVelocity(class_243 currentVelocity, class_243 torpedoPos, class_243 targetPos, float currentYaw, float currentPitch) {
        class_243 newDirection;
        double maxTurnRad;
        class_243 toTarget = targetPos.method_1020(torpedoPos);
        double distanceToTarget = toTarget.method_1033();
        if (distanceToTarget < 0.001) {
            return currentVelocity;
        }
        toTarget = toTarget.method_1029();
        class_243 currentDirection = currentVelocity.method_1033() > 0.001 ? currentVelocity.method_1029() : new class_243(0.0, 0.0, 1.0);
        double dotProduct = currentDirection.method_1026(toTarget);
        double angleBetween = Math.acos(dotProduct = Math.max(-1.0, Math.min(1.0, dotProduct)));
        if (angleBetween <= (maxTurnRad = Math.toRadians(5.0))) {
            newDirection = toTarget;
        } else {
            class_243 axis = currentDirection.method_1036(toTarget);
            double axisLength = axis.method_1033();
            if (axisLength < 0.001) {
                newDirection = currentDirection;
            } else {
                axis = axis.method_1029();
                double cos = Math.cos(maxTurnRad);
                double sin = Math.sin(maxTurnRad);
                newDirection = currentDirection.method_1021(cos).method_1019(axis.method_1036(currentDirection).method_1021(sin)).method_1019(axis.method_1021(axis.method_1026(currentDirection) * (1.0 - cos)));
            }
        }
        return newDirection.method_1029().method_1021(1.0);
    }

    public void updateDistanceTraveled(class_243 movement) {
        this.totalDistanceTraveled += movement.method_1033();
    }

    public double getTotalDistanceTraveled() {
        return this.totalDistanceTraveled;
    }

    public void setTotalDistanceTraveled(double distance) {
        this.totalDistanceTraveled = distance;
    }
}

