/*
 * Decompiled with CFR 0.152.
 */
package net.rizen.submarines.client.screen;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_465;
import net.minecraft.class_5348;
import net.minecraft.class_8710;
import net.rizen.submarines.api.crafting.ManufacturingRecipe;
import net.rizen.submarines.api.crafting.ManufacturingRecipeRegistry;
import net.rizen.submarines.api.network.packet.ManufacturingCraftPacket;
import net.rizen.submarines.screen.ManufacturingTableScreenHandler;

public class ManufacturingTableScreen
extends class_465<ManufacturingTableScreenHandler> {
    private static final List<String> CATEGORIES = Arrays.asList("submarines", "weapons", "components");
    private static final int BUTTON_HEIGHT = 24;
    private static final int RECIPE_BUTTON_HEIGHT = 20;
    private static final int COLOR_BACKGROUND = -14803410;
    private static final int COLOR_PANEL = -14013890;
    private static final int COLOR_PANEL_LIGHT = -13290160;
    private static final int COLOR_HEADER = -15198171;
    private static final int COLOR_BORDER_DARK = -15790312;
    private static final int COLOR_BORDER_LIGHT = -12698018;
    private static final int COLOR_ACCENT = -7752454;
    private static final int COLOR_SUCCESS = -7019819;
    private static final int COLOR_ERROR = -816216;
    private static final int COLOR_TEXT = -3287308;
    private static final int COLOR_TEXT_DIM = -7104078;
    private static final int COLOR_SCROLLBAR = -12236966;
    private static final int COLOR_SCROLLBAR_THUMB = -10986640;
    private String selectedCategory = null;
    private ManufacturingRecipe selectedRecipe = null;
    private List<String> categories = new ArrayList<String>();
    private Map<String, List<class_4185>> categoryButtons = new HashMap<String, List<class_4185>>();
    private List<class_4185> recipeButtons = new ArrayList<class_4185>();
    private class_4185 craftButton;
    private float scrollOffset = 0.0f;
    private int maxScroll = 0;
    private boolean isDraggingScrollbar = false;
    private int recipeListHeight = 0;

    public ManufacturingTableScreen(ManufacturingTableScreenHandler handler, class_1661 inventory, class_2561 title) {
        super((class_1703)handler, inventory, title);
        this.field_2792 = 260;
        this.field_2779 = 240;
    }

    protected void method_25426() {
        super.method_25426();
        this.categories = new ArrayList<String>(CATEGORIES);
        if (!this.categories.isEmpty() && this.selectedCategory == null) {
            this.selectedCategory = this.categories.get(0);
        }
        int leftX = this.field_2776 + 14;
        int startY = this.field_2800 + 35;
        for (int i = 0; i < this.categories.size(); ++i) {
            String category = this.categories.get(i);
            int yPos = startY + i * 28;
            class_4185 button2 = class_4185.method_46430((class_2561)class_2561.method_43470((String)this.capitalizeFirstLetter(category)), btn -> {
                this.selectedCategory = category;
                this.selectedRecipe = null;
                this.scrollOffset = 0.0f;
                this.rebuildRecipeButtons();
                this.updateButtonStates();
            }).method_46434(leftX, yPos, 88, 24).method_46431();
            this.method_37063((class_364)button2);
            this.categoryButtons.computeIfAbsent(category, k -> new ArrayList()).add(button2);
        }
        int craftButtonX = this.field_2776 + (this.field_2792 - 110) / 2 + 55;
        int craftButtonY = this.field_2800 + 208;
        this.craftButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Craft"), button -> this.handleCraft()).method_46434(craftButtonX, craftButtonY, 110, 26).method_46431());
        this.rebuildRecipeButtons();
        this.updateButtonStates();
    }

    private void rebuildRecipeButtons() {
        for (class_4185 button : this.recipeButtons) {
            this.method_37066((class_364)button);
        }
        this.recipeButtons.clear();
        if (this.selectedCategory == null) {
            return;
        }
        List<ManufacturingRecipe> recipes = ManufacturingRecipeRegistry.getRecipesByCategory(this.selectedCategory);
        int leftX = this.field_2776 + 14;
        int startY = this.field_2800 + 120;
        this.recipeListHeight = 75;
        int totalHeight = recipes.size() * 22;
        this.maxScroll = Math.max(0, totalHeight - this.recipeListHeight);
        for (int i = 0; i < recipes.size(); ++i) {
            ManufacturingRecipe recipe = recipes.get(i);
            int yPos = startY + i * 22 - (int)this.scrollOffset;
            class_4185 button = class_4185.method_46430((class_2561)class_2561.method_43470((String)recipe.getDisplayName()), btn -> {
                this.selectedRecipe = recipe;
                this.updateButtonStates();
            }).method_46434(leftX, yPos, 88, 20).method_46431();
            button.field_22764 = yPos >= startY && yPos + 20 <= startY + this.recipeListHeight;
            this.method_37063((class_364)button);
            this.recipeButtons.add(button);
        }
    }

    private void updateButtonStates() {
        for (Map.Entry<String, List<class_4185>> entry : this.categoryButtons.entrySet()) {
            boolean selected = entry.getKey().equals(this.selectedCategory);
            for (class_4185 btn : entry.getValue()) {
                btn.field_22763 = !selected;
            }
        }
        for (int i = 0; i < this.recipeButtons.size(); ++i) {
            class_4185 btn = this.recipeButtons.get(i);
            List<ManufacturingRecipe> recipes = ManufacturingRecipeRegistry.getRecipesByCategory(this.selectedCategory);
            if (i >= recipes.size()) continue;
            btn.field_22763 = recipes.get(i) != this.selectedRecipe;
        }
        this.craftButton.field_22763 = this.selectedRecipe != null && this.field_22787.field_1724 != null && ManufacturingRecipeRegistry.hasIngredients(this.field_22787.field_1724.method_31548(), this.selectedRecipe);
    }

    protected void method_2389(class_332 context, float delta, int mouseX, int mouseY) {
        int x = (this.field_22789 - this.field_2792) / 2;
        int y = (this.field_22790 - this.field_2779) / 2;
        context.method_25294(x, y, x + this.field_2792, y + this.field_2779, -14803410);
        context.method_49601(x, y, this.field_2792, this.field_2779, -15790312);
        context.method_49601(x + 1, y + 1, this.field_2792 - 2, this.field_2779 - 2, -12698018);
        context.method_25294(x + 2, y + 2, x + this.field_2792 - 2, y + 24, -15198171);
        context.method_25294(x + 2, y + 22, x + this.field_2792 - 2, y + 24, -12698018);
        int categoryPanelX = x + 10;
        int categoryPanelY = y + 30;
        int categoryPanelWidth = 106;
        int categoryPanelHeight = 170;
        this.drawPanel(context, categoryPanelX, categoryPanelY, categoryPanelWidth, categoryPanelHeight);
        int recipePanelX = x + 122;
        int recipePanelY = y + 30;
        int recipePanelWidth = 130;
        int recipePanelHeight = 170;
        this.drawPanel(context, recipePanelX, recipePanelY, recipePanelWidth, recipePanelHeight);
        context.method_25294(x + 10, y + 204, x + this.field_2792 - 10, y + 205, -7752454);
        int separatorY = categoryPanelY + 86;
        context.method_25294(categoryPanelX + 4, separatorY, categoryPanelX + categoryPanelWidth - 4, separatorY + 1, -12698018);
        if (this.maxScroll > 0) {
            this.drawScrollbar(context, categoryPanelX + categoryPanelWidth - 12, categoryPanelY + 90, this.recipeListHeight);
        }
    }

    private void drawPanel(class_332 context, int x, int y, int width, int height) {
        context.method_25294(x, y, x + width, y + height, -14013890);
        context.method_25294(x + 2, y + 2, x + width - 2, y + height - 2, -13290160);
        context.method_49601(x, y, width, height, -15790312);
        context.method_49601(x + 1, y + 1, width - 2, height - 2, -12698018);
    }

    private void drawScrollbar(class_332 context, int x, int y, int height) {
        context.method_25294(x, y, x + 6, y + height, -12236966);
        if (this.maxScroll > 0) {
            int thumbHeight = Math.max(10, (int)((float)height * ((float)height / (float)(height + this.maxScroll))));
            int thumbY = y + (int)((float)(height - thumbHeight) * (this.scrollOffset / (float)this.maxScroll));
            context.method_25294(x + 1, thumbY, x + 5, thumbY + thumbHeight, -10986640);
        }
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        if (this.selectedRecipe != null) {
            this.renderRecipeDetails(context, this.field_2776 + 130, this.field_2800 + 40);
        }
        this.method_2380(context, mouseX, mouseY);
    }

    private void renderRecipeDetails(class_332 context, int x, int y) {
        if (this.field_22787.field_1724 == null) {
            return;
        }
        class_1661 inventory = this.field_22787.field_1724.method_31548();
        context.method_51433(this.field_22793, "Required Materials:", x, y, -7752454, true);
        int ingredientY = y + 14;
        for (ManufacturingRecipe.Ingredient ingredient : this.selectedRecipe.getIngredients()) {
            int count = this.countItemInInventory(inventory, ingredient.getItem());
            boolean hasEnough = count >= ingredient.getCount();
            int color = hasEnough ? -7019819 : -816216;
            context.method_51427(new class_1799((class_1935)ingredient.getItem()), x, ingredientY);
            context.method_51433(this.field_22793, "x" + ingredient.getCount(), x + 20, ingredientY, -7104078, false);
            String itemName = new class_1799((class_1935)ingredient.getItem()).method_7964().getString();
            context.method_51433(this.field_22793, itemName, x + 20, ingredientY + 8, color, false);
            ingredientY += 20;
        }
        int separatorY = ingredientY + 4;
        context.method_25294(x - 5, separatorY, x - 5 + 125, separatorY + 1, -12698018);
        context.method_51433(this.field_22793, "Result:", x, separatorY + 6, -7752454, true);
        context.method_51427(this.selectedRecipe.getResult(), x + 45, separatorY + 16);
        boolean canCraft = ManufacturingRecipeRegistry.hasIngredients(inventory, this.selectedRecipe);
        if (canCraft) {
            context.method_51433(this.field_22793, "Ready!", x + 69, separatorY + 22, -7019819, true);
        } else {
            context.method_51433(this.field_22793, "Missing", x + 69, separatorY + 22, -816216, false);
        }
    }

    private int countItemInInventory(class_1661 inventory, class_1792 item) {
        int count = 0;
        for (int i = 0; i < inventory.method_5439(); ++i) {
            class_1799 stack = inventory.method_5438(i);
            if (stack.method_7909() != item) continue;
            count += stack.method_7947();
        }
        return count;
    }

    private void handleCraft() {
        if (this.selectedRecipe == null) {
            return;
        }
        if (ManufacturingRecipeRegistry.hasIngredients(this.field_22787.field_1724.method_31548(), this.selectedRecipe)) {
            this.craftButton.field_22763 = false;
            ClientPlayNetworking.send((class_8710)new ManufacturingCraftPacket(this.selectedRecipe.getId(), ((ManufacturingTableScreenHandler)this.field_2797).getTablePos()));
        }
    }

    protected void method_2388(class_332 context, int mouseX, int mouseY) {
        List<ManufacturingRecipe> recipes;
        int recipeIndex;
        int titleX = (this.field_2792 - this.field_22793.method_27525((class_5348)this.field_22785)) / 2;
        context.method_51439(this.field_22793, this.field_22785, titleX, 8, -3287308, true);
        if (this.selectedCategory != null) {
            int indicatorX = 12;
            int categoryIndex = this.categories.indexOf(this.selectedCategory);
            if (categoryIndex >= 0) {
                int indicatorY = 35 + categoryIndex * 28;
                context.method_25294(indicatorX, indicatorY, indicatorX + 2, indicatorY + 24, -7752454);
            }
        }
        if (this.selectedRecipe != null && this.selectedCategory != null && (recipeIndex = (recipes = ManufacturingRecipeRegistry.getRecipesByCategory(this.selectedCategory)).indexOf(this.selectedRecipe)) >= 0) {
            int indicatorX = 12;
            int indicatorY = 120 + recipeIndex * 22 - (int)this.scrollOffset;
            if (indicatorY >= 120 && indicatorY < 120 + this.recipeListHeight) {
                context.method_25294(indicatorX, indicatorY, indicatorX + 2, indicatorY + 20, -7019819);
            }
        }
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (this.maxScroll > 0) {
            this.scrollOffset = Math.max(0.0f, Math.min((float)this.maxScroll, this.scrollOffset - (float)(verticalAmount * 10.0)));
            this.updateRecipeButtonVisibility();
            return true;
        }
        return super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.maxScroll > 0) {
            int scrollbarX = this.field_2776 + 10 + 106 - 12;
            int scrollbarY = this.field_2800 + 90;
            if (mouseX >= (double)scrollbarX && mouseX <= (double)(scrollbarX + 6) && mouseY >= (double)scrollbarY && mouseY <= (double)(scrollbarY + this.recipeListHeight)) {
                this.isDraggingScrollbar = true;
                return true;
            }
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.isDraggingScrollbar && this.maxScroll > 0) {
            int scrollbarY = this.field_2800 + 90;
            float relativeY = (float)(mouseY - (double)scrollbarY) / (float)this.recipeListHeight;
            this.scrollOffset = Math.max(0.0f, Math.min((float)this.maxScroll, relativeY * (float)this.maxScroll));
            this.updateRecipeButtonVisibility();
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        this.isDraggingScrollbar = false;
        return super.method_25406(mouseX, mouseY, button);
    }

    private void updateRecipeButtonVisibility() {
        int startY = this.field_2800 + 120;
        for (int i = 0; i < this.recipeButtons.size(); ++i) {
            class_4185 button = this.recipeButtons.get(i);
            int yPos = startY + i * 22 - (int)this.scrollOffset;
            button.method_46419(yPos);
            button.field_22764 = yPos >= startY && yPos + 20 <= startY + this.recipeListHeight;
        }
    }

    private String capitalizeFirstLetter(String str) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        return str.substring(0, 1).toUpperCase() + str.substring(1);
    }
}

