/*
 * Decompiled with CFR 0.152.
 */
package net.rizen.submarines.network;

import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.rizen.submarines.Mod;
import net.rizen.submarines.api.crafting.ManufacturingRecipe;
import net.rizen.submarines.api.crafting.ManufacturingRecipeRegistry;
import net.rizen.submarines.api.network.packet.DismountPacket;
import net.rizen.submarines.api.network.packet.ManufacturingCraftPacket;
import net.rizen.submarines.api.network.packet.MovementModeTogglePacket;
import net.rizen.submarines.api.network.packet.SonarPingPacket;
import net.rizen.submarines.api.network.packet.SubmarineInputPacket;
import net.rizen.submarines.api.network.packet.TargetingModeTogglePacket;
import net.rizen.submarines.api.network.packet.TorpedoFirePacket;
import net.rizen.submarines.api.submarine.BaseSubmarine;
import net.rizen.submarines.network.SubmarinePacketHelper;

public class NetworkHandler {
    public static void registerPackets() {
        PayloadTypeRegistry.playC2S().register(SubmarineInputPacket.ID, SubmarineInputPacket.CODEC);
        PayloadTypeRegistry.playC2S().register(TorpedoFirePacket.ID, TorpedoFirePacket.CODEC);
        PayloadTypeRegistry.playC2S().register(DismountPacket.ID, DismountPacket.CODEC);
        PayloadTypeRegistry.playC2S().register(SonarPingPacket.ID, SonarPingPacket.CODEC);
        PayloadTypeRegistry.playC2S().register(MovementModeTogglePacket.ID, MovementModeTogglePacket.CODEC);
        PayloadTypeRegistry.playC2S().register(TargetingModeTogglePacket.ID, TargetingModeTogglePacket.CODEC);
        PayloadTypeRegistry.playC2S().register(ManufacturingCraftPacket.ID, ManufacturingCraftPacket.CODEC);
        ServerPlayNetworking.registerGlobalReceiver(SubmarineInputPacket.ID, (payload, context) -> SubmarinePacketHelper.withValidatedSubmarine(context, payload.entityId(), "input", submarine -> submarine.updateInput(payload.forward(), payload.backward(), payload.left(), payload.right(), payload.up(), payload.down())));
        ServerPlayNetworking.registerGlobalReceiver(TorpedoFirePacket.ID, (payload, context) -> SubmarinePacketHelper.withValidatedSubmarine(context, payload.submarineId(), "torpedo_fire", BaseSubmarine::fireTorpedo));
        ServerPlayNetworking.registerGlobalReceiver(DismountPacket.ID, (payload, context) -> SubmarinePacketHelper.withValidatedSubmarine(context, payload.submarineId(), "dismount", submarine -> {
            context.player().method_5660(false);
            context.player().method_5848();
        }));
        ServerPlayNetworking.registerGlobalReceiver(SonarPingPacket.ID, (payload, context) -> SubmarinePacketHelper.withValidatedSubmarine(context, payload.submarineId(), "sonar_ping", BaseSubmarine::performSonarPing));
        ServerPlayNetworking.registerGlobalReceiver(MovementModeTogglePacket.ID, (payload, context) -> SubmarinePacketHelper.withValidatedSubmarine(context, payload.submarineId(), "mode_toggle", BaseSubmarine::cycleMovementMode));
        ServerPlayNetworking.registerGlobalReceiver(TargetingModeTogglePacket.ID, (payload, context) -> SubmarinePacketHelper.withValidatedSubmarine(context, payload.submarineId(), "mode_toggle", BaseSubmarine::cycleTargetingMode));
        ServerPlayNetworking.registerGlobalReceiver(ManufacturingCraftPacket.ID, (payload, context) -> context.player().field_13995.execute(() -> {
            class_1661 inventory = context.player().method_31548();
            if (!context.player().method_37908().method_8320(payload.tablePos()).method_27852(Mod.MANUFACTURING_TABLE)) {
                return;
            }
            double distanceSquared = context.player().method_5649((double)payload.tablePos().method_10263() + 0.5, (double)payload.tablePos().method_10264() + 0.5, (double)payload.tablePos().method_10260() + 0.5);
            if (distanceSquared > 64.0) {
                return;
            }
            ManufacturingRecipe recipe = ManufacturingRecipeRegistry.getRecipe(payload.recipeId());
            if (recipe == null) {
                return;
            }
            class_1799 result = ManufacturingRecipeRegistry.tryCraft(inventory, recipe);
            if (!result.method_7960()) {
                if (!inventory.method_7394(result)) {
                    context.player().method_7328(result, false);
                }
                inventory.method_5431();
                context.player().field_7512.method_7623();
            }
        }));
        ServerPlayConnectionEvents.DISCONNECT.register((handler, server) -> SubmarinePacketHelper.clearPlayerData(handler.field_14140.method_5667()));
    }
}

