/*
 * Decompiled with CFR 0.152.
 */
package net.rizen.submarines.network;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.rizen.submarines.api.submarine.BaseSubmarine;

public class SubmarinePacketHelper {
    private static final Map<UUID, Map<String, Long>> lastPacketTimes = new ConcurrentHashMap<UUID, Map<String, Long>>();
    private static final long DEFAULT_COOLDOWN_MS = 50L;
    private static final Map<String, Long> PACKET_COOLDOWNS = Map.of("input", 50L, "torpedo_fire", 500L, "sonar_ping", 1000L, "mode_toggle", 200L, "dismount", 100L);

    public static void withValidatedSubmarine(ServerPlayNetworking.Context context, int entityId, String packetType, Consumer<BaseSubmarine> action) {
        UUID playerId = context.player().method_5667();
        if (!SubmarinePacketHelper.checkCooldown(playerId, packetType)) {
            return;
        }
        context.player().field_13995.execute(() -> {
            BaseSubmarine submarine;
            class_1297 entity = context.player().method_37908().method_8469(entityId);
            if (entity instanceof BaseSubmarine && (submarine = (BaseSubmarine)entity).method_5685().contains(context.player())) {
                action.accept(submarine);
            }
        });
    }

    private static boolean checkCooldown(UUID playerId, String packetType) {
        long currentTime = System.currentTimeMillis();
        long cooldown = PACKET_COOLDOWNS.getOrDefault(packetType, 50L);
        Map playerPacketTimes = lastPacketTimes.computeIfAbsent(playerId, k -> new ConcurrentHashMap());
        Long lastTime = (Long)playerPacketTimes.get(packetType);
        if (lastTime != null && currentTime - lastTime < cooldown) {
            return false;
        }
        playerPacketTimes.put(packetType, currentTime);
        if (Math.random() < 0.001) {
            SubmarinePacketHelper.cleanup(currentTime);
        }
        return true;
    }

    private static void cleanup(long currentTime) {
        lastPacketTimes.values().forEach(playerTimes -> playerTimes.entrySet().removeIf(entry -> currentTime - (Long)entry.getValue() > 5000L));
        lastPacketTimes.entrySet().removeIf(entry -> ((Map)entry.getValue()).isEmpty());
    }

    public static void clearPlayerData(UUID playerId) {
        lastPacketTimes.remove(playerId);
    }
}

