/*
 * Decompiled with CFR 0.152.
 */
package com.fallenmeteor67.itemtrail.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.WeakHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="itemtrail", value={Dist.CLIENT})
public class RarityTrailRenderer {
    private static final Map<Entity, Deque<Vector3d>> trails = new WeakHashMap<Entity, Deque<Vector3d>>();
    private static final Map<Entity, List<RarityOrb>> beamOrbs = new WeakHashMap<Entity, List<RarityOrb>>();
    private static final Random random = new Random();
    private static final int MAX_TRAIL_LENGTH = 48;
    private static final int INTERP_STEPS = 6;
    private static final float TRAIL_HALF_WIDTH = 0.018f;
    private static final double TRAIL_OFFSET_Y = 0.05;
    private static final double BEAM_HEIGHT = 2.8;
    private static final double BEAM_BASE_RADIUS = 0.03;
    private static final double BEAM_TOP_RADIUS = 0.009;
    private static final int BEAM_RADIAL_SEGMENTS = 32;
    private static final float BEAM_CORE_ALPHA_BASE = 0.7f;
    private static final float BEAM_CORE_ALPHA_TOP = 0.12f;
    private static final double AURA_RADIUS_MULT = 1.6;
    private static final float AURA_ALPHA = 0.14f;
    private static final int RIBBON_COUNT = 3;
    private static final float RIBBON_SPIN_RATE = -4.0f;
    private static final int RIBBON_VERTICAL_STEPS = 64;
    private static final double RIBBON_OUTER_ANGULAR_WIDTH = 0.08;
    private static final double RIBBON_OUTER_BASE_MULT = 2.0;
    private static final double RIBBON_OUTER_TOP_MULT = 3.8;
    private static final float RIBBON_OUTER_ALPHA = 0.8f;
    private static final double RIBBON_INNER_ANGULAR_WIDTH = 0.04;
    private static final double RIBBON_INNER_BASE_MULT = 1.8;
    private static final double RIBBON_INNER_TOP_MULT = 3.6;
    private static final float RIBBON_INNER_ALPHA = 1.0f;
    private static final double SHIMMER_SPEED = 0.0035;
    private static final double BASE_FOG_RADIUS = 0.5;
    private static final float BASE_FOG_CENTER_ALPHA = 0.25f;
    private static final float BASE_FOG_EDGE_ALPHA = 0.02f;
    private static final int FOG_SEGMENTS = 36;
    private static final long FOG_PULSE_DURATION_MS = 2500L;
    private static final double FOG_PULSE_MAX_RADIUS = 1.0;
    private static final double FOG_PULSE_MIN_RADIUS = 0.4;
    private static final float FOG_PULSE_MAX_CENTER_ALPHA = 0.35f;
    private static final int MOTES_PER_BEAM = 20;
    private static final double MOTE_MIN = 0.008;
    private static final double MOTE_MAX = 0.015;
    private static final int MOTE_SLICES = 48;
    private static final int MOTE_STACKS = 32;

    @SubscribeEvent
    public static void onRenderWorldLast(RenderWorldLastEvent event) {
        Vector3d baseWorld;
        ItemStack stack;
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71441_e == null || mc.field_71439_g == null) {
            return;
        }
        float pt = event.getPartialTicks();
        MatrixStack ms = event.getMatrixStack();
        Matrix4f mat = ms.func_227866_c_().func_227870_a_();
        Vector3d camPos = mc.field_71460_t.func_215316_n().func_216785_c();
        Vector3d camLook = Vector3d.func_189986_a((float)mc.field_71460_t.func_215316_n().func_216777_e(), (float)mc.field_71460_t.func_215316_n().func_216778_f()).func_72432_b();
        RenderSystem.pushMatrix();
        RenderSystem.disableTexture();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.blendFunc((int)770, (int)1);
        RenderSystem.depthMask((boolean)false);
        RenderSystem.shadeModel((int)7425);
        RenderSystem.disableCull();
        RenderSystem.disableDepthTest();
        BufferBuilder trailBuf = Tessellator.func_178181_a().func_178180_c();
        trailBuf.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        ArrayList<ItemEntity> beamCandidates = new ArrayList<ItemEntity>();
        for (Entity ent : mc.field_71441_e.func_217357_a(Entity.class, mc.field_71439_g.func_174813_aQ().func_186662_g(64.0))) {
            ItemStack stack2;
            if (!(ent instanceof ItemEntity)) continue;
            ItemEntity item = (ItemEntity)ent;
            if (item.field_70128_L || !item.func_70089_S() || (stack2 = item.func_92059_d()) == null || stack2.func_77953_t() == Rarity.COMMON) continue;
            Vector3d pos = RarityTrailRenderer.interpolateEntity((Entity)item, pt);
            Deque trail = trails.computeIfAbsent((Entity)item, k -> new ArrayDeque());
            RarityTrailRenderer.addTrailPoint(trail, pos, 48);
            if (trail.size() >= 2) {
                RarityTrailRenderer.renderTrail(mat, trailBuf, trail, camPos, camLook, 0.018f, RarityTrailRenderer.getRarityColorSoft(stack2));
            }
            if (!item.func_233570_aj_()) continue;
            beamCandidates.add(item);
            RarityTrailRenderer.ensureOrbs(item);
        }
        Tessellator.func_178181_a().func_78381_a();
        RenderSystem.enableDepthTest();
        BufferBuilder beamBuf = Tessellator.func_178181_a().func_178180_c();
        beamBuf.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        long currentTime = System.currentTimeMillis();
        for (ItemEntity item : beamCandidates) {
            stack = item.func_92059_d();
            if (stack == null) continue;
            float[] color = RarityTrailRenderer.getRarityColorSoft(stack);
            baseWorld = RarityTrailRenderer.interpolateEntity((Entity)item, pt);
            Vector3d local = baseWorld.func_178788_d(camPos);
            RarityTrailRenderer.drawRarityShadowDisc(beamBuf, mat, local, color, 0.5, 0.25f, 0.02f);
            float pulseProgress = (float)(currentTime % 2500L) / 2500.0f;
            double dynamicRadius = MathHelper.func_219803_d((double)pulseProgress, (double)0.4, (double)1.0);
            float dynamicCenterAlpha = (float)(1.0 - Math.pow(pulseProgress, 4.0)) * 0.35f;
            float dynamicEdgeAlpha = 0.0f;
            RarityTrailRenderer.drawRarityShadowDisc(beamBuf, mat, local, color, dynamicRadius, dynamicCenterAlpha, dynamicEdgeAlpha);
            RarityTrailRenderer.drawTaperedCylinder(beamBuf, mat, local, color, 2.8, 0.03, 0.009, 32, 0.7f, 0.12f, false);
            RarityTrailRenderer.drawTaperedCylinder(beamBuf, mat, local, color, 2.8, 0.048, 0.0144, 32, 0.14f, 0.07f, true);
            RarityTrailRenderer.drawSpiralingRibbons(beamBuf, mat, local, color, 2.8, 0.06, 0.034199999999999994, 0.08, 0.8f, color);
            RarityTrailRenderer.drawSpiralingRibbons(beamBuf, mat, local, color, 2.8, 0.054, 0.0324, 0.04, 1.0f, color);
        }
        Tessellator.func_178181_a().func_78381_a();
        RenderSystem.depthMask((boolean)true);
        for (ItemEntity item : beamCandidates) {
            stack = item.func_92059_d();
            if (stack == null) continue;
            float[] rarityColor = RarityTrailRenderer.getRarityColorSoft(stack);
            baseWorld = RarityTrailRenderer.interpolateEntity((Entity)item, pt);
            List<RarityOrb> orbs = beamOrbs.get(item);
            if (orbs == null) continue;
            ArrayList<RarityOrb> aliveOrbs = new ArrayList<RarityOrb>();
            for (RarityOrb orb : orbs) {
                float alpha = orb.getAlpha();
                if (alpha <= 0.005f) continue;
                aliveOrbs.add(orb);
                Vector3d localPos = orb.getDynamicLocalPosition(pt, 2.8, 0.03);
                Vector3d worldPos = baseWorld.func_178787_e(localPos);
                Vector3d rel = worldPos.func_178788_d(camPos);
                float coreAlpha = alpha * 1.0f;
                float shellAlpha = alpha * 0.45f;
                RarityTrailRenderer.drawSphere(mat, rel, (double)orb.size * 0.4, new float[]{1.0f, 1.0f, 1.0f}, coreAlpha, 48, 32, 3.0f);
                RarityTrailRenderer.drawSphere(mat, rel, (double)orb.size * 1.0, rarityColor, shellAlpha, 48, 32, 1.5f);
            }
            while (aliveOrbs.size() < 20) {
                float size = (float)(0.008 + random.nextDouble() * 0.006999999999999999);
                float alpha = 0.35f + (float)(random.nextDouble() * (double)0.35f);
                aliveOrbs.add(new RarityOrb(size, alpha));
            }
            beamOrbs.put((Entity)item, aliveOrbs);
        }
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableTexture();
        RenderSystem.disableBlend();
        RenderSystem.enableCull();
        RenderSystem.shadeModel((int)7424);
        RenderSystem.popMatrix();
        trails.keySet().removeIf(k -> k == null || !k.func_70089_S() || k.field_70128_L);
        beamOrbs.keySet().removeIf(k -> k == null || !k.func_70089_S() || k.field_70128_L);
    }

    private static void ensureOrbs(ItemEntity item) {
        beamOrbs.computeIfAbsent((Entity)item, k -> {
            ArrayList<RarityOrb> list = new ArrayList<RarityOrb>();
            for (int i = 0; i < 20; ++i) {
                float size = (float)(0.008 + random.nextDouble() * 0.006999999999999999);
                float alpha = 0.35f + (float)(random.nextDouble() * (double)0.35f);
                list.add(new RarityOrb(size, alpha));
            }
            return list;
        });
    }

    private static void drawSpiralingRibbons(BufferBuilder buf, Matrix4f mat, Vector3d base, float[] rarityColor, double height, double baseR, double topR, double angularHalfWidth, float alpha, float[] drawColor) {
        double time = (double)System.currentTimeMillis() / 1000.0 * 0.4;
        float colorBoost = (drawColor[0] * 0.3f + drawColor[1] * 0.5f + drawColor[2] * 0.2f) * 1.5f;
        float r_draw = Math.min(1.0f, drawColor[0] + colorBoost * 0.5f);
        float g_draw = Math.min(1.0f, drawColor[1] + colorBoost * 0.4f);
        float b_draw = Math.min(1.0f, drawColor[2] + colorBoost * 0.3f);
        for (int r = 0; r < 3; ++r) {
            double rOffset = (double)r * Math.PI * 2.0 / 3.0 + time;
            for (int i_v = 0; i_v < 64; ++i_v) {
                double y_v0 = base.field_72448_b + (double)i_v / 64.0 * height;
                double y_v1 = base.field_72448_b + (double)(i_v + 1) / 64.0 * height;
                double vProgress0 = (y_v0 - base.field_72448_b) / height;
                double vProgress1 = (y_v1 - base.field_72448_b) / height;
                double currentR0 = MathHelper.func_219803_d((double)vProgress0, (double)baseR, (double)topR);
                double currentR1 = MathHelper.func_219803_d((double)vProgress1, (double)baseR, (double)topR);
                double warpAmplitude = 0.02;
                double warpFrequency = 15.0;
                double wobble0 = Math.sin(time * 3.0 + vProgress0 * warpFrequency) * warpAmplitude;
                double wobble1 = Math.sin(time * 3.0 + vProgress1 * warpFrequency) * warpAmplitude;
                currentR0 += wobble0;
                currentR1 += wobble1;
                double a_v0 = -4.0 * (y_v0 - base.field_72448_b) + rOffset;
                double a_v1 = -4.0 * (y_v1 - base.field_72448_b) + rOffset;
                float fadeIn = (float)MathHelper.func_151237_a((double)(vProgress0 * 10.0), (double)0.0, (double)1.0);
                float fadeOut = (float)MathHelper.func_151237_a((double)((1.0 - vProgress0) * 10.0), (double)0.0, (double)1.0);
                float alpha_v0 = alpha * fadeIn * fadeOut;
                fadeIn = (float)MathHelper.func_151237_a((double)(vProgress1 * 10.0), (double)0.0, (double)1.0);
                fadeOut = (float)MathHelper.func_151237_a((double)((1.0 - vProgress1) * 10.0), (double)0.0, (double)1.0);
                float alpha_v1 = alpha * fadeIn * fadeOut;
                float alphaMid = MathHelper.func_219799_g((float)0.5f, (float)alpha_v0, (float)alpha_v1);
                double x_v00 = base.field_72450_a + Math.cos(a_v0 - angularHalfWidth) * currentR0;
                double z_v00 = base.field_72449_c + Math.sin(a_v0 - angularHalfWidth) * currentR0;
                double x_v10 = base.field_72450_a + Math.cos(a_v1 - angularHalfWidth) * currentR1;
                double z_v10 = base.field_72449_c + Math.sin(a_v1 - angularHalfWidth) * currentR1;
                double x_v11 = base.field_72450_a + Math.cos(a_v1 + angularHalfWidth) * currentR1;
                double z_v11 = base.field_72449_c + Math.sin(a_v1 + angularHalfWidth) * currentR1;
                double x_v01 = base.field_72450_a + Math.cos(a_v0 + angularHalfWidth) * currentR0;
                double z_v01 = base.field_72449_c + Math.sin(a_v0 + angularHalfWidth) * currentR0;
                buf.func_227888_a_(mat, (float)x_v00, (float)y_v0, (float)z_v00).func_227885_a_(r_draw, g_draw, b_draw, alphaMid).func_181675_d();
                buf.func_227888_a_(mat, (float)x_v10, (float)y_v1, (float)z_v10).func_227885_a_(r_draw, g_draw, b_draw, alphaMid).func_181675_d();
                buf.func_227888_a_(mat, (float)x_v11, (float)y_v1, (float)z_v11).func_227885_a_(r_draw, g_draw, b_draw, alphaMid).func_181675_d();
                buf.func_227888_a_(mat, (float)x_v01, (float)y_v0, (float)z_v01).func_227885_a_(r_draw, g_draw, b_draw, alphaMid).func_181675_d();
            }
        }
    }

    private static void renderTrail(Matrix4f mat, BufferBuilder buf, Deque<Vector3d> trail, Vector3d camPos, Vector3d camLook, float halfWidth, float[] color) {
        if (trail.size() < 2) {
            return;
        }
        ArrayList<Vector3d> pts = new ArrayList<Vector3d>(trail);
        ArrayList<Vector3d> smooth = new ArrayList<Vector3d>();
        for (int i = 1; i < pts.size(); ++i) {
            Vector3d a = (Vector3d)pts.get(i - 1);
            Vector3d b = (Vector3d)pts.get(i);
            for (int s = 0; s < 6; ++s) {
                smooth.add(RarityTrailRenderer.lerp(a, b, (double)s / 6.0));
            }
        }
        if (smooth.size() < 2) {
            return;
        }
        int n = smooth.size();
        for (int i = 0; i < n - 1; ++i) {
            Vector3d p0 = ((Vector3d)smooth.get(i)).func_178788_d(camPos);
            Vector3d p1 = ((Vector3d)smooth.get(i + 1)).func_178788_d(camPos);
            Vector3d dir = p1.func_178788_d(p0);
            if (dir.func_189985_c() == 0.0) continue;
            dir = dir.func_72432_b();
            Vector3d side = camLook.func_72431_c(dir).func_72432_b().func_186678_a((double)halfWidth);
            float t0 = (float)i / (float)(n - 1);
            float t1 = (float)(i + 1) / (float)(n - 1);
            float a0 = 0.28f + 0.72f * (1.0f - (float)Math.pow(t0, 0.8));
            float a1 = 0.28f + 0.72f * (1.0f - (float)Math.pow(t1, 0.8));
            buf.func_227888_a_(mat, (float)(p0.field_72450_a - side.field_72450_a), (float)(p0.field_72448_b - side.field_72448_b), (float)(p0.field_72449_c - side.field_72449_c)).func_227885_a_(color[0], color[1], color[2], a0).func_181675_d();
            buf.func_227888_a_(mat, (float)(p0.field_72450_a + side.field_72450_a), (float)(p0.field_72448_b + side.field_72448_b), (float)(p0.field_72449_c + side.field_72449_c)).func_227885_a_(color[0], color[1], color[2], a0).func_181675_d();
            buf.func_227888_a_(mat, (float)(p1.field_72450_a + side.field_72450_a), (float)(p1.field_72448_b + side.field_72448_b), (float)(p1.field_72449_c + side.field_72449_c)).func_227885_a_(color[0], color[1], color[2], a1).func_181675_d();
            buf.func_227888_a_(mat, (float)(p1.field_72450_a - side.field_72450_a), (float)(p1.field_72448_b - side.field_72448_b), (float)(p1.field_72449_c - side.field_72449_c)).func_227885_a_(color[0], color[1], color[2], a1).func_181675_d();
        }
    }

    private static float[] getRarityColorSoft(ItemStack stack) {
        Rarity r = stack.func_77953_t();
        if (r == Rarity.UNCOMMON) {
            return new float[]{0.98f, 0.78f, 0.06f};
        }
        if (r == Rarity.RARE) {
            return new float[]{0.09f, 0.66f, 1.0f};
        }
        if (r == Rarity.EPIC) {
            return new float[]{0.98f, 0.05f, 0.98f};
        }
        return new float[]{1.0f, 1.0f, 1.0f};
    }

    private static Vector3d interpolateEntity(Entity e, float pt) {
        return new Vector3d(e.field_70169_q + (e.func_226277_ct_() - e.field_70169_q) * (double)pt, e.field_70167_r + (e.func_226278_cu_() - e.field_70167_r) * (double)pt + 0.05, e.field_70166_s + (e.func_226281_cx_() - e.field_70166_s) * (double)pt);
    }

    private static void addTrailPoint(Deque<Vector3d> trail, Vector3d pos, int max) {
        trail.addFirst(pos);
        while (trail.size() > max) {
            trail.removeLast();
        }
    }

    private static Vector3d lerp(Vector3d a, Vector3d b, double t) {
        return new Vector3d(a.field_72450_a + (b.field_72450_a - a.field_72450_a) * t, a.field_72448_b + (b.field_72448_b - a.field_72448_b) * t, a.field_72449_c + (b.field_72449_c - a.field_72449_c) * t);
    }

    private static void drawRarityShadowDisc(BufferBuilder buf, Matrix4f mat, Vector3d local, float[] color, double radius, float centerAlpha, float edgeAlpha) {
        double y = local.field_72448_b - 0.03;
        for (int i = 0; i < 36; ++i) {
            double a0 = (double)i / 36.0 * Math.PI * 2.0;
            double a1 = (double)(i + 1) / 36.0 * Math.PI * 2.0;
            double x00 = local.field_72450_a;
            double z00 = local.field_72449_c;
            double x01 = local.field_72450_a;
            double z01 = local.field_72449_c;
            double x10 = local.field_72450_a + Math.cos(a0) * radius;
            double z10 = local.field_72449_c + Math.sin(a0) * radius;
            double x11 = local.field_72450_a + Math.cos(a1) * radius;
            double z11 = local.field_72449_c + Math.sin(a1) * radius;
            buf.func_227888_a_(mat, (float)x00, (float)y, (float)z00).func_227885_a_(color[0], color[1], color[2], centerAlpha).func_181675_d();
            buf.func_227888_a_(mat, (float)x10, (float)y, (float)z10).func_227885_a_(color[0], color[1], color[2], edgeAlpha).func_181675_d();
            buf.func_227888_a_(mat, (float)x11, (float)y, (float)z11).func_227885_a_(color[0], color[1], color[2], edgeAlpha).func_181675_d();
            buf.func_227888_a_(mat, (float)x01, (float)y, (float)z01).func_227885_a_(color[0], color[1], color[2], centerAlpha).func_181675_d();
        }
    }

    private static void drawTaperedCylinder(BufferBuilder buf, Matrix4f mat, Vector3d base, float[] color, double height, double baseR, double topR, int segs, float alphaBase, float alphaTop, boolean aura) {
        if (segs < 8) {
            segs = 8;
        }
        double time = (double)System.currentTimeMillis() * 0.0035;
        for (int i = 0; i < segs; ++i) {
            double a0 = (double)i / (double)segs * Math.PI * 2.0;
            double a1 = (double)(i + 1) / (double)segs * Math.PI * 2.0;
            double s0 = Math.sin(time + (double)i * 0.23) * 0.0025;
            double s1 = Math.sin(time + (double)(i + 1) * 0.23) * 0.0025;
            double x00 = base.field_72450_a + Math.cos(a0) * (baseR + s0);
            double z00 = base.field_72449_c + Math.sin(a0) * (baseR + s0);
            double x10 = base.field_72450_a + Math.cos(a0) * (topR + s0);
            double z10 = base.field_72449_c + Math.sin(a0) * (topR + s0);
            double x01 = base.field_72450_a + Math.cos(a1) * (baseR + s1);
            double z01 = base.field_72449_c + Math.sin(a1) * (baseR + s1);
            double x11 = base.field_72450_a + Math.cos(a1) * (topR + s1);
            double z11 = base.field_72449_c + Math.sin(a1) * (topR + s1);
            buf.func_227888_a_(mat, (float)x00, (float)base.field_72448_b, (float)z00).func_227885_a_(color[0], color[1], color[2], alphaBase).func_181675_d();
            buf.func_227888_a_(mat, (float)x10, (float)(base.field_72448_b + height), (float)z10).func_227885_a_(color[0], color[1], color[2], alphaTop).func_181675_d();
            buf.func_227888_a_(mat, (float)x11, (float)(base.field_72448_b + height), (float)z11).func_227885_a_(color[0], color[1], color[2], alphaTop).func_181675_d();
            buf.func_227888_a_(mat, (float)x01, (float)base.field_72448_b, (float)z01).func_227885_a_(color[0], color[1], color[2], alphaBase).func_181675_d();
        }
    }

    private static void drawSphere(Matrix4f mat, Vector3d rel, double r, float[] color, float alpha, int slices, int stacks, float boost) {
        BufferBuilder b = Tessellator.func_178181_a().func_178180_c();
        float rr = Math.min(1.0f, color[0] * boost);
        float gg = Math.min(1.0f, color[1] * boost);
        float bb = Math.min(1.0f, color[2] * boost);
        for (int i = 0; i < stacks; ++i) {
            double lat0 = Math.PI * (-0.5 + (double)i / (double)stacks);
            double z0 = Math.sin(lat0);
            double zr0 = Math.cos(lat0);
            double lat1 = Math.PI * (-0.5 + (double)(i + 1) / (double)stacks);
            double z1 = Math.sin(lat1);
            double zr1 = Math.cos(lat1);
            b.func_181668_a(5, DefaultVertexFormats.field_181706_f);
            for (int j = 0; j <= slices; ++j) {
                double lng = Math.PI * 2 * (double)j / (double)slices;
                double x = Math.cos(lng);
                double y = Math.sin(lng);
                float vx0 = (float)(rel.field_72450_a + r * x * zr0);
                float vy0 = (float)(rel.field_72448_b + r * y * zr0);
                float vz0 = (float)(rel.field_72449_c + r * z0);
                float vx1 = (float)(rel.field_72450_a + r * x * zr1);
                float vy1 = (float)(rel.field_72448_b + r * y * zr1);
                float vz1 = (float)(rel.field_72449_c + r * z1);
                b.func_227888_a_(mat, vx0, vy0, vz0).func_227885_a_(rr, gg, bb, alpha).func_181675_d();
                b.func_227888_a_(mat, vx1, vy1, vz1).func_227885_a_(rr, gg, bb, alpha * 0.7f).func_181675_d();
            }
            Tessellator.func_178181_a().func_78381_a();
        }
    }

    static /* synthetic */ Random access$000() {
        return random;
    }

    private static class RarityOrb {
        public final long creationTime = System.currentTimeMillis();
        public final float uniqueSeed = RarityTrailRenderer.access$000().nextFloat() * 1000.0f;
        public final float lifespanSeconds = 3.0f + RarityTrailRenderer.access$000().nextFloat() * 3.0f;
        public final float size;
        public final float baseAlpha;

        RarityOrb(float size, float baseAlpha) {
            this.size = size;
            this.baseAlpha = baseAlpha;
        }

        public Vector3d getDynamicLocalPosition(float partialTicks, double beamHeight, double baseRadius) {
            float timeElapsedSec = (float)(System.currentTimeMillis() - this.creationTime) / 1000.0f;
            float timeOffset = timeElapsedSec + this.uniqueSeed;
            float lifeProgress = timeElapsedSec / this.lifespanSeconds;
            if (lifeProgress >= 1.0f) {
                return new Vector3d(0.0, beamHeight * 2.0, 0.0);
            }
            float baseOrbRadius = 2.0f;
            float radius = (float)baseRadius * (baseOrbRadius + (float)Math.sin(timeOffset * 0.15f) * 0.4f);
            float xRot = MathHelper.func_76134_b((float)(timeOffset * 0.5f)) * radius;
            float zRot = MathHelper.func_76126_a((float)(timeOffset * 0.5f)) * radius;
            double startY = 0.0;
            double riseDistance = beamHeight * 0.5 * (double)lifeProgress;
            double yWave = Math.sin(timeOffset * 1.5f + this.uniqueSeed * 0.5f) * 0.05;
            double yPos = startY + riseDistance + yWave;
            float jitter = (float)Math.sin(timeOffset * 5.0f + this.uniqueSeed) * 0.01f;
            float driftX = (float)Math.sin(timeOffset * 0.2f + this.uniqueSeed * 0.2f) * 0.03f;
            float driftZ = (float)Math.cos(timeOffset * 0.2f + this.uniqueSeed * 0.2f) * 0.03f;
            return new Vector3d((double)(xRot + jitter + driftX), yPos, (double)(zRot + jitter + driftZ));
        }

        public float getAlpha() {
            float timeElapsedSec = (float)(System.currentTimeMillis() - this.creationTime) / 1000.0f;
            float lifeProgress = timeElapsedSec / this.lifespanSeconds;
            if (lifeProgress >= 1.0f) {
                return 0.0f;
            }
            float alpha = this.baseAlpha;
            if (lifeProgress < 0.1f) {
                alpha *= lifeProgress * 10.0f;
            } else if (lifeProgress > 0.8f) {
                alpha *= (1.0f - lifeProgress) * 5.0f;
            }
            return alpha;
        }
    }
}

