/*
 * Decompiled with CFR 0.152.
 */
package com.fallenmeteor67.itemtrail.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class SpawnerHighlight {
    private static final Minecraft MC = Minecraft.func_71410_x();
    private static final List<Trail> TRAILS = new ArrayList<Trail>();
    private static final int BEZIER_SEGS = 12;

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (SpawnerHighlight.MC.field_71441_e == null || SpawnerHighlight.MC.field_71439_g == null) {
            return;
        }
        Iterator<Trail> it = TRAILS.iterator();
        while (it.hasNext()) {
            Trail t = it.next();
            ++t.age;
            if (t.age > t.lifespan) {
                it.remove();
                continue;
            }
            Entity mob = SpawnerHighlight.getEntityByUUID(t.mobId);
            if (mob == null) continue;
            SpawnerHighlight.buildArchPoints(t, t.spawnerPos, mob);
        }
    }

    public static void addMobTrail(UUID mobId, BlockPos spawnerPos) {
        Trail t = new Trail();
        t.mobId = mobId;
        t.spawnerPos = spawnerPos;
        t.age = 0;
        t.lifespan = 40;
        TRAILS.add(t);
    }

    @SubscribeEvent
    public static void onRenderWorldLast(RenderWorldLastEvent event) {
        if (SpawnerHighlight.MC.field_71441_e == null || SpawnerHighlight.MC.field_71439_g == null) {
            return;
        }
        MatrixStack stack = event.getMatrixStack();
        Matrix4f matrix = stack.func_227866_c_().func_227870_a_();
        Vector3d camPos = SpawnerHighlight.MC.field_71460_t.func_215316_n().func_216785_c();
        RenderSystem.pushMatrix();
        RenderSystem.enableBlend();
        RenderSystem.disableTexture();
        RenderSystem.blendFunc((int)770, (int)1);
        BufferBuilder buf = Tessellator.func_178181_a().func_178180_c();
        for (Trail t : TRAILS) {
            float alpha = 1.0f - (float)t.age / (float)t.lifespan;
            SpawnerHighlight.renderRibbon(matrix, buf, t.points, camPos, 0.08f, alpha);
        }
        RenderSystem.enableTexture();
        RenderSystem.disableBlend();
        RenderSystem.popMatrix();
    }

    private static void buildArchPoints(Trail t, BlockPos spawnerPos, Entity mob) {
        Vector3d start = new Vector3d((double)spawnerPos.func_177958_n() + 0.5, (double)spawnerPos.func_177956_o() + 2.0, (double)spawnerPos.func_177952_p() + 0.5);
        Vector3d end = mob.func_213303_ch().func_72441_c(0.0, (double)mob.func_213302_cg() * 0.5, 0.0);
        t.points.clear();
        for (int i = 0; i <= 12; ++i) {
            double u = (double)i / 12.0;
            double x = start.field_72450_a + (end.field_72450_a - start.field_72450_a) * u;
            double z = start.field_72449_c + (end.field_72449_c - start.field_72449_c) * u;
            double peakHeight = Math.max(1.0, start.field_72448_b - end.field_72448_b + 1.5);
            double y = start.field_72448_b + peakHeight * 4.0 * u * (1.0 - u);
            t.points.add(new Vector3d(x, y, z));
        }
    }

    private static void renderRibbon(Matrix4f matrix, BufferBuilder buf, Deque<Vector3d> trail, Vector3d camPos, float width, float alpha) {
        if (trail.size() < 2) {
            return;
        }
        ArrayList<Vector3d> pts = new ArrayList<Vector3d>(trail);
        for (int i = 0; i < pts.size() - 1; ++i) {
            Vector3d p0 = ((Vector3d)pts.get(i)).func_178788_d(camPos);
            Vector3d p1 = ((Vector3d)pts.get(i + 1)).func_178788_d(camPos);
            Vector3d dir = p1.func_178788_d(p0);
            if (dir.func_189985_c() == 0.0) continue;
            dir = dir.func_72432_b();
            Vector3d side = dir.func_72431_c(new Vector3d(0.0, 1.0, 0.0)).func_72432_b();
            float taperFactor = 1.0f - (float)i / (float)pts.size();
            Vector3d offset = side.func_186678_a((double)(width * taperFactor));
            buf.func_227888_a_(matrix, (float)(p0.field_72450_a - offset.field_72450_a), (float)(p0.field_72448_b - offset.field_72448_b), (float)(p0.field_72449_c - offset.field_72449_c)).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
            buf.func_227888_a_(matrix, (float)(p0.field_72450_a + offset.field_72450_a), (float)(p0.field_72448_b + offset.field_72448_b), (float)(p0.field_72449_c + offset.field_72449_c)).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
            buf.func_227888_a_(matrix, (float)(p1.field_72450_a + offset.field_72450_a), (float)(p1.field_72448_b + offset.field_72448_b), (float)(p1.field_72449_c + offset.field_72449_c)).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
            buf.func_227888_a_(matrix, (float)(p1.field_72450_a - offset.field_72450_a), (float)(p1.field_72448_b - offset.field_72448_b), (float)(p1.field_72449_c - offset.field_72449_c)).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
            Vector3d outerOffset = side.func_186678_a((double)(width * 1.6f * taperFactor));
            buf.func_227888_a_(matrix, (float)(p0.field_72450_a - outerOffset.field_72450_a), (float)(p0.field_72448_b - outerOffset.field_72448_b), (float)(p0.field_72449_c - outerOffset.field_72449_c)).func_227885_a_(0.8f, 0.0f, 0.0f, alpha * 0.5f).func_181675_d();
            buf.func_227888_a_(matrix, (float)(p0.field_72450_a + outerOffset.field_72450_a), (float)(p0.field_72448_b + outerOffset.field_72448_b), (float)(p0.field_72449_c + outerOffset.field_72449_c)).func_227885_a_(0.8f, 0.0f, 0.0f, alpha * 0.5f).func_181675_d();
            buf.func_227888_a_(matrix, (float)(p1.field_72450_a + outerOffset.field_72450_a), (float)(p1.field_72448_b + outerOffset.field_72448_b), (float)(p1.field_72449_c + outerOffset.field_72449_c)).func_227885_a_(0.8f, 0.0f, 0.0f, alpha * 0.5f).func_181675_d();
            buf.func_227888_a_(matrix, (float)(p1.field_72450_a - outerOffset.field_72450_a), (float)(p1.field_72448_b - outerOffset.field_72448_b), (float)(p1.field_72449_c - outerOffset.field_72449_c)).func_227885_a_(0.8f, 0.0f, 0.0f, alpha * 0.5f).func_181675_d();
        }
        Tessellator.func_178181_a().func_78381_a();
    }

    private static Entity getEntityByUUID(UUID uuid) {
        ClientWorld world = SpawnerHighlight.MC.field_71441_e;
        if (world == null) {
            return null;
        }
        for (Entity entity : world.func_217416_b()) {
            if (!entity.func_110124_au().equals(uuid)) continue;
            return entity;
        }
        return null;
    }

    private static class Trail {
        public UUID mobId;
        public BlockPos spawnerPos;
        public Deque<Vector3d> points = new ArrayDeque<Vector3d>();
        public int age = 0;
        public int lifespan = 40;

        private Trail() {
        }
    }
}

