/*
 * Decompiled with CFR 0.152.
 */
package com.fallenmeteor67.itemtrail.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.Items;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class SpawnerParticles {
    private static final int MAX_ORBS = 24;
    private static final int RANGE = 6;
    private static final int SPAWN_TICK_INTERVAL = 5;
    private static final double LOD_FULL_DIST = 10.0;
    private static final double LOD_MED_DIST = 30.0;
    private static final SphereMesh SPHERE_FULL = new SphereMesh(40, 40);
    private static final SphereMesh SPHERE_MED = new SphereMesh(24, 24);
    private static final SphereMesh SPHERE_LOW = new SphereMesh(12, 12);
    private static final double REPULSION_RADIUS = 0.9;
    private static final double REPULSION_STRENGTH = 0.004;
    private static final List<Orb> ORBS = new ArrayList<Orb>();
    private static final Random RANDOM = new Random();
    private static int tickCounter = 0;

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71441_e == null || mc.field_71439_g == null) {
            return;
        }
        ClientWorld world = mc.field_71441_e;
        BlockPos playerPos = mc.field_71439_g.func_233580_cy_();
        if (++tickCounter % 5 == 0 && ORBS.size() < 24) {
            block0: for (int dx = -6; dx <= 6; ++dx) {
                for (int dy = -6; dy <= 6; ++dy) {
                    for (int dz = -6; dz <= 6; ++dz) {
                        if (ORBS.size() >= 24) break block0;
                        BlockPos pos = playerPos.func_177982_a(dx, dy, dz);
                        BlockState state = world.func_180495_p(pos);
                        if (state.func_177230_c() != Blocks.field_150474_ac || !(RANDOM.nextFloat() < 0.2f)) continue;
                        SpawnerParticles.spawnOrb(world, pos);
                    }
                }
            }
        }
        for (ItemEntity item : world.func_217357_a(ItemEntity.class, mc.field_71439_g.func_174813_aQ().func_186662_g(12.0))) {
            if (item.func_92059_d().func_77973_b() != Items.field_221671_bX || !(RANDOM.nextFloat() < 0.25f) || ORBS.size() >= 30) continue;
            SpawnerParticles.spawnTrailOrb(item.func_213303_ch());
        }
        for (int i = ORBS.size() - 1; i >= 0; --i) {
            Orb orb = ORBS.get(i);
            ++orb.age;
            if (orb.fadingIn) {
                orb.alpha += 0.03f;
                if (orb.alpha >= 1.0f || orb.age > 20) {
                    orb.fadingIn = false;
                }
            } else if (orb.age > orb.lifespan - 20) {
                orb.alpha -= 0.03f;
            }
            orb.phase += 0.02 + RANDOM.nextDouble() * 0.015;
            double swirlX = Math.cos(orb.phase) * 0.003;
            double swirlY = Math.sin(orb.phase * 0.6) * 0.002;
            double swirlZ = Math.sin(orb.phase) * 0.003;
            double nx = orb.motion.field_72450_a + swirlX;
            double ny = orb.motion.field_72448_b + swirlY;
            double nz = orb.motion.field_72449_c + swirlZ;
            double repX = 0.0;
            double repY = 0.0;
            double repZ = 0.0;
            for (int j = 0; j < ORBS.size(); ++j) {
                if (j == i) continue;
                Orb other = ORBS.get(j);
                double dx = orb.pos.field_72450_a - other.pos.field_72450_a;
                double dy = orb.pos.field_72448_b - other.pos.field_72448_b;
                double dz = orb.pos.field_72449_c - other.pos.field_72449_c;
                double d2 = dx * dx + dy * dy + dz * dz;
                if (!(d2 > 0.0) || !(d2 < 0.81)) continue;
                double d = Math.sqrt(d2);
                double inv = (0.9 - d) / 0.9;
                repX += dx / d * inv * 0.004;
                repY += dy / d * inv * 0.004;
                repZ += dz / d * inv * 0.004;
            }
            orb.pos = orb.pos.func_72441_c(nx + repX, ny + repY, nz + repZ);
            if (!(orb.alpha <= 0.0f) && orb.age <= orb.lifespan && !(orb.pos.field_72448_b - orb.baseY > 3.5)) continue;
            ORBS.remove(i);
        }
    }

    private static void spawnOrb(ClientWorld world, BlockPos pos) {
        int count = 1 + RANDOM.nextInt(3);
        for (int i = 0; i < count; ++i) {
            Vector3d base = new Vector3d((double)pos.func_177958_n() + 0.5 + (RANDOM.nextDouble() - 0.5) * 0.5, (double)pos.func_177956_o() + 0.1 + RANDOM.nextDouble() * 0.15, (double)pos.func_177952_p() + 0.5 + (RANDOM.nextDouble() - 0.5) * 0.5);
            double upward = 0.015 + RANDOM.nextDouble() * 0.02;
            double horizontal = 3.0E-4 + RANDOM.nextDouble() * 0.001;
            Vector3d motion = new Vector3d((RANDOM.nextDouble() - 0.5) * horizontal, upward, (RANDOM.nextDouble() - 0.5) * horizontal);
            float size = 0.05f + RANDOM.nextFloat() * 0.03f;
            float[] color = new float[]{0.08f, 0.0f, 0.0f};
            float brightness = 1.3f + RANDOM.nextFloat() * 0.7f;
            int lifespan = 140 + RANDOM.nextInt(60);
            ORBS.add(new Orb(base, motion, size, color, true, brightness, lifespan));
        }
    }

    private static void spawnTrailOrb(Vector3d pos) {
        Vector3d offset = new Vector3d((RANDOM.nextDouble() - 0.5) * 0.1, (RANDOM.nextDouble() - 0.5) * 0.1, (RANDOM.nextDouble() - 0.5) * 0.1);
        Vector3d motion = new Vector3d((RANDOM.nextDouble() - 0.5) * 0.004, (RANDOM.nextDouble() - 0.5) * 0.004, (RANDOM.nextDouble() - 0.5) * 0.004);
        float[] color = new float[]{0.08f, 0.0f, 0.0f};
        float size = 0.04f + RANDOM.nextFloat() * 0.03f;
        ORBS.add(new Orb(pos.func_178787_e(offset), motion, size, color, false, 1.2f, 60 + RANDOM.nextInt(40)));
    }

    @SubscribeEvent
    public static void onRenderWorldLast(RenderWorldLastEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71441_e == null || mc.field_71439_g == null) {
            return;
        }
        MatrixStack stack = event.getMatrixStack();
        Matrix4f matrix = stack.func_227866_c_().func_227870_a_();
        Vector3d camPos = mc.field_71460_t.func_215316_n().func_216785_c();
        RenderSystem.pushMatrix();
        RenderSystem.enableBlend();
        RenderSystem.disableTexture();
        RenderSystem.blendFunc((int)770, (int)1);
        BufferBuilder b = Tessellator.func_178181_a().func_178180_c();
        for (Orb orb : ORBS) {
            Vector3d rel = orb.pos.func_178788_d(camPos);
            double dist = Math.sqrt(rel.func_72436_e(Vector3d.field_186680_a));
            SphereMesh mesh = dist <= 10.0 ? SPHERE_FULL : (dist <= 30.0 ? SPHERE_MED : SPHERE_LOW);
            float fadeWave = (float)(0.7 + 0.3 * Math.sin((double)orb.age * 0.1 + orb.pulseOffset));
            float visibleAlpha = orb.alpha * fadeWave;
            SpawnerParticles.drawSphereFromMesh(matrix, b, rel, mesh, orb.size, orb.color, visibleAlpha, orb.brightness);
            float pulseStrength = (float)(0.85 + 0.45 * Math.sin((double)System.currentTimeMillis() / 180.0 + orb.pulseOffset));
            SpawnerParticles.drawSphereFromMesh(matrix, b, rel, mesh, orb.size * 0.45f, new float[]{1.0f, 1.0f, 1.0f}, visibleAlpha * pulseStrength, 1.2f);
            SphereMesh glowMesh = mesh == SPHERE_FULL ? SPHERE_MED : SPHERE_LOW;
            SpawnerParticles.drawSphereFromMesh(matrix, b, rel, glowMesh, orb.size * 1.4f, new float[]{0.4f, 0.0f, 0.0f}, visibleAlpha * 0.25f, 1.7f);
        }
        RenderSystem.enableTexture();
        RenderSystem.disableBlend();
        RenderSystem.popMatrix();
    }

    private static void drawSphereFromMesh(Matrix4f matrix, BufferBuilder b, Vector3d rel, SphereMesh mesh, double radius, float[] color, float alpha, float brightnessBoost) {
        float rr = Math.min(1.0f, color[0] * brightnessBoost);
        float gg = Math.min(1.0f, color[1] * brightnessBoost);
        float bb = Math.min(1.0f, color[2] * brightnessBoost);
        int slices = mesh.slices;
        int stacks = mesh.stacks;
        float[] verts = mesh.vertices;
        for (int i = 0; i < stacks; ++i) {
            b.func_181668_a(5, DefaultVertexFormats.field_181706_f);
            int baseRow = i * (slices + 1) * 6;
            int nextRow = (i + 1) * (slices + 1) * 6;
            for (int j = 0; j <= slices; ++j) {
                int pairBase;
                int idx0 = pairBase = baseRow + j * 6;
                int idx1 = pairBase + 3;
                b.func_227888_a_(matrix, (float)(rel.field_72450_a + (double)verts[idx0] * radius), (float)(rel.field_72448_b + (double)verts[idx0 + 1] * radius), (float)(rel.field_72449_c + (double)verts[idx0 + 2] * radius)).func_227885_a_(rr, gg, bb, alpha).func_181675_d();
                b.func_227888_a_(matrix, (float)(rel.field_72450_a + (double)verts[idx1] * radius), (float)(rel.field_72448_b + (double)verts[idx1 + 1] * radius), (float)(rel.field_72449_c + (double)verts[idx1 + 2] * radius)).func_227885_a_(rr, gg, bb, alpha * 0.9f).func_181675_d();
            }
            Tessellator.func_178181_a().func_78381_a();
        }
    }

    private static class SphereMesh {
        final float[] vertices;
        final int slices;
        final int stacks;

        SphereMesh(int slices, int stacks) {
            this.slices = slices;
            this.stacks = stacks;
            ArrayList<Float> verts = new ArrayList<Float>((slices + 1) * stacks * 6);
            for (int i = 0; i < stacks; ++i) {
                double lat0 = Math.PI * (-0.5 + (double)i / (double)stacks);
                double z0 = Math.sin(lat0);
                double zr0 = Math.cos(lat0);
                double lat1 = Math.PI * (-0.5 + (double)(i + 1) / (double)stacks);
                double z1 = Math.sin(lat1);
                double zr1 = Math.cos(lat1);
                for (int j = 0; j <= slices; ++j) {
                    double lng = Math.PI * 2 * (double)j / (double)slices;
                    double x = Math.cos(lng);
                    double y = Math.sin(lng);
                    verts.add(Float.valueOf((float)(x * zr0)));
                    verts.add(Float.valueOf((float)(y * zr0)));
                    verts.add(Float.valueOf((float)z0));
                    verts.add(Float.valueOf((float)(x * zr1)));
                    verts.add(Float.valueOf((float)(y * zr1)));
                    verts.add(Float.valueOf((float)z1));
                }
            }
            this.vertices = new float[verts.size()];
            for (int k = 0; k < verts.size(); ++k) {
                this.vertices[k] = ((Float)verts.get(k)).floatValue();
            }
        }
    }

    private static class Orb {
        Vector3d pos;
        Vector3d motion;
        double baseY;
        float size;
        float alpha;
        float[] color;
        double phase;
        double pulseOffset;
        float brightness;
        boolean fromSpawner;
        int age;
        int lifespan;
        boolean fadingIn;

        Orb(Vector3d pos, Vector3d motion, float size, float[] color, boolean fromSpawner, float brightness, int lifespan) {
            this.pos = pos;
            this.motion = motion;
            this.baseY = pos.field_72448_b;
            this.size = size;
            this.color = color;
            this.fromSpawner = fromSpawner;
            this.brightness = brightness;
            this.lifespan = lifespan;
            this.age = 0;
            this.fadingIn = true;
            this.alpha = 0.0f;
            this.phase = RANDOM.nextDouble() * Math.PI * 2.0;
            this.pulseOffset = RANDOM.nextDouble() * Math.PI * 2.0;
        }
    }
}

