/*
 * Decompiled with CFR 0.152.
 */
package com.fallenmeteor67.itemtrail.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="itemtrail", value={Dist.CLIENT})
public class TrailRenderer {
    private static final Map<Entity, Deque<TrailPoint>> trails = new WeakHashMap<Entity, Deque<TrailPoint>>();
    private static final int MAX_POINTS = 200;
    private static final float WIDTH = 0.08f;
    private static final double MIN_DIST = 0.01;
    private static final double Y_OFFSET = 0.0;
    private static final float FADE_SPEED = 0.01f;

    @SubscribeEvent
    public static void onRenderWorldLast(RenderWorldLastEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71441_e == null || mc.field_71439_g == null) {
            return;
        }
        float partial = event.getPartialTicks();
        MatrixStack ms = event.getMatrixStack();
        Matrix4f mat = ms.func_227866_c_().func_227870_a_();
        Vector3d cam = mc.field_71460_t.func_215316_n().func_216785_c();
        RenderSystem.pushMatrix();
        RenderSystem.enableBlend();
        RenderSystem.disableTexture();
        RenderSystem.enableDepthTest();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.blendFunc((int)770, (int)771);
        RenderSystem.shadeModel((int)7425);
        RenderSystem.disableCull();
        BufferBuilder buf = Tessellator.func_178181_a().func_178180_c();
        buf.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        for (Entity e2 : mc.field_71441_e.func_217357_a(Entity.class, mc.field_71439_g.func_174813_aQ().func_186662_g(64.0))) {
            if (!(e2 instanceof ItemEntity) && !(e2 instanceof ProjectileEntity)) continue;
            Vector3d pos = TrailRenderer.interp(e2, partial);
            Deque trail = trails.computeIfAbsent(e2, x -> new ArrayDeque());
            TrailRenderer.addPoint(trail, pos);
            TrailRenderer.fadePoints(trail);
            TrailRenderer.renderRibbon(mat, buf, trail, cam);
        }
        Tessellator.func_178181_a().func_78381_a();
        RenderSystem.enableTexture();
        RenderSystem.disableBlend();
        RenderSystem.enableCull();
        RenderSystem.shadeModel((int)7424);
        RenderSystem.popMatrix();
        trails.keySet().removeIf(e -> e == null || e.field_70128_L);
    }

    private static Vector3d interp(Entity e, float partial) {
        return new Vector3d(e.field_70169_q + (e.func_226277_ct_() - e.field_70169_q) * (double)partial, e.field_70167_r + (e.func_226278_cu_() - e.field_70167_r) * (double)partial + 0.0, e.field_70166_s + (e.func_226281_cx_() - e.field_70166_s) * (double)partial);
    }

    private static void addPoint(Deque<TrailPoint> trail, Vector3d p) {
        if (trail.isEmpty() || trail.peekFirst().pos.func_72438_d(p) > 0.01) {
            trail.addFirst(new TrailPoint(p));
        }
        while (trail.size() > 200) {
            trail.removeLast();
        }
    }

    private static void fadePoints(Deque<TrailPoint> trail) {
        Iterator<TrailPoint> it = trail.iterator();
        while (it.hasNext()) {
            TrailPoint tp = it.next();
            tp.alpha -= 0.01f;
            if (!(tp.alpha <= 0.0f)) continue;
            it.remove();
        }
    }

    private static Vector3d side(Vector3d a, Vector3d b) {
        Vector3d d = b.func_178788_d(a).func_72432_b();
        return new Vector3d(-d.field_72449_c, 0.0, d.field_72450_a).func_72432_b();
    }

    private static void renderRibbon(Matrix4f mat, BufferBuilder buf, Deque<TrailPoint> trail, Vector3d cam) {
        if (trail.size() < 2) {
            return;
        }
        ArrayList<TrailPoint> pts = new ArrayList<TrailPoint>(trail);
        for (int i = 0; i < pts.size() - 1; ++i) {
            TrailPoint a = (TrailPoint)pts.get(i);
            TrailPoint b = (TrailPoint)pts.get(i + 1);
            Vector3d p0 = a.pos.func_178788_d(cam);
            Vector3d p1 = b.pos.func_178788_d(cam);
            Vector3d s = TrailRenderer.side(p0, p1);
            float t0 = (float)i / (float)(pts.size() - 1);
            float t1 = (float)(i + 1) / (float)(pts.size() - 1);
            float w0 = 0.08f * (1.0f - t0);
            float w1 = 0.08f * (1.0f - t1);
            float alpha = Math.min(a.alpha, b.alpha);
            Vector3d p0l = p0.func_178787_e(s.func_186678_a((double)w0));
            Vector3d p0r = p0.func_178788_d(s.func_186678_a((double)w0));
            Vector3d p1l = p1.func_178787_e(s.func_186678_a((double)w1));
            Vector3d p1r = p1.func_178788_d(s.func_186678_a((double)w1));
            buf.func_227888_a_(mat, (float)p0l.field_72450_a, (float)p0l.field_72448_b, (float)p0l.field_72449_c).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
            buf.func_227888_a_(mat, (float)p0r.field_72450_a, (float)p0r.field_72448_b, (float)p0r.field_72449_c).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
            buf.func_227888_a_(mat, (float)p1r.field_72450_a, (float)p1r.field_72448_b, (float)p1r.field_72449_c).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
            buf.func_227888_a_(mat, (float)p1l.field_72450_a, (float)p1l.field_72448_b, (float)p1l.field_72449_c).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
        }
    }

    private static class TrailPoint {
        Vector3d pos;
        float alpha;

        TrailPoint(Vector3d pos) {
            this.pos = pos;
            this.alpha = 1.0f;
        }
    }
}

