/*
 * Decompiled with CFR 0.152.
 */
package potatowolfie.silly_goose.entity.goose.goals;

import java.util.EnumSet;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1352;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3486;
import net.minecraft.class_5134;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import potatowolfie.silly_goose.advancement.HitandRunAdvancementHandler;
import potatowolfie.silly_goose.advancement.HonkandRunAdvancementHandler;
import potatowolfie.silly_goose.damage.SillyGooseDamageTypes;
import potatowolfie.silly_goose.entity.goose.GooseEntity;
import potatowolfie.silly_goose.sound.SillyGooseSounds;

public class GooseRevengeGoal
extends class_1352 {
    private final GooseEntity goose;
    private class_1657 targetPlayer;
    private boolean isRunningAway;
    private double runAwayDistance;
    private int hitCount = 0;
    private int targetHits;
    private class_243 targetPos = null;
    private int navigationTimeout = 0;
    private int stuckCheckTimer = 0;
    private class_2338 lastPos = null;
    private boolean useDirectSwimming = false;
    private int waterSearchCooldown = 0;
    private int waterExitTimer = 0;
    private static final int WATER_EXIT_BOOST_INTERVAL = 10;
    private static final double WATER_EXIT_BOOST_STRENGTH = 0.3;
    private static final double DETECTION_RADIUS = 32.0;
    private static final double ATTACK_RANGE = 16.0;
    private static final double MIN_RUN_DISTANCE = 8.0;
    private static final double MAX_RUN_DISTANCE = 16.0;
    private static final double RUN_SPEED_MULTIPLIER = 1.5;
    private static final double SWIM_SPEED_MULTIPLIER = 1.5;
    private static final int WATER_SEARCH_INTERVAL = 20;
    private static final int MAX_NAVIGATION_TIMEOUT = 100;
    private static final int STUCK_CHECK_INTERVAL = 20;
    private static final double STUCK_THRESHOLD = 1.0;
    private int attackCooldown = 0;
    private static final int ATTACK_COOLDOWN_TICKS = 7;

    public GooseRevengeGoal(GooseEntity goose) {
        this.goose = goose;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
    }

    public boolean method_6264() {
        if (this.goose.method_6109()) {
            return false;
        }
        if (!this.goose.hasRevengeTarget()) {
            return false;
        }
        class_1657 revengeTarget = this.goose.getRevengeTargetPlayer();
        if (revengeTarget == null || !revengeTarget.method_5805() || revengeTarget.method_7325() || revengeTarget.method_68878()) {
            return false;
        }
        double distanceToPlayer = this.goose.method_5858((class_1297)revengeTarget);
        if (distanceToPlayer > 1024.0) {
            return false;
        }
        if (!this.goose.isRevengeTimerReady()) {
            return false;
        }
        if (distanceToPlayer > 256.0) {
            return false;
        }
        this.targetPlayer = revengeTarget;
        this.runAwayDistance = 8.0 + this.goose.method_59922().method_43058() * 8.0;
        this.targetHits = 2 + this.goose.method_59922().method_43048(2);
        this.hitCount = 0;
        return true;
    }

    public boolean method_6266() {
        if (this.targetPlayer == null || !this.targetPlayer.method_5805() || this.targetPlayer.method_7325() || this.targetPlayer.method_68878()) {
            return false;
        }
        if (this.isRunningAway) {
            double distanceToPlayer = this.goose.method_5858((class_1297)this.targetPlayer);
            return distanceToPlayer < this.runAwayDistance * this.runAwayDistance;
        }
        return this.hitCount < this.targetHits;
    }

    public void method_6269() {
        this.isRunningAway = false;
        this.hitCount = 0;
        this.attackCooldown = 0;
        this.updateNearestWater();
        this.goose.setInHitAndRunMode(true);
        this.waterExitTimer = 10;
    }

    public void method_6268() {
        if (this.targetPlayer == null) {
            return;
        }
        --this.waterSearchCooldown;
        if (this.waterSearchCooldown <= 0) {
            this.updateNearestWater();
            this.waterSearchCooldown = 20;
        }
        --this.stuckCheckTimer;
        if (this.stuckCheckTimer <= 0) {
            this.checkIfStuck();
            this.stuckCheckTimer = 20;
        }
        if (this.goose.method_5799()) {
            if (!this.useDirectSwimming) {
                this.useDirectSwimming = true;
                this.goose.method_5942().method_6340();
            }
        } else if (this.useDirectSwimming) {
            this.useDirectSwimming = false;
        }
        if (!this.isRunningAway) {
            if (this.useDirectSwimming) {
                class_243 playerPos = this.targetPlayer.method_73189();
                this.handleDirectSwimmingToTarget(playerPos);
            } else {
                this.goose.method_5942().method_6335((class_1297)this.targetPlayer, 1.5);
            }
            this.goose.method_5988().method_6226((class_1297)this.targetPlayer, 30.0f, 30.0f);
            if (this.attackCooldown > 0) {
                --this.attackCooldown;
            }
            if (this.attackCooldown <= 0 && this.goose.method_5858((class_1297)this.targetPlayer) <= 4.0) {
                this.goose.method_5783(SillyGooseSounds.GOOSE_ATTACK, 1.0f, 1.0f);
                int random = this.goose.method_59922().method_43048(3);
                class_1282 damageSource = new class_1282((class_6880)this.goose.method_73183().method_30349().method_30530(class_7924.field_42534).method_10223((switch (random) {
                    case 0 -> SillyGooseDamageTypes.GOOSE_BOTHER;
                    case 1 -> SillyGooseDamageTypes.GOOSE_PECK;
                    default -> SillyGooseDamageTypes.GOOSE_HONK;
                }).method_29177()).get(), (class_1297)this.goose);
                float damage = (float)this.goose.method_45325(class_5134.field_23721);
                this.targetPlayer.method_64397((class_3218)this.goose.method_73183(), damageSource, damage);
                class_1657 class_16572 = this.targetPlayer;
                if (class_16572 instanceof class_3222) {
                    class_3222 serverPlayer = (class_3222)class_16572;
                    class_1799 mainhandItem = this.goose.method_6118(class_1304.field_6173);
                    if (!mainhandItem.method_7960()) {
                        HitandRunAdvancementHandler.grantHitandRunAdvancement(serverPlayer);
                    } else {
                        HonkandRunAdvancementHandler.grantHonkandRunAdvancement(serverPlayer);
                    }
                }
                ++this.hitCount;
                this.attackCooldown = 7;
                if (this.hitCount >= this.targetHits) {
                    this.isRunningAway = true;
                    this.setupEscapeTarget();
                }
            }
        } else if (this.targetPos != null) {
            --this.navigationTimeout;
            double distanceToTarget = this.goose.method_73189().method_1022(this.targetPos);
            if (distanceToTarget < 2.0 || this.goose.method_5858((class_1297)this.targetPlayer) >= this.runAwayDistance * this.runAwayDistance) {
                this.targetPos = null;
                this.goose.method_5942().method_6340();
                this.useDirectSwimming = false;
                return;
            }
            if (this.useDirectSwimming) {
                this.handleDirectSwimming();
            } else if (this.navigationTimeout % 20 == 0 && distanceToTarget > 3.0) {
                this.goose.method_5942().method_6337(this.targetPos.field_1352, this.targetPos.field_1351, this.targetPos.field_1350, 1.5);
            }
            if (this.navigationTimeout <= 0) {
                this.setupEscapeTarget();
            }
        } else {
            this.setupEscapeTarget();
        }
        this.checkAndApplyWaterExitBoost();
    }

    public void method_6270() {
        this.targetPlayer = null;
        this.isRunningAway = false;
        this.targetPos = null;
        this.useDirectSwimming = false;
        this.hitCount = 0;
        this.goose.method_5942().method_6340();
        this.goose.setInHitAndRunMode(false);
        this.goose.resetRevengeTimer();
    }

    private void setupEscapeTarget() {
        double dz;
        if (this.targetPlayer == null) {
            return;
        }
        double dx = this.goose.method_23317() - this.targetPlayer.method_23317();
        double distance = Math.sqrt(dx * dx + (dz = this.goose.method_23321() - this.targetPlayer.method_23321()) * dz);
        if (distance < 0.1) {
            double angle = this.goose.method_59922().method_43058() * Math.PI * 2.0;
            dx = Math.cos(angle);
            dz = Math.sin(angle);
            distance = 1.0;
        }
        double escapeIncrement = this.goose.method_5799() ? 8.0 : this.runAwayDistance;
        dx = dx / distance * escapeIncrement;
        dz = dz / distance * escapeIncrement;
        double targetX = this.goose.method_23317() + dx;
        double targetZ = this.goose.method_23321() + dz;
        double targetY = this.goose.method_23318();
        class_2338 targetBlockPos = class_2338.method_49637((double)targetX, (double)targetY, (double)targetZ);
        boolean targetIsWater = this.goose.method_73183().method_8316(targetBlockPos).method_15767(class_3486.field_15517);
        if (targetIsWater || this.goose.method_5799()) {
            class_2338 checkPos = this.goose.method_5799() ? this.goose.method_24515() : targetBlockPos;
            checkPos = class_2338.method_49637((double)targetX, (double)checkPos.method_10264(), (double)targetZ);
            while (this.goose.method_73183().method_8316(checkPos).method_15767(class_3486.field_15517)) {
                targetY = (double)checkPos.method_10264() + 1.0;
                checkPos = checkPos.method_10084();
            }
        }
        this.setTarget(new class_243(targetX, targetY, targetZ));
    }

    private void checkAndApplyWaterExitBoost() {
        --this.waterExitTimer;
        if (this.waterExitTimer <= 0) {
            this.waterExitTimer = 10;
            if (this.goose.method_5799()) {
                class_2338 abovePos = this.goose.method_24515().method_10084();
                if (!this.goose.method_73183().method_8316(abovePos).method_15767(class_3486.field_15517)) {
                    boolean hasNearbyLand = false;
                    class_2338 currentPos = this.goose.method_24515();
                    for (int x = -1; x <= 1; ++x) {
                        for (int z = -1; z <= 1; ++z) {
                            boolean isLandAbove;
                            if (x == 0 && z == 0) continue;
                            class_2338 checkPos = currentPos.method_10069(x, 0, z);
                            class_2338 checkPosAbove = currentPos.method_10069(x, 1, z);
                            boolean isLand = !this.goose.method_73183().method_8316(checkPos).method_15767(class_3486.field_15517);
                            boolean bl = isLandAbove = !this.goose.method_73183().method_8316(checkPosAbove).method_15767(class_3486.field_15517);
                            if (!isLand && !isLandAbove) continue;
                            hasNearbyLand = true;
                            break;
                        }
                        if (hasNearbyLand) break;
                    }
                    if (hasNearbyLand) {
                        class_243 velocity = this.goose.method_18798();
                        this.goose.method_18800(velocity.field_1352, 0.3, velocity.field_1350);
                        this.goose.field_6037 = true;
                    }
                }
            }
        }
    }

    private void handleDirectSwimming() {
        float yawDiff;
        double targetYaw;
        if (this.targetPos == null) {
            return;
        }
        class_243 currentPos = this.goose.method_73189();
        class_243 direction = this.targetPos.method_1020(currentPos).method_1029();
        float currentYaw = this.goose.method_36454();
        for (targetYaw = Math.atan2(-direction.field_1352, direction.field_1350) * 57.29577951308232; targetYaw > 180.0; targetYaw -= 360.0) {
        }
        while (targetYaw < -180.0) {
            targetYaw += 360.0;
        }
        while (currentYaw > 180.0f) {
            currentYaw -= 360.0f;
        }
        while (currentYaw < -180.0f) {
            currentYaw += 360.0f;
        }
        for (yawDiff = (float)(targetYaw - (double)currentYaw); yawDiff > 180.0f; yawDiff -= 360.0f) {
        }
        while (yawDiff < -180.0f) {
            yawDiff += 360.0f;
        }
        float maxRotation = 15.0f;
        float yawAdjustment = Math.max(-maxRotation, Math.min(maxRotation, yawDiff));
        float newYaw = currentYaw + yawAdjustment;
        this.goose.method_36456(newYaw);
        this.goose.method_5636(newYaw);
        this.goose.method_5847(newYaw);
        if (Math.abs(yawDiff) < 45.0f) {
            double swimSpeed = 0.22499999999999998;
            class_243 velocity = this.goose.method_18798();
            this.goose.method_18800(direction.field_1352 * swimSpeed, velocity.field_1351, direction.field_1350 * swimSpeed);
            this.goose.field_6037 = true;
        } else {
            class_243 velocity = this.goose.method_18798();
            this.goose.method_18800(velocity.field_1352 * 0.5, velocity.field_1351, velocity.field_1350 * 0.5);
            this.goose.field_6037 = true;
        }
    }

    private void handleDirectSwimmingToTarget(class_243 target) {
        float yawDiff;
        double targetYaw;
        class_243 currentPos = this.goose.method_73189();
        class_243 direction = target.method_1020(currentPos).method_1029();
        float currentYaw = this.goose.method_36454();
        for (targetYaw = Math.atan2(-direction.field_1352, direction.field_1350) * 57.29577951308232; targetYaw > 180.0; targetYaw -= 360.0) {
        }
        while (targetYaw < -180.0) {
            targetYaw += 360.0;
        }
        while (currentYaw > 180.0f) {
            currentYaw -= 360.0f;
        }
        while (currentYaw < -180.0f) {
            currentYaw += 360.0f;
        }
        for (yawDiff = (float)(targetYaw - (double)currentYaw); yawDiff > 180.0f; yawDiff -= 360.0f) {
        }
        while (yawDiff < -180.0f) {
            yawDiff += 360.0f;
        }
        float maxRotation = 15.0f;
        float yawAdjustment = Math.max(-maxRotation, Math.min(maxRotation, yawDiff));
        float newYaw = currentYaw + yawAdjustment;
        this.goose.method_36456(newYaw);
        this.goose.method_5636(newYaw);
        this.goose.method_5847(newYaw);
        if (Math.abs(yawDiff) < 45.0f) {
            double swimSpeed = 0.22499999999999998;
            class_243 velocity = this.goose.method_18798();
            this.goose.method_18800(direction.field_1352 * swimSpeed, velocity.field_1351, direction.field_1350 * swimSpeed);
            this.goose.field_6037 = true;
        } else {
            class_243 velocity = this.goose.method_18798();
            this.goose.method_18800(velocity.field_1352 * 0.5, velocity.field_1351, velocity.field_1350 * 0.5);
            this.goose.field_6037 = true;
        }
    }

    private void updateNearestWater() {
        class_2338 goosePos = this.goose.method_24515();
        class_2338 nearest = null;
        double nearestDistance = Double.MAX_VALUE;
        for (class_2338 pos : class_2338.method_10097((class_2338)goosePos.method_10069(-32, -16, -32), (class_2338)goosePos.method_10069(32, 16, 32))) {
            double distance;
            if (!this.goose.method_73183().method_8316(pos).method_15767(class_3486.field_15517) || !((distance = goosePos.method_10262((class_2382)pos)) < nearestDistance)) continue;
            nearestDistance = distance;
            nearest = pos.method_10062();
        }
    }

    private void setTarget(class_243 target) {
        this.targetPos = target;
        this.navigationTimeout = 100;
        if (this.goose.method_5799()) {
            this.useDirectSwimming = true;
            this.goose.method_5942().method_6340();
        } else {
            this.useDirectSwimming = false;
            this.goose.method_5942().method_6337(target.field_1352, target.field_1351, target.field_1350, 1.5);
        }
    }

    private void checkIfStuck() {
        double distanceMoved;
        class_2338 currentPos = this.goose.method_24515();
        if (this.lastPos != null && this.targetPos != null && (distanceMoved = currentPos.method_10262((class_2382)this.lastPos)) < 1.0) {
            this.targetPos = null;
            this.goose.method_5942().method_6340();
        }
        this.lastPos = currentPos.method_10062();
    }
}

