/*
 * Decompiled with CFR 0.152.
 */
package yelf42.cropcritters.blocks;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.serialization.MapCodec;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.class_10;
import net.minecraft.class_10225;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3481;
import net.minecraft.class_3726;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import yelf42.cropcritters.blocks.MazewoodShape;

public class MazewoodBlock
extends class_2248 {
    public static final MapCodec<MazewoodBlock> CODEC = MazewoodBlock.method_54094(MazewoodBlock::new);
    public static final class_2746 UP = class_2741.field_12519;
    public static final class_2754<MazewoodShape> EAST_WALL_SHAPE = class_2754.method_11850((String)"east", MazewoodShape.class);
    public static final class_2754<MazewoodShape> NORTH_WALL_SHAPE = class_2754.method_11850((String)"north", MazewoodShape.class);
    public static final class_2754<MazewoodShape> SOUTH_WALL_SHAPE = class_2754.method_11850((String)"south", MazewoodShape.class);
    public static final class_2754<MazewoodShape> WEST_WALL_SHAPE = class_2754.method_11850((String)"west", MazewoodShape.class);
    public static final Map<class_2350, class_2754<MazewoodShape>> WALL_SHAPE_PROPERTIES_BY_DIRECTION = ImmutableMap.copyOf((Map)Maps.newEnumMap(Map.of(class_2350.field_11043, NORTH_WALL_SHAPE, class_2350.field_11034, EAST_WALL_SHAPE, class_2350.field_11035, SOUTH_WALL_SHAPE, class_2350.field_11039, WEST_WALL_SHAPE)));
    private final Function<class_2680, class_265> outlineShapeFunction;
    private final Function<class_2680, class_265> collisionShapeFunction;
    private static final Map<class_2350, class_265> WALL_SHAPES_FOR_TALL_TEST_BY_DIRECTION = class_259.method_66501((class_265)class_2248.method_66405((double)2.0, (double)16.0, (double)0.0, (double)9.0));

    public MapCodec<MazewoodBlock> method_53969() {
        return CODEC;
    }

    public MazewoodBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)UP, (Comparable)Boolean.valueOf(true))).method_11657(NORTH_WALL_SHAPE, (Comparable)((Object)MazewoodShape.NONE))).method_11657(EAST_WALL_SHAPE, (Comparable)((Object)MazewoodShape.NONE))).method_11657(SOUTH_WALL_SHAPE, (Comparable)((Object)MazewoodShape.NONE))).method_11657(WEST_WALL_SHAPE, (Comparable)((Object)MazewoodShape.NONE)));
        this.outlineShapeFunction = this.createShapeFunction(16.0f);
        this.collisionShapeFunction = this.createShapeFunction(24.0f);
    }

    private Function<class_2680, class_265> createShapeFunction(float tallHeight) {
        class_265 voxelShape = class_2248.method_66404((double)8.0, (double)0.0, (double)tallHeight);
        Map map = class_259.method_66501((class_265)class_2248.method_66396((double)8.0, (double)0.0, (double)tallHeight, (double)0.0, (double)11.0));
        return this.method_33615(state -> {
            class_265 voxelShape2 = (Boolean)state.method_11654((class_2769)UP) != false ? voxelShape : class_259.method_1073();
            for (Map.Entry<class_2350, class_2754<MazewoodShape>> entry : WALL_SHAPE_PROPERTIES_BY_DIRECTION.entrySet()) {
                voxelShape2 = class_259.method_1084((class_265)voxelShape2, (class_265)(switch ((MazewoodShape)((Object)((Object)state.method_11654((class_2769)entry.getValue())))) {
                    case MazewoodShape.NONE -> class_259.method_1073();
                    case MazewoodShape.TALL -> (class_265)map.get(entry.getKey());
                    default -> throw new MatchException(null, null);
                }));
            }
            return voxelShape2;
        });
    }

    protected class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return this.outlineShapeFunction.apply(state);
    }

    protected class_265 method_9549(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return this.collisionShapeFunction.apply(state);
    }

    protected boolean method_9516(class_2680 state, class_10 type) {
        return false;
    }

    private boolean shouldConnectTo(class_2680 state, boolean faceFullSquare, class_2350 side) {
        return state.method_26204() instanceof MazewoodBlock || !MazewoodBlock.method_9581((class_2680)state) && faceFullSquare;
    }

    public class_2680 method_9605(class_1750 ctx) {
        class_1937 worldView = ctx.method_8045();
        class_2338 blockPos = ctx.method_8037();
        class_2338 blockPos2 = blockPos.method_10095();
        class_2338 blockPos3 = blockPos.method_10078();
        class_2338 blockPos4 = blockPos.method_10072();
        class_2338 blockPos5 = blockPos.method_10067();
        class_2338 blockPos6 = blockPos.method_10084();
        class_2680 blockState = worldView.method_8320(blockPos2);
        class_2680 blockState2 = worldView.method_8320(blockPos3);
        class_2680 blockState3 = worldView.method_8320(blockPos4);
        class_2680 blockState4 = worldView.method_8320(blockPos5);
        class_2680 blockState5 = worldView.method_8320(blockPos6);
        boolean bl = this.shouldConnectTo(blockState, blockState.method_26206((class_1922)worldView, blockPos2, class_2350.field_11035), class_2350.field_11035);
        boolean bl2 = this.shouldConnectTo(blockState2, blockState2.method_26206((class_1922)worldView, blockPos3, class_2350.field_11039), class_2350.field_11039);
        boolean bl3 = this.shouldConnectTo(blockState3, blockState3.method_26206((class_1922)worldView, blockPos4, class_2350.field_11043), class_2350.field_11043);
        boolean bl4 = this.shouldConnectTo(blockState4, blockState4.method_26206((class_1922)worldView, blockPos5, class_2350.field_11034), class_2350.field_11034);
        class_2680 blockState6 = this.method_9564();
        return this.getStateWith((class_4538)worldView, blockState6, blockPos6, blockState5, bl, bl2, bl3, bl4);
    }

    protected class_2680 method_9559(class_2680 state, class_4538 world, class_10225 tickView, class_2338 pos, class_2350 direction, class_2338 neighborPos, class_2680 neighborState, class_5819 random) {
        if (!this.method_9558(state, world, pos)) {
            if (world instanceof class_1937) {
                class_1937 w = (class_1937)world;
                w.method_64310(pos, (class_2248)this, 1);
            }
            return class_2246.field_10124.method_9564();
        }
        if (direction == class_2350.field_11033) {
            return super.method_9559(state, world, tickView, pos, direction, neighborPos, neighborState, random);
        }
        return direction == class_2350.field_11036 ? this.getStateAt(world, state, neighborPos, neighborState) : this.getStateWithNeighbor(world, pos, state, neighborPos, neighborState, direction);
    }

    protected void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        world.method_8501(pos, class_2246.field_10124.method_9564());
        world.method_43276((class_6880)class_5712.field_28733, pos, class_5712.class_7397.method_43287((class_2680)state));
    }

    protected boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
        class_2680 floor = world.method_8320(pos.method_10074());
        return floor.method_26164(class_3481.field_29822) || floor.method_27852(class_2246.field_10362) || floor.method_26204() instanceof MazewoodBlock;
    }

    private static boolean isConnected(class_2680 state, class_2769<MazewoodShape> property) {
        return state.method_11654(property) != MazewoodShape.NONE;
    }

    private class_2680 getStateAt(class_4538 world, class_2680 state, class_2338 pos, class_2680 aboveState) {
        boolean bl = MazewoodBlock.isConnected(state, NORTH_WALL_SHAPE);
        boolean bl2 = MazewoodBlock.isConnected(state, EAST_WALL_SHAPE);
        boolean bl3 = MazewoodBlock.isConnected(state, SOUTH_WALL_SHAPE);
        boolean bl4 = MazewoodBlock.isConnected(state, WEST_WALL_SHAPE);
        return this.getStateWith(world, state, pos, aboveState, bl, bl2, bl3, bl4);
    }

    private class_2680 getStateWithNeighbor(class_4538 world, class_2338 pos, class_2680 state, class_2338 neighborPos, class_2680 neighborState, class_2350 direction) {
        class_2350 direction2 = direction.method_10153();
        boolean bl = direction == class_2350.field_11043 ? this.shouldConnectTo(neighborState, neighborState.method_26206((class_1922)world, neighborPos, direction2), direction2) : MazewoodBlock.isConnected(state, NORTH_WALL_SHAPE);
        boolean bl2 = direction == class_2350.field_11034 ? this.shouldConnectTo(neighborState, neighborState.method_26206((class_1922)world, neighborPos, direction2), direction2) : MazewoodBlock.isConnected(state, EAST_WALL_SHAPE);
        boolean bl3 = direction == class_2350.field_11035 ? this.shouldConnectTo(neighborState, neighborState.method_26206((class_1922)world, neighborPos, direction2), direction2) : MazewoodBlock.isConnected(state, SOUTH_WALL_SHAPE);
        boolean bl4 = direction == class_2350.field_11039 ? this.shouldConnectTo(neighborState, neighborState.method_26206((class_1922)world, neighborPos, direction2), direction2) : MazewoodBlock.isConnected(state, WEST_WALL_SHAPE);
        class_2338 blockPos = pos.method_10084();
        class_2680 blockState = world.method_8320(blockPos);
        return this.getStateWith(world, state, blockPos, blockState, bl, bl2, bl3, bl4);
    }

    private class_2680 getStateWith(class_4538 world, class_2680 state, class_2338 pos, class_2680 aboveState, boolean north, boolean east, boolean south, boolean west) {
        class_265 voxelShape = aboveState.method_26220((class_1922)world, pos).method_20538(class_2350.field_11033);
        class_2680 blockState = this.getStateWith(state, north, east, south, west, voxelShape);
        return (class_2680)blockState.method_11657((class_2769)UP, (Comparable)Boolean.valueOf(true));
    }

    private class_2680 getStateWith(class_2680 state, boolean north, boolean east, boolean south, boolean west, class_265 aboveShape) {
        return (class_2680)((class_2680)((class_2680)((class_2680)state.method_11657(NORTH_WALL_SHAPE, (Comparable)((Object)this.getMazewoodShape(north, aboveShape, WALL_SHAPES_FOR_TALL_TEST_BY_DIRECTION.get(class_2350.field_11043))))).method_11657(EAST_WALL_SHAPE, (Comparable)((Object)this.getMazewoodShape(east, aboveShape, WALL_SHAPES_FOR_TALL_TEST_BY_DIRECTION.get(class_2350.field_11034))))).method_11657(SOUTH_WALL_SHAPE, (Comparable)((Object)this.getMazewoodShape(south, aboveShape, WALL_SHAPES_FOR_TALL_TEST_BY_DIRECTION.get(class_2350.field_11035))))).method_11657(WEST_WALL_SHAPE, (Comparable)((Object)this.getMazewoodShape(west, aboveShape, WALL_SHAPES_FOR_TALL_TEST_BY_DIRECTION.get(class_2350.field_11039))));
    }

    private MazewoodShape getMazewoodShape(boolean connected, class_265 aboveShape, class_265 tallShape) {
        if (connected) {
            return MazewoodShape.TALL;
        }
        return MazewoodShape.NONE;
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{UP, NORTH_WALL_SHAPE, EAST_WALL_SHAPE, WEST_WALL_SHAPE, SOUTH_WALL_SHAPE});
    }

    protected class_2680 method_9598(class_2680 state, class_2470 rotation) {
        switch (rotation) {
            case field_11464: {
                return (class_2680)((class_2680)((class_2680)((class_2680)state.method_11657(NORTH_WALL_SHAPE, (Comparable)((Object)((MazewoodShape)((Object)state.method_11654(SOUTH_WALL_SHAPE)))))).method_11657(EAST_WALL_SHAPE, (Comparable)((Object)((MazewoodShape)((Object)state.method_11654(WEST_WALL_SHAPE)))))).method_11657(SOUTH_WALL_SHAPE, (Comparable)((Object)((MazewoodShape)((Object)state.method_11654(NORTH_WALL_SHAPE)))))).method_11657(WEST_WALL_SHAPE, (Comparable)((Object)((MazewoodShape)((Object)state.method_11654(EAST_WALL_SHAPE)))));
            }
            case field_11465: {
                return (class_2680)((class_2680)((class_2680)((class_2680)state.method_11657(NORTH_WALL_SHAPE, (Comparable)((Object)((MazewoodShape)((Object)state.method_11654(EAST_WALL_SHAPE)))))).method_11657(EAST_WALL_SHAPE, (Comparable)((Object)((MazewoodShape)((Object)state.method_11654(SOUTH_WALL_SHAPE)))))).method_11657(SOUTH_WALL_SHAPE, (Comparable)((Object)((MazewoodShape)((Object)state.method_11654(WEST_WALL_SHAPE)))))).method_11657(WEST_WALL_SHAPE, (Comparable)((Object)((MazewoodShape)((Object)state.method_11654(NORTH_WALL_SHAPE)))));
            }
            case field_11463: {
                return (class_2680)((class_2680)((class_2680)((class_2680)state.method_11657(NORTH_WALL_SHAPE, (Comparable)((Object)((MazewoodShape)((Object)state.method_11654(WEST_WALL_SHAPE)))))).method_11657(EAST_WALL_SHAPE, (Comparable)((Object)((MazewoodShape)((Object)state.method_11654(NORTH_WALL_SHAPE)))))).method_11657(SOUTH_WALL_SHAPE, (Comparable)((Object)((MazewoodShape)((Object)state.method_11654(EAST_WALL_SHAPE)))))).method_11657(WEST_WALL_SHAPE, (Comparable)((Object)((MazewoodShape)((Object)state.method_11654(SOUTH_WALL_SHAPE)))));
            }
        }
        return state;
    }

    protected class_2680 method_9569(class_2680 state, class_2415 mirror) {
        switch (mirror) {
            case field_11300: {
                return (class_2680)((class_2680)state.method_11657(NORTH_WALL_SHAPE, (Comparable)((Object)((MazewoodShape)((Object)state.method_11654(SOUTH_WALL_SHAPE)))))).method_11657(SOUTH_WALL_SHAPE, (Comparable)((Object)((MazewoodShape)((Object)state.method_11654(NORTH_WALL_SHAPE)))));
            }
            case field_11301: {
                return (class_2680)((class_2680)state.method_11657(EAST_WALL_SHAPE, (Comparable)((Object)((MazewoodShape)((Object)state.method_11654(WEST_WALL_SHAPE)))))).method_11657(WEST_WALL_SHAPE, (Comparable)((Object)((MazewoodShape)((Object)state.method_11654(EAST_WALL_SHAPE)))));
            }
        }
        return super.method_9569(state, mirror);
    }
}

