/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.backward_imitate;

import doggytalents.DoggyBlocks;
import doggytalents.DoggyItems;
import doggytalents.client.backward_imitate.DoubleDyableTint_1_21_5;
import doggytalents.client.data.DTItemModelProvider;
import doggytalents.common.block.FoodBowlBlock;
import doggytalents.common.block.crops.DogCropBlock;
import doggytalents.common.item.DoubleDyableAccessoryItem;
import doggytalents.common.item.IDyeableArmorItem;
import doggytalents.common.util.Util;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.color.item.Constant;
import net.minecraft.client.color.item.Dye;
import net.minecraft.client.color.item.ItemTintSource;
import net.minecraft.client.data.models.BlockModelGenerators;
import net.minecraft.client.data.models.ItemModelGenerators;
import net.minecraft.client.data.models.ModelProvider;
import net.minecraft.client.data.models.blockstates.MultiVariantGenerator;
import net.minecraft.client.data.models.blockstates.PropertyDispatch;
import net.minecraft.client.data.models.model.ItemModelUtils;
import net.minecraft.client.data.models.model.ModelLocationUtils;
import net.minecraft.client.data.models.model.ModelTemplate;
import net.minecraft.client.data.models.model.ModelTemplates;
import net.minecraft.client.data.models.model.TextureMapping;
import net.minecraft.client.data.models.model.TextureSlot;
import net.minecraft.client.data.models.model.TexturedModel;
import net.minecraft.client.renderer.item.ItemModel;
import net.minecraft.core.Direction;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.client.model.generators.template.ExtendedModelTemplate;
import net.neoforged.neoforge.client.model.generators.template.ExtendedModelTemplateBuilder;
import net.neoforged.neoforge.client.model.generators.template.FaceBuilder;

public class DTNModelProvider_1_21_5
extends ModelProvider {
    public static final TextureSlot BEDDING = TextureSlot.create((String)"bedding");
    public static final TextureSlot CASING = TextureSlot.create((String)"casing");
    public static final TextureSlot WATER = TextureSlot.create((String)"water");
    private static final String RENDERTYPE_CUTOUT = "cutout";

    public DTNModelProvider_1_21_5(PackOutput output) {
        super(output, "doggytalents");
    }

    protected void registerModels(BlockModelGenerators blockModels, ItemModelGenerators itemModels) {
        this.registerBlocks(blockModels);
        this.registerItem(itemModels);
    }

    private void registerBlocks(BlockModelGenerators blockModels) {
        this.registerDogBed(blockModels);
        this.registerDogBath(blockModels);
        this.registerFoodBowl(blockModels);
        this.registerDoggyCrops(blockModels, DoggyBlocks.RICE_CROP);
        this.registerDoggyCrops(blockModels, DoggyBlocks.SOY_CROP);
        this.registerParticleOnly(blockModels, (Block)DoggyBlocks.RICE_MILL.get(), Blocks.OAK_PLANKS);
    }

    private void registerDogBed(BlockModelGenerators blockModels) {
        ExtendedModelTemplateBuilder template_builder = ExtendedModelTemplateBuilder.builder();
        template_builder.parent(this.vanillaBlockModelParent()).requiredTextureSlot(TextureSlot.PARTICLE).requiredTextureSlot(BEDDING).requiredTextureSlot(CASING).ambientOcclusion(false);
        template_builder.element(b -> b.from(1.6f, 3.2f, 1.6f).to(14.4f, 6.4f, 14.4f).face(Direction.UP, b1 -> b1.texture(BEDDING)).face(Direction.NORTH, b1 -> b1.texture(BEDDING)));
        template_builder.element(b -> b.from(0.0f, 0.0f, 0.0f).to(16.0f, 3.2f, 16.0f).allFaces(this.textureAndCullForDirectionConsumer(CASING, Direction.DOWN)));
        template_builder.element(b -> b.from(11.2f, 3.2f, 0.0f).to(16.0f, 9.6f, 1.6f).allFaces(this.textureAndCullForDirectionConsumer(CASING, Direction.NORTH)));
        template_builder.element(b -> b.from(0.0f, 3.2f, 0.0f).to(4.8f, 9.6f, 1.6f).allFaces(this.textureAndCullForDirectionConsumer(CASING, Direction.NORTH)));
        template_builder.element(b -> b.from(14.4f, 3.2f, 0.0f).to(16.0f, 9.6f, 16.0f).allFaces(this.textureAndCullForDirectionConsumer(CASING, Direction.EAST)));
        template_builder.element(b -> b.from(0.0f, 3.2f, 14.4f).to(16.0f, 9.6f, 16.0f).allFaces(this.textureAndCullForDirectionConsumer(CASING, Direction.SOUTH)));
        template_builder.element(b -> b.from(0.0f, 3.2f, 0.0f).to(1.6f, 9.6f, 16.0f).allFaces(this.textureAndCullForDirectionConsumer(CASING, Direction.WEST)));
        ExtendedModelTemplate template = template_builder.build();
        Function<Block, TextureMapping> default_texture_provider = block -> new TextureMapping().put(TextureSlot.PARTICLE, TextureMapping.getBlockTexture((Block)Blocks.OAK_PLANKS)).put(BEDDING, TextureMapping.getBlockTexture((Block)Blocks.WHITE_WOOL)).put(CASING, TextureMapping.getBlockTexture((Block)Blocks.OAK_PLANKS));
        TexturedModel.Provider template_provider = TexturedModel.createDefault(default_texture_provider, (ModelTemplate)template);
        blockModels.createTrivialBlock((Block)DoggyBlocks.DOG_BED.get(), template_provider);
    }

    private void registerDogBath(BlockModelGenerators blockModels) {
        ExtendedModelTemplateBuilder template_builder = ExtendedModelTemplateBuilder.builder();
        template_builder.parent(this.vanillaBlockModelParent()).requiredTextureSlot(TextureSlot.PARTICLE).requiredTextureSlot(TextureSlot.SIDE).requiredTextureSlot(TextureSlot.BOTTOM).requiredTextureSlot(WATER).ambientOcclusion(false);
        template_builder.element(b -> b.from(1.0f, 0.0f, 1.0f).to(15.0f, 6.0f, 15.0f).face(Direction.UP, b1 -> b1.texture(WATER).tintindex(0)));
        template_builder.element(b -> b.from(1.0f, 0.0f, 1.0f).to(15.0f, 6.0f, 15.0f).face(Direction.DOWN, b1 -> b1.texture(TextureSlot.BOTTOM)));
        template_builder.element(b -> b.from(0.0f, 0.0f, 0.0f).to(16.0f, 8.0f, 1.0f).allFaces(this.textureAndCullForDirectionConsumer(TextureSlot.SIDE, Direction.NORTH)));
        template_builder.element(b -> b.from(15.0f, 0.0f, 0.0f).to(16.0f, 8.0f, 16.0f).allFaces(this.textureAndCullForDirectionConsumer(TextureSlot.SIDE, Direction.EAST)));
        template_builder.element(b -> b.from(0.0f, 0.0f, 15.0f).to(16.0f, 8.0f, 16.0f).allFaces(this.textureAndCullForDirectionConsumer(TextureSlot.SIDE, Direction.SOUTH)));
        template_builder.element(b -> b.from(0.0f, 0.0f, 0.0f).to(1.0f, 8.0f, 16.0f).allFaces(this.textureAndCullForDirectionConsumer(TextureSlot.SIDE, Direction.WEST)));
        ExtendedModelTemplate template = template_builder.build();
        Function<Block, TextureMapping> texture_provider = block -> new TextureMapping().put(TextureSlot.PARTICLE, TextureMapping.getBlockTexture((Block)Blocks.IRON_BLOCK)).put(TextureSlot.SIDE, TextureMapping.getBlockTexture((Block)Blocks.IRON_BLOCK)).put(TextureSlot.BOTTOM, TextureMapping.getBlockTexture((Block)Blocks.IRON_BLOCK)).put(WATER, this.dogBathWaterTexture());
        TexturedModel.Provider template_provider = TexturedModel.createDefault(texture_provider, (ModelTemplate)template);
        blockModels.createTrivialBlock((Block)DoggyBlocks.DOG_BATH.get(), template_provider);
    }

    private ResourceLocation dogBathWaterTexture() {
        return this.blockTextureWithExtent(Blocks.WATER, "_still");
    }

    private void registerFoodBowl(BlockModelGenerators blockModels) {
        AABB bb = new AABB(1.0, 0.0, 1.0, 15.0, 8.0, 15.0);
        FoodBowlBlock block = DoggyBlocks.FOOD_BOWL.get();
        ExtendedModelTemplateBuilder template_builder = ExtendedModelTemplateBuilder.builder();
        template_builder.parent(this.vanillaBlockModelParent()).requiredTextureSlot(TextureSlot.PARTICLE).requiredTextureSlot(TextureSlot.BOTTOM).requiredTextureSlot(TextureSlot.TOP).requiredTextureSlot(TextureSlot.SIDE);
        BiConsumer<Direction, FaceBuilder> foreach_face = (dir, builder) -> builder.cullface((Direction)(dir == Direction.DOWN ? dir : null)).texture(dir.getAxis().isHorizontal() ? TextureSlot.SIDE : (dir == Direction.DOWN ? TextureSlot.BOTTOM : TextureSlot.TOP));
        template_builder.element(b -> b.from((float)bb.minX, (float)bb.minY, (float)bb.minZ).to((float)bb.maxX, (float)bb.maxY, (float)bb.maxZ).allFaces(foreach_face));
        ExtendedModelTemplate template = template_builder.build();
        Function<Block, TextureMapping> texture_provider = $ -> new TextureMapping().put(TextureSlot.PARTICLE, this.blockTextureWithExtent((Block)block, "_bottom")).put(TextureSlot.BOTTOM, this.blockTextureWithExtent((Block)block, "_bottom")).put(TextureSlot.TOP, this.blockTextureWithExtent((Block)block, "_top")).put(TextureSlot.SIDE, this.blockTextureWithExtent((Block)block, "_side"));
        TexturedModel.Provider template_provider = TexturedModel.createDefault(texture_provider, (ModelTemplate)template);
        blockModels.createTrivialBlock((Block)block, template_provider);
    }

    private void registerDoggyCrops(BlockModelGenerators blockModels, Supplier<? extends DogCropBlock> block_supplier) {
        DogCropBlock crop_block = block_supplier.get();
        IntegerProperty age_props = crop_block.getAgeProperty();
        MultiVariantGenerator model = MultiVariantGenerator.dispatch((Block)crop_block).with(PropertyDispatch.initial((Property)age_props).generate(age -> {
            ResourceLocation variant_rl = blockModels.createSuffixedVariant((Block)crop_block, "/stage_" + age, (ModelTemplate)ModelTemplates.CROP.extend().renderType(RENDERTYPE_CUTOUT).build(), TextureMapping::crop);
            return BlockModelGenerators.plainVariant((ResourceLocation)variant_rl);
        }));
        blockModels.blockStateOutput.accept(model);
    }

    private void registerParticleOnly(BlockModelGenerators blockModels, Block block, Block particle_block) {
        Function<Block, TextureMapping> texture_provider = $ -> new TextureMapping().put(TextureSlot.PARTICLE, TextureMapping.getBlockTexture((Block)particle_block));
        TexturedModel.Provider template_provider = TexturedModel.createDefault(texture_provider, (ModelTemplate)ModelTemplates.PARTICLE_ONLY);
        blockModels.createTrivialBlock(block, template_provider);
    }

    private ResourceLocation blockTextureWithExtent(Block block, String extend) {
        return this.blockTextureWithModifyPath(block, x -> x + extend);
    }

    private ResourceLocation blockTextureWithModifyPath(Block block, Function<String, String> path_modifier) {
        ResourceLocation block_texture = TextureMapping.getBlockTexture((Block)block);
        return Util.modifyPath(block_texture, path_modifier);
    }

    private ResourceLocation vanillaBlockModelParent() {
        return ModelLocationUtils.decorateBlockModelLocation((String)this.mcLocation("block").toString());
    }

    private BiConsumer<Direction, FaceBuilder> textureAndCullForDirectionConsumer(TextureSlot texture, Direction cull_direction) {
        return (dir, builder) -> builder.cullface((Direction)(cull_direction == dir ? cull_direction : null)).texture(texture);
    }

    private void registerItem(ItemModelGenerators itemModels) {
        DTItemModelProvider item_model_prov = new DTItemModelProvider();
        item_model_prov.itemGenerators_1_21_5 = itemModels;
        item_model_prov.registerModels();
        item_model_prov.itemGenerators_1_21_5 = null;
    }

    public static void generated(ItemModelGenerators itemModels, Supplier<? extends Item> item_supplier) {
        Item item = item_supplier.get();
        if (item instanceof IDyeableArmorItem) {
            IDyeableArmorItem dyable = (IDyeableArmorItem)item;
            DTNModelProvider_1_21_5.generateSingleDyeable(itemModels, item, dyable);
            return;
        }
        itemModels.generateFlatItem(item, ModelTemplates.FLAT_ITEM);
    }

    public static void generated2(ItemModelGenerators itemModels, Supplier<? extends Item> item, String layer0, String layer1) {
        ResourceLocation layer0_rl = ModelLocationUtils.decorateItemModelLocation((String)Util.getResource(layer0).toString());
        ResourceLocation layer1_rl = ModelLocationUtils.decorateItemModelLocation((String)Util.getResource(layer1).toString());
        DTNModelProvider_1_21_5.generated2(itemModels, item, layer0_rl, layer1_rl);
    }

    public static void generated2(ItemModelGenerators itemModels, Supplier<? extends Item> item_supplier, ResourceLocation layer0, ResourceLocation layer1) {
        Item item = item_supplier.get();
        if (item instanceof DoubleDyableAccessoryItem) {
            DoubleDyableAccessoryItem dyeable = (DoubleDyableAccessoryItem)item;
            DTNModelProvider_1_21_5.generateDoubleDyeable(itemModels, item, dyeable, layer0, layer1);
            return;
        }
        if (item instanceof IDyeableArmorItem) {
            IDyeableArmorItem dyeable = (IDyeableArmorItem)item;
            boolean dye_override = item == DoggyItems.CERE_GARB.get() || item == DoggyItems.MIDI_KEYBOARD.get() || item == DoggyItems.DOG_PLUSHIE_TOY.get();
            int dye_layer = dye_override ? 1 : 0;
            DTNModelProvider_1_21_5.generateSingleDyeable(itemModels, item, dyeable, dye_layer, layer0, layer1);
            return;
        }
        ResourceLocation model = itemModels.generateLayeredItem(item, layer0, layer1);
        itemModels.itemModelOutput.accept(item, ItemModelUtils.plainModel((ResourceLocation)model));
    }

    public static void generateSingleDyeable(ItemModelGenerators itemModels, Item item, IDyeableArmorItem dyable) {
        ResourceLocation item_model = itemModels.createFlatItemModel(item, ModelTemplates.FLAT_ITEM);
        ItemModel.Unbaked item_model_tinted = ItemModelUtils.tintedModel((ResourceLocation)item_model, (ItemTintSource[])new ItemTintSource[]{new Dye(dyable.getDefaultColor(ItemStack.EMPTY))});
        itemModels.itemModelOutput.accept(item, item_model_tinted);
    }

    public static void generateSingleDyeable(ItemModelGenerators itemModels, Item item, IDyeableArmorItem dyable, int dye_layer, ResourceLocation layer0, ResourceLocation layer1) {
        ItemTintSource[] itemTintSourceArray;
        ResourceLocation model = itemModels.generateLayeredItem(item, layer0, layer1);
        Dye dye_tint = new Dye(dyable.getDefaultColor(ItemStack.EMPTY));
        if (dye_layer == 0) {
            ItemTintSource[] itemTintSourceArray2 = new ItemTintSource[2];
            itemTintSourceArray2[0] = dye_tint;
            itemTintSourceArray = itemTintSourceArray2;
            itemTintSourceArray2[1] = ItemModelGenerators.BLANK_LAYER;
        } else {
            ItemTintSource[] itemTintSourceArray3 = new ItemTintSource[2];
            itemTintSourceArray3[0] = ItemModelGenerators.BLANK_LAYER;
            itemTintSourceArray = itemTintSourceArray3;
            itemTintSourceArray3[1] = dye_tint;
        }
        ItemTintSource[] tints = itemTintSourceArray;
        ItemModel.Unbaked item_model_tinted = ItemModelUtils.tintedModel((ResourceLocation)model, (ItemTintSource[])tints);
        itemModels.itemModelOutput.accept(item, item_model_tinted);
    }

    public static void generateDoubleDyeable(ItemModelGenerators itemModels, Item item, DoubleDyableAccessoryItem dyable, ResourceLocation layer0, ResourceLocation layer1) {
        ResourceLocation model = itemModels.generateLayeredItem(item, layer0, layer1);
        ItemModel.Unbaked model_tinted = ItemModelUtils.tintedModel((ResourceLocation)model, (ItemTintSource[])new ItemTintSource[]{DoubleDyableTint_1_21_5.bg(dyable), DoubleDyableTint_1_21_5.fg(dyable)});
        itemModels.itemModelOutput.accept(item, model_tinted);
    }

    public static void handheld(ItemModelGenerators itemModels, Supplier<? extends Item> item) {
        itemModels.generateFlatItem(item.get(), ModelTemplates.FLAT_HANDHELD_ITEM);
    }

    public static void dogBathItem(ItemModelGenerators itemModels, Supplier<? extends Block> block_supplier) {
        Block block = block_supplier.get();
        Item block_item = block.asItem();
        ResourceLocation block_model = ModelLocationUtils.getModelLocation((Block)block);
        ItemModel.Unbaked item_model = ItemModelUtils.tintedModel((ResourceLocation)block_model, (ItemTintSource[])new ItemTintSource[]{new Constant(4159204)});
        itemModels.itemModelOutput.accept(block_item, item_model);
    }
}

