/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.entity.render.misc;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import doggytalents.client.ClientSetup;
import doggytalents.client.backward_imitate.EntityRenderer_1_21_9;
import doggytalents.client.entity.model.misc.GrandPianoModel;
import doggytalents.client.entity.model.misc.UprightPianoModel;
import doggytalents.common.entity.misc.Piano;
import doggytalents.common.lib.Resources;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.joml.Quaternionfc;

public class PianoRenderer
extends EntityRenderer_1_21_9<Piano> {
    private GrandPianoModel model;
    private UprightPianoModel modelUpright;

    public PianoRenderer(EntityRendererProvider.Context ctx) {
        super(ctx);
        this.model = new GrandPianoModel(ctx.bakeLayer(ClientSetup.PIANO));
        this.modelUpright = new UprightPianoModel(ctx.bakeLayer(ClientSetup.PIANO_UPRIGHT));
    }

    @Override
    public ResourceLocation getTextureLocation(Piano piano) {
        Piano.PianoType type = piano.getPianoType();
        Piano.PianoColor color = piano.getPianoColor();
        if (type == Piano.PianoType.GRAND) {
            switch (color) {
                default: {
                    return Resources.PIANO_GRAND_BLACK;
                }
                case WHITE: 
            }
            return Resources.PIANO_GRAND_WHITE;
        }
        if (type == Piano.PianoType.UPRIGHT) {
            switch (color) {
                default: {
                    return Resources.PIANO_UPRIGHT_BLACK;
                }
                case BROWN: {
                    return Resources.PIANO_UPRIGHT_BROWN;
                }
                case WHITE: 
            }
            return Resources.PIANO_UPRIGHT_WHITE;
        }
        return Resources.PIANO_GRAND_BLACK;
    }

    private RenderType getRenderType(Piano piano) {
        return RenderType.entityTranslucent((ResourceLocation)this.getTextureLocation(piano));
    }

    @Override
    public void submit(Piano piano, float p_114486_, float p_114487_, PoseStack stack, EntityRenderer_1_21_9.RenderContext_1_21_9<Piano> context_1_21_9, int light) {
        stack.pushPose();
        stack.scale(-1.0f, -1.0f, 1.0f);
        stack.translate(0.0f, -1.501f, 0.0f);
        stack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(Mth.wrapDegrees((float)piano.getYRot())));
        if (piano.getPianoType() == Piano.PianoType.UPRIGHT) {
            RenderType renderType_1_21_9 = this.getRenderType(piano);
            this.submitModel(context_1_21_9, this.modelUpright, renderType_1_21_9, stack, light, OverlayTexture.NO_OVERLAY, -1);
        } else {
            context_1_21_9.renderState().defferedSetup_1_21_9 = () -> this.model.preparePianoModel(piano);
            RenderType renderType_1_21_9 = this.getRenderType(piano);
            this.submitModel(context_1_21_9, this.model, renderType_1_21_9, stack, light, OverlayTexture.NO_OVERLAY, -1);
        }
        stack.popPose();
    }
}

